/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) 
 *    Greg Byrd (IBM)
 *    Rajalakshmi Iyer (IBM)
 *******************************************************************************/ 

package org.eclipse.higgins.configuration.xml;

import java.util.Map;

import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.configuration.common.SettingDescriptor;

/**
 * PrivateKey setting is map that contains keystore name, alias, and password.
 * Gets keystore from mapSettings, then looks up key by its alias.
 * Returns key.
 * 
 * @author mikemci
 *
 */
public class PrivateKeyHandler extends MapHandler
{
	static private final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog
		(PrivateKeyHandler.class.getName());

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.configuration.xml.ISettingHandler#getSetting(java.lang.String, java.util.Map, java.util.Map, org.w3c.dom.Element)
	 */
	public Object getSetting
		(String strName,
		String strConfigurationBase,
		Map mapSettingHandlers,
		Map mapSettingsGlobal,
		Object settingsParent,
		ISettingDescriptor globalDescriptor,
		ISettingDescriptor settingDescriptor,
		org.apache.axiom.om.OMElement omSetting)
		throws Exception
	{
		log.trace("Setting Name: " + strName + " *Begin PrivateKey*");

		if ( settingDescriptor == null ) { 
			settingDescriptor = new SettingDescriptor(strName, "htf:privatekey");
		}
		
		Map mapPrivateKeySettings = (Map)super.getSetting
			(strName,
			strConfigurationBase,
			mapSettingHandlers,
			mapSettingsGlobal,
			settingsParent,
			globalDescriptor,
			settingDescriptor,
			omSetting);
		
		String strKeyStoreName = (String)mapPrivateKeySettings.get
			("KeyStoreName");
		String strAlias = (String)mapPrivateKeySettings.get
			("Alias");
		String strPassword = (String)mapPrivateKeySettings.get
			("Password");
		// For this implementation, parent must be a Map,
		// and keystore must be a member of parent
		java.security.KeyStore keyStore = 
			(java.security.KeyStore)((java.util.Map)settingsParent).get
			(strKeyStoreName);
		Object objectResult = keyStore.getKey
			(strAlias,
			strPassword.toCharArray());
		
		log.trace("Setting Name: " + strName + " *End PrivateKey*");
		return objectResult;
	}
}
