/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.configuration.xrds;

import java.io.StringWriter;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.axiom.om.OMElement;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.openxri.xml.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * An implementation for the IConfigurationHandler interface that can read from an XRD service endpoint.
 * @see http://wiki.eclipse.org/ContextDiscoveryComponents
 */
public class ConfigurationHandler extends org.eclipse.higgins.configuration.xml.ConfigurationHandler
{
	public static final String HIGGINS_CONF_NS = "http://higgins.eclipse.org/Configuration";

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(ConfigurationHandler.class);

	private Service sep = null;

	/**
	 * Constructor that initializes the class
	 */
	public ConfigurationHandler() {

		log.trace("ConfigurationHandler::ConfigurationHandler");
	}

	public ConfigurationHandler(Service sep) {

		this.sep = sep;
	}

	public void setSEP(Service sep) {

		this.sep = sep;
	}

	public Service getSEP() {

		return(this.sep);
	}

	public synchronized boolean configure(java.util.Map mapConfigurationSettings) throws Exception {

		log.trace("ConfigurationHandler::configure");

		org.apache.axiom.om.OMElement omConfiguration = null;

		try
		{
			DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
			Document document = docBuilder.newDocument();

			Element element = (Element) this.sep.toDOM(document);

			NodeList nodeList = element.getElementsByTagNameNS(HIGGINS_CONF_NS, "Configuration");

			if (nodeList.getLength() < 1) return(false);

			Element configurationElement = (Element) nodeList.item(0);

			StringWriter writer = new StringWriter();
			OutputFormat of = new OutputFormat();
			XMLSerializer serializer = new XMLSerializer(writer, of);
			serializer.asDOMSerializer();
			serializer.serialize(configurationElement);

			omConfiguration = toOM(writer.getBuffer().toString());
		}
		catch (Exception e)
		{
			log.error(e.getLocalizedMessage());
			throw e;
		}

		return configure(omConfiguration, mapConfigurationSettings);
	}

	/**
	 * Converts a DOM Element to an AXIOM OMElement. This is done by serializing to a String and then parsing it again.
	 * @todo There is probably a better way to do this...
	 * @param element The DOM Element object to be converted
	 * @return The AXIOM OMElement object
	 * @throws Exception 
	 */
	protected static OMElement DOMtoOM(Element element) throws Exception {

		StringWriter writer = new StringWriter();
		OutputFormat of = new OutputFormat();
		XMLSerializer serializer = new XMLSerializer(writer, of);
		serializer.serialize(element);

		OMElement omElement = toOM(writer.getBuffer().toString());

		return(omElement);
	}
}