/*******************************************************************************
 * Copyright (c) 2006 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut of interfaces agreed upon 20060707
 *******************************************************************************/

package org.eclipse.higgins.idas.api;

import java.net.URI;

import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.api.model.IModel;

/**
 * As defined at 
 * <a href="http://wiki.eclipse.org/Entity">http://wiki.eclipse.org/Entity</a> 
 * and <a href="http://wiki.eclipse.org/Context">http://wiki.eclipse.org/Context</a>, 
 * This interface holds a set of {@link IEntity} objects.<p>
 * All Entities follow the http://www.eclipse.org/higgins/ontologies/2006/higgins ontology
 * as a base. As such, each Entity has the attribute 
 * http://www.eclipse.org/higgins/ontologies/2006/higgins#uniqueIdentifier. {@link #getEntityID()}
 * provides a shortcut to access the value of this attribute.
 * TODO (Doc): Finish javadoc on methods   
 */
public interface IEntity extends IHasMetadata, IHasAttributes
{
	/**
	 * @return The Context holding this Entity.
	 * @throws IdASException
	 */
	public IContext getContext() throws IdASException;

	/**
	 * Returns the Contextually unique identifier of this Entity. 
	 * This is a convenience method equivalent to reading the entity's 
	 * http://www.eclipse.org/higgins/ontologies/2006/higgins#uniqueIdentifier attribute.
	 * 
	 * @return Contextually unique identifier of this Entity
	 * @throws IdASException
	 */
	public String getEntityID() throws IdASException;
	
	/**
	 * Returns the type of this Entity.  For example: http://www.eclipse.org/higgins/ontologies/2006/person#Person<p>
	 * @return This Entity's type
	 * @throws IdASException
	 * @deprecated Instead, call {@link IEntity#getModel()} and from that call {@link IModel#getType()}.  
	 * Doing this is equivalent to calling this method.
	 */
	public URI getEntityType() throws IdASException;

	/**
	 * Removes this Entity from its Context.
	 * Note: This operation is only applied to any backing data store after
	 * {@link IContext#applyUpdates()} is called. <br>
	 * Note: It is invalid to call subsequent update operations on this 
	 * IEntity instance or on any elements held by this Entity 
	 * or by any of its sub-elements.
	 * 
	 * @throws IdASException
	 */
	void remove() throws IdASException;	
	
	/**
	 * Returns a model of this type of Entities as it defined in the
	 * context's schema. Returned model could be used to discover what
	 * attributes are defined in the context's schema for this type of Entities.
	 * 
	 * @return the model of this Entity
	 * @throws IdASException
	 */
	public IEntityModel getModel() throws IdASException;
}
