/*******************************************************************************
 * Copyright (c) 2008 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.net.URI;

import org.eclipse.higgins.idas.api.IHasMetadata;
import org.eclipse.higgins.idas.api.IMetadataValue;
import org.eclipse.higgins.idas.api.ISimpleMetaValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.model.IMetadataValueModel;

public class AbstractSimpleMetaValue implements ISimpleMetaValue {

	private URI _type;
	private Object _data;
	private IMetadataValueContainer _container;

	public AbstractSimpleMetaValue() throws IdASException {
	}

	/**
	 * Note that the container's updateNotification is not called while 
	 * the value in data is being added.
	 * @param type
	 * @param data
	 * @param container
	 */
	protected void init(URI type, Object data, IMetadataValueContainer container) {
		_type = type;
		_data = data;
		_container = container;
	}

	/**
	 * Default implementation of getLexical calls toString() on the backing datatype.
	 */
	public String getLexical() throws IdASException {
		return (String)getData().toString();
	}

	/**
	 * Default implementation of getCanonical calls toString() on the backing datatype.
	 */
	public String getCanonical() throws IdASException {
		return (String)getData().toString();
	}

	/**
	 * returns true
	 */
	public boolean isSimple() throws IdASException {
		return true;
	}

	public URI getDataType() throws IdASException {
		return _type;
	}
	/**
	 * Returns the data object backing this value
	 */
	public Object getData() throws IdASException {
		return _data;
	}
	
	/**
	 * @param data The backing data object to be set.
	 */
	public void setData(Object data) throws IdASException {
		if (_container != null) {
			MetadataValueNotification metaValueNotif = new MetadataValueNotification(this, MetadataValueNotification.UPDATE_SET_DATA, _data);
			_container.updateNotification(metaValueNotif);
		}
		_data = data;
	}
	
	public void remove() throws IdASException {
		if (_container != null) {
			MetadataValueNotification metaValueNotif = new MetadataValueNotification(this, MetadataValueNotification.UPDATE_REMOVE, null);
			_container.updateNotification(metaValueNotif);
		}
	}
	
	public boolean equals(IMetadataValue value) throws IdASException {
		if (value.isSimple() == false)
			return false;
		if (this.getModel().getType() != value.getModel().getType())
			return false;
		if (this.equals((IHasMetadata)value) == false)
			return false;
		ISimpleMetaValue val = (ISimpleMetaValue)value;
		return this.getCanonical().equals(val.getCanonical());
	}
	
	public IMetadataValueModel getModel() throws IdASException {
		throw new NotImplementedException();
	}
	

}
