/*******************************************************************************
 * Copyright (c) 2006 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.net.URI;

import org.eclipse.higgins.idas.api.IFilterMetadataAssertion;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicFilterMetadataAssertion extends BasicFilterAssertion implements IFilterMetadataAssertion {

	private IMetadata _assertion;
	
	public BasicFilterMetadataAssertion() {
		super();
	}

	public BasicFilterMetadataAssertion(URI id, String comparator) throws IdASException {
		super(id, false, comparator);
	}

	public BasicFilterMetadataAssertion(URI id, boolean bIncludeSubtypes, String comparator) throws IdASException {
		super(id, bIncludeSubtypes, comparator);
	}

	public BasicFilterMetadataAssertion(URI id, String comparator, IMetadata assertionValue) throws IdASException {
		super(id, comparator);
		setAssertionValue(assertionValue);
	}

	public BasicFilterMetadataAssertion(URI id, boolean bIncludeSubtypes, String comparator, IMetadata assertionValue) throws IdASException {
		super(id, bIncludeSubtypes, comparator);
		setAssertionValue(assertionValue);
	}

	public void setAssertionValue(IMetadata assertion)
			throws IdASException {
		_assertion = assertion;
	}
	
	public IMetadata getAssertionValue () throws IdASException {
		return _assertion;
	}
}
