/*******************************************************************************
 * Copyright (c) 2006 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.api;

/**
 * Represents a filter assertion about a Entity's ID 
 * (see {@link org.eclipse.higgins.idas.api.IEntity#getEntityID()}).<p>
 * This assertion is made up of a comparator (operator), and assertion value.<p>
 * The filter assertion is true for a Entity when: <p>
 * TODO (Doc): add assertion rules <p>
 *  
 * The particular form of the String used as an assertion is dictated by the comparator.
 */
public interface IFilterEntityIDAssertion extends IFilterAssertion {

	/**
	 * Compares true when a tested Entity has a unique ID equal to the specified assertion value.<P> 
	 * Value: {@value}
	 */
	public static final String COMP_ENTITYID_EQ = "urn:org.eclipse.higgins.idas.api.comparator.entityid.equality";

	/**
	 * Specifies the assertion data to be tested against an IEntity's unique ID.
	 * 
	 */
	public void setAssertionValue(String assertion) throws IdASException;
	
}
