/*******************************************************************************
 * Copyright (c) 2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/
package org.eclipse.higgins.idas.api;

/**
 * Thrown in cases where an attribute is expected to have a single value but doesn't.
 * This is not the same case as when an attribute's model dictates that the 
 * attribute is capable of only holding a single value.  For that case, see
 * {@link NotSingleValuedAttributeException}.
 * This exception may be thrown when an attribute, while capable of holding
 * multiple values, is expected to hold only one by virtue of the application
 * which is accessing that attribute. 
 */
public class MultipleValuesExistException extends IdASException {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2543646999202002469L;

	/**
	 * @see IdASException#IdASException()
	 */
	public MultipleValuesExistException() {
		super();
	}

	/**
	 * @param message
	 * @see IdASException#IdASException(String)
	 */
	public MultipleValuesExistException(String message) {
		super(message);
	}

	/**
	 * @param message
	 * @param cause
	 * @see IdASException#IdASException(String, Throwable)
	 */
	public MultipleValuesExistException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param cause
	 * @see IdASException#IdASException(Throwable)
	 */
	public MultipleValuesExistException(Throwable cause) {
		super(cause);
	}

}
