/*******************************************************************************
 * Copyright (c) 2006 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.net.URI;

import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicFilterAttributeAssertion  extends BasicFilterAssertion 
		implements IFilterAttributeAssertion {
	
	private IFilter _metaAttrFilter;
	private IAttributeValue _assertion;
	
	public BasicFilterAttributeAssertion() {
		super();
	}

	public BasicFilterAttributeAssertion(URI id, String comparator) throws IdASException {
		super(id, false, comparator);
	}

	public BasicFilterAttributeAssertion(URI id, boolean bIncludeSubtypes, String comparator) throws IdASException {
		super(id, bIncludeSubtypes, comparator);
	}

	public BasicFilterAttributeAssertion(URI id, String comparator, IAttributeValue assertionValue) throws IdASException {
		super(id, comparator);
		setAssertionValue(assertionValue);
	}

	public BasicFilterAttributeAssertion(URI id, boolean bIncludeSubtypes, String comparator, IAttributeValue assertionValue) throws IdASException {
		super(id, bIncludeSubtypes, comparator);
		setAssertionValue(assertionValue);
	}

	public void setAssertionValue(IAttributeValue assertion)
			throws IdASException {
		_assertion = assertion;
	}
	
	public IAttributeValue getAssertionValue () throws IdASException {
		return _assertion;
	}
	

	public void setAttributeFilter(IFilter attributeFilter) throws IdASException {
		_metaAttrFilter = attributeFilter;
	}

	public IFilter getAttributeFilter() throws IdASException {
		return _metaAttrFilter;
	}
}
