/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.util.Iterator;

import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicSingleValuedAttribute extends BasicAttribute implements ISingleValuedAttribute{

	public BasicSingleValuedAttribute(IAttribute copyFrom, IContext context) throws IdASException {
		super(copyFrom, null, context);
	}

	/**
	 * @throws IdASException 
	 * 
	 */
	public BasicSingleValuedAttribute(IAttribute copyFrom, IAttributeContainer container, IContext context) throws IdASException {
		super(copyFrom, container, context);
	}

	/**
	 * @throws IdASException 
	 * 
	 */
	public BasicSingleValuedAttribute(URI type, IContext context) throws IdASException {
		super(type, (Iterator) null, null, context);
	}

	/**
	 * @throws IdASException 
	 * 
	 */
	public BasicSingleValuedAttribute(URI type, IAttributeValue value, IContext context) throws IdASException {
		super(type, value, null, context);
	}
	
	
	public IAttributeValue getValue() throws IdASException {
		Iterator iter = getValues();
		return (IAttributeValue) iter.next() ;
	}

	public boolean isSingleValued() {
		return true;
	}
}
