/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial cut of interfaces
 *     Jim Sermersheim (Novell) Update to 20070319 interfaces
 *******************************************************************************/

package org.eclipse.higgins.idas.api.model;

import java.net.URI;
import java.util.Iterator;

import org.eclipse.higgins.idas.api.IdASException;

/**
 * Represents a model of a entity as it defined in the context's ontology model.
 * <p>
 * The type returned by
 * {@link org.eclipse.higgins.idas.api.model.IModel#getType()}
 * could be used in
 * {@link org.eclipse.higgins.idas.api.IContext#addEntity(URI, String)} to
 * create an {@link org.eclipse.higgins.idas.api.IEntity} of the represented
 * type.
 * 
 * @see org.eclipse.higgins.idas.api.IEntity#getModel()
 */
public interface IEntityModel extends IModel {
	/**
	 * Returns IAttributeModels for the attributes
	 * which are defined (allowed) in this entity model.
	 * @return Iterator of {@link IAttributeModel}
	 * @see org.eclipse.higgins.idas.api.IHasAttributes#getAttributes()
	 *      IEntity.getAttributes()
	 * @throws IdASException 
	 */
	public Iterator getAttributeModels() throws IdASException;

	/**
	 * Returns IAttributeModel for the specified attribute ID
	 * 
	 * @param attrID the ID of attribute.
	 * @return attribute's model of requested ID or <code>null</code> if
	 *         the specified attrID is not defined or not valid for this
	 *         entity model.
	 * @throws IdASException 
	 */
	public IAttributeModel getAttributeModel(URI attrID) throws IdASException;	
}
