/*******************************************************************************
 * Copyright (c) 2008 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Duane Buss
 *******************************************************************************/
package org.eclipse.higgins.idas.common;

import java.net.URI;
import java.util.Iterator;

import org.eclipse.higgins.idas.api.IExtension;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IFilter;

/**
 * When this extension is present, it specifies that 
 * {@link IContext#getEntities(IFilter, Iterator, IExtension[])} will ignore the passed IFilter, and 
 * will 
 * Operations that this extension is valid for include: {@link IContext#open(Object, IExtension[])}
 */
public class ContextSpecificFilterExtension implements IExtension {
	private static final String id = "http://www.eclipse.org/higgins/idas/extension/contextspecificfilter";
	public static URI identifierURI;
	private boolean failUnsupported;
	private Object _filter;
	private static RuntimeException earlyException;

	   /**
	    * Static initializer that initializes the identifierURI
	    * class field so that we can catch any exceptions thrown
	    * by URI(String) and transform them into a RuntimeException.
	    * Such exceptions should never happen but should be reported
	    * properly if they ever do.
	    */
	   static {
	       try {
	           identifierURI = new URI(id);
	       } catch (Exception e) {
	           earlyException = new IllegalArgumentException();
	           earlyException.initCause(e);
	       }
	   };

	/**
	 * By default, we'll have {@link #failIfUnsupported()} returns true. 
	 * It doesn't make much sense for a caller to want this extension to silently fail.
	 */
	public ContextSpecificFilterExtension(Object filter) {
		if ( earlyException != null)
			throw earlyException;
		
		this.failUnsupported = true;
		_filter = filter;
	}
	
	public URI getID() {
		return identifierURI;
	}

	public boolean failIfUnsupported() {
		return failUnsupported;
	}

	public Object getFilter() {
		return _filter;
	}
	
}
