/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *    Tom Doman
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;

public class AttributeValueNotification
{
	/**
	 * This action is set when the {@link IAttributeValue} returned by {@link #getAttributeValue()} was added
	 */
	public static final String UPDATE_ADD = "urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_ADD";
	/**
	 * This action is set when the {@link IAttributeValue} returned by {@link #getAttributeValue()} was removed
	 */
	public static final String UPDATE_REMOVE = "urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_REMOVE";
	/**
	 * This action is set when the {@link Object} returned by {@link #getOldValueData()} was replaced.
	 * This implies that this attribute value is simple, and signifies that the data in this simple attribute
	 * value was set (or reset). The old value data is returned by {@link #getOldValueData()}, 
	 * and the new value data exists in the {@link ISimpleAttrValue#getData()} returned by {@link #getAttributeValue()}.
	 * The old value data will be null in the event that the data is being set for the first time. 
	 */
	public static final String UPDATE_SET_DATA = "urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_SET_DATA";
	/**
	 * This action is set when there is a {@link AttributeNotification} to be returned by {@link #getAttributeNotification()}
	 * When the attribute value is simple, this would happen when an update took place on a meta-attribute (attribute on this attribute).
	 * When the attribute value is complex, this happens when a sub-element of this complex attribute value is updated.
	 */
	public static final String UPDATE_ATTRIBUTE_NOTIFY = "urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_ATTRIBUTE_NOTIFY";

	private IAttributeValue _attrVal;
	private String _action;
	private Object _oldValData;
	private AttributeNotification _attrNotif;
	
	/**
	 * 
	 * @param attrVal
	 * @param action
	 * @param oldValData
	 */
	public AttributeValueNotification(
		IAttributeValue attrVal,
		String action,
		Object oldValData)
	{
		_attrVal = attrVal;
		_action = action;
		_oldValData = oldValData;
	}
	
	/**
	 * 
	 */
	public IAttributeValue getAttributeValue()
	{
		return _attrVal;
	}

	/**
	 */
	public String getAction()
	{
		return _action;
	}

	/**
	 */
	public Object getOldValueData()
	{
		return _oldValData;
	}
	
	public AttributeNotification getAttributeNotification() {
		return _attrNotif;
	}
}
