/*******************************************************************************
 * Copyright (c) 2008 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *******************************************************************************/
package org.eclipse.higgins.idas.api;

import org.eclipse.higgins.idas.api.model.IEntityModel;

/**
 * Supertype for IEntity and complex attributes.
 *
 */
public interface IBlankEntity extends IHasAttributes {

	/**
	 * Returns a model of this type of Entities as it defined in the
	 * context's schema. Returned model could be used to discover what
	 * attributes are defined in the context's schema for this type of Entities.
	 * 
	 * @return the model of this Entity
	 * @throws IdASException
	 */
	public IEntityModel getModel() throws IdASException;
}
