/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.idas.api.model;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;

/**
 * This interface could be implemented by IdAS context providers so that their
 * {@link org.eclipse.higgins.idas.api.model.IContextModel} instances may be
 * instantiated.
 * TODO Add basic implementation to IdAS itself.
 */
public interface IContextModelFactory {
	/**
	 * Creates IContextModel representation of context's ontology model supplied
	 * as the parameter.
	 * 
	 * @param schema
	 *            the URI of context's ontology model's location.
	 * @return IContextModel representation of context's ontology model.
	 * @throws IdASModelException
	 *             if model representation coudn't be created.
	 */
	public IContextModel createContextModel(URI schema)
			throws IdASModelException;

	/**
	 * Creates IContextModel representation of context's ontology model supplied
	 * as the parameter.
	 * 
	 * @param schema
	 *            the URL of context's ontology model's location.
	 * @return IContextModel representation of context's ontology model.
	 * @throws IdASModelException
	 *             if model representation coudn't be created.
	 */
	public IContextModel createContextModel(URL schema)
			throws IdASModelException;

	/**
	 * Creates IContextModel representation of context's ontology model supplied
	 * as the parameter.
	 * 
	 * @param schema
	 *            the String representation of context's ontology model's
	 *            location.
	 * @return IContextModel representation of context's ontology model.
	 * @throws IdASModelException
	 *             if model representation coudn't be created.
	 */
	public IContextModel createContextModel(String schema)
			throws IdASModelException;

	/**
	 * Creates IContextModel representation of context's ontology model supplied
	 * as the parameter.
	 * 
	 * @param schema
	 *            the InputStream containing of context's ontology model.
	 * @return IContextModel representation of context's ontology model.
	 * @throws IdASModelException
	 *             if model representation coudn't be created.
	 */
	public IContextModel createContextModel(InputStream schema)
			throws IdASModelException;
}
