/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Bruce Rich (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 
package org.eclipse.higgins.crpps.app;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.higgins.crpps.Activator;

/**
 * Ensure that this plug-in's preferences are initialized before another
 * plug-in can reference them.  This functionality builds off the
 * org.eclipse.core.runtime.preferences extension point.
 * @author brich
 *
 */
public class PreferenceInitializer extends AbstractPreferenceInitializer {

	public PreferenceInitializer() {
		super();
	}

	public void initializeDefaultPreferences() {
		IEclipsePreferences defaults = new DefaultScope().getNode(Activator.PLUGIN_ID);
		defaults.putFloat(Activator.LEFT_PANE_RATIO, 0.6f);
		defaults.putFloat(Activator.RIGHT_PANE_RATIO, 0.4f);
		defaults.putInt(Activator.SHELL_WIDTH, 1000);
		defaults.putInt(Activator.SHELL_HEIGHT, 700);
		defaults.putInt(Activator.SHELL_LOCATION_X, -1); // indicate not yet set
		defaults.putInt(Activator.SHELL_LOCATION_Y, -1); // indicate not yet set		
	}

}
