package org.eclipse.higgins.crpps.ui;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.higgins.crpps.ui.dialogs.ConfirmAbandonEdit;
import org.eclipse.higgins.crpps.ui.dialogs.PasswordDialog;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.provider.cardspace.common.ManagedCard;
import org.eclipse.higgins.icard.provider.cardspace.common.PersonalCard;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class BrowseComposite implements ICardEdit {
	
	private ICard card;
	private ICardEditView icev;
	private ScrolledForm form;
	private Composite myComposite;
	private Composite myParent;
	private FormToolkit toolkit;
	private Button protectButton;

	private Log log = LogFactory.getLog(BrowseComposite.class);

//	private Text idText = null;
//	private Text cuidText = null;
	private Text issuerText = null;
	private Text issuerNameText = null;
	private Text timeissuedText = null;
	private Text requireAppliesToText = null;
	private Table claimTypeList = null;

	private Text cardName = null;
	private Text cardType = null;
	
	private Button modifyButton;
	
	private int totalWidth = 400-20;
	private int firstColumnWidth = 125;
	private int secondColumnWidth = totalWidth - firstColumnWidth - 30;

	public BrowseComposite(Composite parent, final ICardEditView icev, FormToolkit toolkit) {
		this.icev = icev;
		this.myParent = parent;
		this.toolkit = toolkit;
		//final Shell shell = parent.getShell();
		//parent.setLayout(new FillLayout());
		reset();
	}
	
	/**
	 * Update the visualized information with data from the card
	 * @param card
	 */
	public void notifySelectionChanged(ICard card) {
		log.info("notifySelectionChanged");
		this.card = card; // remember the card for modify
//		if (card.isEditable())
//			this.isEditable = true;
		if (this.modifyButton != null)
			this.modifyButton.setEnabled(true);
		cardName.setText(card.getName());
		cardType.setText(card.getDescription());

//		idText.setText(card.getID());
//		cuidText.setText(card.getCUID().toString());
		issuerText.setText(card.getIssuer());

		String issuer = card.getIssuerName();
		if (issuer == null) issuer = "Not specified";		
		issuerNameText.setText(issuer);

		Date time = card.getTimeIssued();
		String timeStr = "Not specified";
		String dateStr = "Not specified";
		if (time != null) {
			timeStr = time.toString();
			dateStr = DateFormat.getDateInstance().format(time);
		}
		timeissuedText.setText(timeStr);
		
		String state = null;
		Color color = null;
		if (card instanceof ManagedCard) {
			Boolean rat = ((ManagedCard)card).getRequireAppliesTo();
			if (rat != null) {
				if (rat.booleanValue()) {
					state = "Tracking optional";
				} else {
					state = "Tracking required";
					color = new Color(Display.getCurrent(),255,0,0);
				}
			}
		}
		if (state == null)
			state = "No Tracking";
		if (color == null)
			color = new Color(Display.getCurrent(),0,0,0);
		requireAppliesToText.setText(state);
		requireAppliesToText.setForeground(color);

		boolean claimValueAccessable = true;
		if(card instanceof ManagedCard){
			claimValueAccessable = false;
		}
		
		if(card instanceof PersonalCard){
			switch(((PersonalCard)card).getPinStatus()){
			case PersonalCard.NO_PIN:
				this.protectButton.setEnabled(true);
				this.protectButton.setText("Lock");
				break;
			case PersonalCard.UNLOCKED:
				this.protectButton.setVisible(false);
				break;
			case PersonalCard.LOCKED:				
				this.protectButton.setEnabled(true);
				this.protectButton.setText("Unlock");
				claimValueAccessable = false;
			};
			this.protectButton.setData(card);
			
			protectButton.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					Object data = protectButton.getData();
					if(data!=null && (data instanceof PersonalCard)){
						PersonalCard pcard = (PersonalCard) data;
						int pinStatus = pcard.getPinStatus();
						if(PersonalCard.LOCKED== pinStatus)
							unlockTheCard((ICard)data);
						else
							lockTheCard((ICard)data);						
					}				
				}
			});
		}
		
		this.claimTypeList.removeAll();
		Iterator claims = card.getSupportedClaimTypes();
		
		if (claims == null) {
			log.debug("getting claims: no claims");		
		} else {
			log.debug("getting claims: "+claims);
			while (claims.hasNext()) {
				IClaimType type = (IClaimType) claims.next();
				IClaim claim = null;
				try {
					claim = card.getClaim(type.getType());
				}catch(Exception e){				
					log.error("Error when getting claims", e);
				}

				String value = "";
				if (claim != null && claim instanceof ISimpleClaim) {
					ISimpleClaim simpleClaim = (ISimpleClaim) claim;
					List l = simpleClaim.getValues();
					if (l!=null && l.size() > 0) {
						value = (String) l.get(0);
					}
				}

				TableItem ti = new TableItem(this.claimTypeList, SWT.NONE);
				ti.setText(0, type.getDisplayName());
				if(!claimValueAccessable){
					ti.setText(1, "Not accessable");
				} else {
					ti.setText(1, value);
				}
			}
		}
	}
	
	private void lockTheCard(ICard card){
		log.info("Lock the card");
		//TODO
	}
	
	private void unlockTheCard(ICard card){
		log.info("Unlock the card");
		PasswordDialog pd = new PasswordDialog(myComposite.getShell());
		pd.create();
		pd.open();
		
		PersonalCard personalCard = (PersonalCard) card;		
		final String password = pd.getPassword();
				
		try {
			boolean pass = personalCard.validatePINCode(password);
			if(pass){
				personalCard.unlock(new IPinCodeCredential(){
					public byte[] getPinCode() {
						try {
							return password.getBytes("UTF-8");
						} catch (UnsupportedEncodingException e) {
							e.printStackTrace();
						}
						return null;
					}
					public void setPinCode(byte[] pin) {}
					public Callback[] getCallbacks() {return null;}
				});
				
				this.protectButton.setVisible(false);
				
				this.claimTypeList.removeAll();
				Iterator claims = card.getSupportedClaimTypes();
				
				if (claims == null) {
					log.debug("getting claims: no claims");		
				} else {
					log.debug("getting claims: "+claims);
					while (claims.hasNext()) {
						IClaimType type = (IClaimType) claims.next();
						IClaim claim = null;
						try {
							claim = card.getClaim(type.getType());
						}catch(AuthenticationRequiredException e){
						}catch(InvalidTypeException e){ 
						}catch (CardException e) {
							log.error("Error when getting claims", e);
						}
						String value = "";
						if (claim != null && claim instanceof ISimpleClaim) {
							ISimpleClaim simpleClaim = (ISimpleClaim) claim;
							List l = simpleClaim.getValues();
							if (l!=null && l.size() > 0) {
								value = (String) l.get(0);
							}
						}

						TableItem ti = new TableItem(this.claimTypeList, SWT.NONE);
						ti.setText(0, type.getDisplayName());
						ti.setText(1, value);	
					}
				}
			} else {
				MessageBox mb = new MessageBox(myComposite.getShell(), SWT.ERROR_FAILED_EXEC);
				mb.setMessage("Your PIN code is invalid.");
				mb.setText("Error");
				mb.open();
			}
		} catch (Exception e) {
			e.printStackTrace();
		} 
	}
	
	public Composite getComposite() {
		return this.myComposite;
	}
	
	public boolean isCardDirty() {
		return false;
	}

	public void reset() {
		if (this.myComposite != null) {
			myComposite.dispose();
			myComposite = null;
		}
		form = toolkit.createScrolledForm(myParent);
		this.myComposite = form;
		Composite mainComp = form.getBody();		
		mainComp.setLayout(new FormLayout());
		//mainComp.setLayout(new TableWrapLayout());

		form.setText("Detailed information about the selected i-card");
		Path path = new Path("/image/form_banner.gif");
		URL url = FileLocator.find(Platform.getBundle("org.eclipse.higgins.crpps"), 
				path, null);
		ImageDescriptor imageDesc = ImageDescriptor.createFromURL(url);
		form.setBackgroundImage(imageDesc.createImage());
		
//		Composite separator = toolkit.createCompositeSeparator(mainComp);
//		FormData fd = new FormData();
//		fd.top = new FormAttachment(form, 5);
//		fd.left = new FormAttachment(0, 0);
//		fd.right = new FormAttachment(100, 0);
//		fd.height = 1;
//		separator.setLayoutData(fd);

		//Composite controlComp = new Composite(mainComp, SWT.BORDER);
		Composite controlComp = toolkit.createComposite(mainComp);
		controlComp.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
		FormData fd = new FormData();
		fd.top = new FormAttachment(mainComp, 0);
		fd.left = new FormAttachment(0, 0);
		fd.width = totalWidth;
//		fd.right = new FormAttachment(100, 0);
		// fd.bottom = new FormAttachment(10, 0);
		controlComp.setLayoutData(fd);
		controlComp.setLayout(new RowLayout());

		this.modifyButton = new Button(controlComp, SWT.NONE);
		modifyButton.setText("Edit");
		modifyButton.setEnabled(false);
		final Shell shell = myParent.getShell();
		modifyButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				log.info("edit card");
				int resp = IDialogConstants.OK_ID;
				if (icev.isCardDirty()) {
					ConfirmAbandonEdit cae = new ConfirmAbandonEdit(shell);
					cae.setBlockOnOpen(true);
					resp = cae.open();
				}
				if (resp == IDialogConstants.OK_ID) {
					icev.modify();
				}
			}
		});

		protectButton = new Button(controlComp, SWT.NONE);
		protectButton.setEnabled(false);
		protectButton.setText("Lock");
		
//		Composite separator = toolkit.createCompositeSeparator(mainComp);
//		fd = new FormData();
//		fd.top = new FormAttachment(controlComp, 5);
//		fd.left = new FormAttachment(0, 0);
//		fd.right = new FormAttachment(100, 0);
//		fd.height = 1;
//		separator.setLayoutData(fd);
		
		Label separator = toolkit.createLabel(mainComp, "", SWT.BORDER | SWT.HORIZONTAL);
		fd = new FormData();
		fd.top = new FormAttachment(controlComp, 5);
		fd.left = new FormAttachment(0, 0);
		fd.width = totalWidth;
//		fd.right = new FormAttachment(100, 0);
		separator.setLayoutData(fd);

		/* 
		 * Create the visualization for the card
		 */
		//Composite cardNameComp = mainComp;
		Composite cardNameComp = toolkit.createComposite(mainComp);
		fd = new FormData();
		fd.top = new FormAttachment(separator, 5);
		fd.left = new FormAttachment(0, 0);
		fd.width = totalWidth;
//		fd.right = new FormAttachment(100, 0);
		//fd.bottom = new FormAttachment(0, 100);
		cardNameComp.setLayoutData(fd);
		cardNameComp.setLayout(new FormLayout());
		cardNameComp.setBackground(new Color(Display.getCurrent(), 255, 255, 255));

		this.cardName = new Text(cardNameComp, SWT.WRAP);
		cardName.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
		fd = new FormData();
		fd.top = new FormAttachment(0, 0);
		fd.left = new FormAttachment(0, 10);
//		fd.right = new FormAttachment(100, -10);
		fd.width = totalWidth-10;
		this.cardName.setLayoutData(fd);
		FontData fontData = new FontData();
		fontData.setHeight(20);
		fontData.setName("Arial");
		fontData.setStyle(SWT.BOLD);
		Font font = new Font(Display.getDefault(), fontData);
		this.cardName.setFont(font);

		this.cardType = new Text(cardNameComp, SWT.WRAP);
		cardType.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
		fd = new FormData();
		fd.top = new FormAttachment(cardName, 5);
		fd.left = new FormAttachment(0, 10);
//		fd.right = new FormAttachment(100, -10);
		fd.width = totalWidth-10;
		this.cardType.setLayoutData(fd);
		fontData = new FontData();
		fontData.setHeight(8);
		font = new Font(Display.getDefault(), fontData);
		this.cardType.setFont(font);

		Label line2 = new Label(cardNameComp, SWT.SEPARATOR | SWT.HORIZONTAL);
		fd = new FormData();
		fd.top = new FormAttachment(cardType, 10);
		fd.left = new FormAttachment(0, 0);
		fd.width = totalWidth;
//		fd.right = new FormAttachment(100, 0);
//		fd.width = 600;
		line2.setLayoutData(fd);

//		Composite line2 = toolkit.createCompositeSeparator(cardNameComp);
//		fd = new FormData();
//		fd.top = new FormAttachment(cardType, 5);
//		fd.left = new FormAttachment(0, 0);
//		fd.right = new FormAttachment(100, 0);
//		fd.height = 1;
//		line2.setLayoutData(fd);

//		Label idLabel = toolkit.createLabel(cardNameComp, "ID: ", SWT.NONE);
//		idLabel.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
//		fd = new FormData();
//		fd.top = new FormAttachment(cardType, 20);
//		fd.left = new FormAttachment(0, 10);
//		fd.right = new FormAttachment(20, 0);
//		idLabel.setLayoutData(fd);
//
//		idText = new Text(mainComp, SWT.BORDER | SWT.WRAP);
//		idText.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
//		idText.setEditable(false);
//		fd = new FormData();
//		fd.top = new FormAttachment(line2, 10);
//		fd.left = new FormAttachment(idLabel, 5);
//		fd.right = new FormAttachment(90, 0);
//		idText.setLayoutData(fd);
		
//		idText = toolkit.createText(cardNameComp, "", SWT.BORDER | SWT.WRAP);
//		idText.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
//		idText.setEditable(false);
//		fd = new FormData();
//		fd.top = new FormAttachment(idLabel, 0);
//		fd.left = new FormAttachment(idLabel, 5);
//		fd.right = new FormAttachment(95, 0);
//		idText.setLayoutData(fd);
//
//		Label cuidLabel = toolkit.createLabel(cardNameComp, "UUID: ", SWT.None);
//		cuidLabel.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
//		fd = new FormData();
//		fd.top = new FormAttachment(idText, 10);
//		fd.left = new FormAttachment(0, 10);
//		fd.right = new FormAttachment(20, 0);
//		cuidLabel.setLayoutData(fd);
//
////		cuidText = new Text(mainComp, SWT.BORDER | SWT.WRAP);
////		cuidText.setEditable(false);
//		cuidText = toolkit.createText(cardNameComp, "", SWT.BORDER | SWT.WRAP);
//		cuidText.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
//		cuidText.setEditable(false);
//		fd = new FormData();
//		fd.top = new FormAttachment(idText, 10);
//		fd.left = new FormAttachment(cuidLabel, 5);
//		fd.right = new FormAttachment(95, 0);
//		cuidText.setLayoutData(fd);

		Label issuerLabel = toolkit.createLabel(cardNameComp, "Issuer: ", SWT.NONE);
		issuerLabel.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
		fd = new FormData();
		fd.top = new FormAttachment(line2, 10);
		fd.left = new FormAttachment(0, 10);
//		fd.right = new FormAttachment(20, 0);
		fd.width = firstColumnWidth;
		issuerLabel.setLayoutData(fd);

//		issuerText = new Text(mainComp, SWT.BORDER | SWT.WRAP);
		issuerText = toolkit.createText(cardNameComp, "", SWT.BORDER | SWT.WRAP);
		issuerText.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
		issuerText.setEditable(false);
		fd = new FormData();
		fd.top = new FormAttachment(line2, 10);
		fd.left = new FormAttachment(issuerLabel, 0);
//		fd.right = new FormAttachment(95, 0);
		fd.width = secondColumnWidth;
		issuerText.setLayoutData(fd);

		Label issuerNameLabel = toolkit.createLabel(cardNameComp, "Issuer Name: ", SWT.NONE);
		issuerNameLabel.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
		fd = new FormData();
		fd.top = new FormAttachment(issuerText, 10);
		fd.left = new FormAttachment(0, 10);
//		fd.right = new FormAttachment(20, 0);
		fd.width = firstColumnWidth;
		issuerNameLabel.setLayoutData(fd);

		issuerNameText = toolkit.createText(cardNameComp, "", SWT.BORDER | SWT.WRAP);
		issuerNameText.setEditable(false);
		issuerNameText.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
		fd = new FormData();
		fd.top = new FormAttachment(issuerText, 10);
		fd.left = new FormAttachment(issuerNameLabel, 0);
//		fd.right = new FormAttachment(95, 0);
		fd.width = secondColumnWidth;
		issuerNameText.setLayoutData(fd);

		Label timeIssued = toolkit.createLabel(cardNameComp, "Time issued: ", SWT.NONE);
		timeIssued.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
		fd = new FormData();
		fd.top = new FormAttachment(issuerNameText, 10);
		fd.left = new FormAttachment(0, 10);
//		fd.right = new FormAttachment(20, 0);
		fd.width = firstColumnWidth;
		timeIssued.setLayoutData(fd);

		this.timeissuedText = toolkit.createText(cardNameComp, "", SWT.BORDER | SWT.WRAP);
		this.timeissuedText.setEditable(false);
		this.timeissuedText.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
		fd = new FormData();
		fd.top = new FormAttachment(issuerNameText, 10);
		fd.left = new FormAttachment(timeIssued, 0);
//		fd.right = new FormAttachment(95, 0);
		fd.width = secondColumnWidth;
		this.timeissuedText.setLayoutData(fd);
		
		Label requireAppliesTo = toolkit.createLabel(cardNameComp, "Relying Party identity: ");
		requireAppliesTo.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
		fd = new FormData();
		fd.top = new FormAttachment(timeissuedText, 10);
		fd.left = new FormAttachment(0, 10);
//		fd.right = new FormAttachment(20, 0);
		fd.width = firstColumnWidth;
		requireAppliesTo.setLayoutData(fd);
		requireAppliesTo.setToolTipText("If 'Tracking required', use of this card will require the client to let the Identity Provider know the Relying Party site");

		this.requireAppliesToText = toolkit.createText(cardNameComp, "", SWT.WRAP | SWT.NONE);
		this.requireAppliesToText.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
		this.requireAppliesToText.setEditable(false);
		fd = new FormData();
		fd.top = new FormAttachment(timeissuedText, 10);
		fd.left = new FormAttachment(requireAppliesTo, 0);
//		fd.right = new FormAttachment(95, 0);
		fd.width = secondColumnWidth;
		this.requireAppliesToText.setLayoutData(fd);

		Label supportedClaims = toolkit.createLabel(cardNameComp, "Information: ", SWT.NONE);
		supportedClaims.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
		fd = new FormData();
		fd.top = new FormAttachment(this.requireAppliesToText, 10);
		fd.left = new FormAttachment(0, 10);
//		fd.right = new FormAttachment(20, 0);
		fd.width = firstColumnWidth;
		supportedClaims.setLayoutData(fd);

		this.claimTypeList = new Table(cardNameComp, SWT.BORDER | SWT.FULL_SELECTION);
		this.claimTypeList.setLinesVisible(true);
		fd = new FormData();
		fd.top = new FormAttachment(this.requireAppliesToText, 10);
		fd.left = new FormAttachment(supportedClaims, 0);
//		fd.right = new FormAttachment(95, 0);
		fd.width = secondColumnWidth;
		fd.bottom = new FormAttachment(100, -15);
		this.claimTypeList.setLayoutData(fd);

		TableColumn tc = new TableColumn(this.claimTypeList, SWT.NONE);
		tc.setText("Name");
		tc.setWidth(100);
		tc = new TableColumn(this.claimTypeList, SWT.NONE);
		tc.setText("Value");
		tc.setWidth(130);
		this.claimTypeList.setHeaderVisible(true);
		
		//myComposite.pack();
		//myParent.pack(); causes flicker???
	}


}
