/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tie Li  - Initial API and implementation
 *     Anthony Bussani - change in card list mgmt, adding cardstore functions
 *     Bruce Rich - added browse and edit stacklayout
 *******************************************************************************/

package org.eclipse.higgins.crpps.ui;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

/**
 * @author litie at cn dot ibm dot com
 *
 */
public class CardEditView extends ViewPart implements ICardEditView, ISelectionChangedListener {

	private Log log = LogFactory.getLog(CardEditView.class);

	private StackLayout layout; // allow both browse and edit views of cards
	// according to ApplicationWorkbenchWindowAdvisor, our workarea is 400x700
	private ICardEdit browser;
	private ICardEdit editor;
	private ICardEdit listsummary;
	private ICardEdit blankComposite;
	private Composite parentComposite;
	private Composite childrensComposite;
	private FormToolkit toolkit;
	
	private boolean isEditable;

	public CardEditView() {
		CardListView.observerPart = this;
		layout = new StackLayout();
	}

	private void reset() {
		log.info("reset");
		isEditable = false;
		// hide any current windows
//		layout.topControl = null;
//		parentComposite.layout();
		editor.reset();
		browser.reset();
		listsummary.reset();
		// return to blank
		layout.topControl = blankComposite.getComposite();
		parentComposite.layout();
//		layout.topControl = this.browser.getComposite();
//		layout.topControl = null;
//		parentComposite.layout();
	}

	public void createPartControl(Composite parent) {
		parentComposite = parent;
//		childrensComposite = new ScrolledComposite(parent, SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);
		toolkit = new FormToolkit(parent.getDisplay());
		browser = new BrowseComposite(parentComposite, this, toolkit);
//		browser.getComposite().setSize(new Point(400, 700));
		editor = new EditComposite(parentComposite, this, toolkit);
//		editor.getComposite().setSize(new Point(400, 700));
		listsummary = new CardListComposite(parentComposite, this, toolkit);
//		listsummary.getComposite().setSize(new Point(400, 700));
		blankComposite = new BlankComposite(parentComposite, this, toolkit);
		parentComposite.setLayout(layout);
		CardListView.getInstance().addSelectionChangedListener(this);
//		getSite().setSelectionProvider(this); // register as a SelectionProvider
	}

	public void setFocus() {
	}

	/**
	 * Update the visualized information with data from the card
	 * @param card
	 */
	private void notifySelectionChanged(ICard card) {
		log.info("notifySelectionChanged");
		// update all stacks in the layout
		browser.notifySelectionChanged(card);
		editor.notifySelectionChanged(card);
		listsummary.notifySelectionChanged(card);
//		parentComposite.layout();
		parentComposite.getParent().layout(true, true);
	}
	
	private void notifyAdditionalSelection(ICard card) {
		log.info("notifyAdditionalSelection");
		// update all stacks in the layout that deal with multiples
		listsummary.notifySelectionChanged(card);
//		parentComposite.layout();
		parentComposite.getParent().layout(true, true);		
	}

	public void setEditable(boolean editable) {
		this.isEditable = editable;
	}

	public boolean getEditable() {
		return isEditable;
	}

	public boolean isCardDirty() {
		return editor.isCardDirty() | browser.isCardDirty();
	}

	/**
	 * Switch to the editor and display
	 */
	public void modify() {
		log.info("modify");
		layout.topControl = this.editor.getComposite();
		parentComposite.layout();
	}
	
	/**
	 * Switch to browse and display
	 */
	public void browse() {
		log.info("browse");
		layout.topControl = this.browser.getComposite();
		parentComposite.layout();
	}
	
	/**
	 * Switch to listsummary and display
	 */
	public void browselist() {
		log.info("browselist");
		layout.topControl = this.listsummary.getComposite();
		parentComposite.layout();
	}


	public void dispose() {
		toolkit.dispose();
		super.dispose();
	}
	
	/**
	 * React to single select events only.
	 * When we turn off reset() as a public API, then we
	 * need to react to that one also
	 */
	public void selectionChanged(SelectionChangedEvent event) {
		if (event.getSelection() instanceof CardSelection) {
			CardSelection cs = (CardSelection)event.getSelection();
			switch  (cs.getSelType()) {
			case CardSelection.TYPE_INFORM :
				notifySelectionChanged(cs.getCard());
				break;
			case CardSelection.TYPE_MULTISELECT :
				notifyAdditionalSelection(cs.getCard());
				break;
			case CardSelection.TYPE_RESET :
				reset();
				break;
			}
		}
	}

	
//	// ISelectionProvider APIs
//	//  we actually defer to CardListView for these services
//
//	public void addSelectionChangedListener(ISelectionChangedListener listener) {
//		CardListView.getInstance().addSelectionChangedListener(listener);
//	}
//
//	public ISelection getSelection() {
//		return CardListView.getInstance().getSelection();
//	}
//
//	public void removeSelectionChangedListener(
//			ISelectionChangedListener listener) {
//		CardListView.getInstance().removeSelectionChangedListener(listener);
//	}
//
//	public void setSelection(ISelection selection) {
//		CardListView.getInstance().setSelection(selection);
//	}
//	
	
}