package org.eclipse.higgins.crpps.ui;

import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

//public class CardListComposite implements ICardEdit, ISelectionChangedListener {
public class CardListComposite implements ICardEdit {
	
	private ICardEditView icev;
//	private Composite myComposite;
	private Composite body;
	private Composite myParent;
	private FormToolkit toolkit;
	private ScrolledForm form;
	private Text count;

	private Log log = LogFactory.getLog(CardListComposite.class);

	private int howManyCards = 0;
	private List cards = new ArrayList();

	public CardListComposite(Composite parent, 
			final ICardEditView icev, 
			FormToolkit toolkit) {
		log.info("constructor entered");
//		page.addSelectionListener("org.eclipse.higgins.zrpps.cardlistview", this);
//		page.addSelectionListener(this);
//		icev.addSelectionChangedListener(this);
//		CardListView.getInstance().addSelectionChangedListener(this);
		this.icev = icev;
		this.myParent = parent;
		this.toolkit = toolkit;
		reset();
//		toolkit = new FormToolkit(myParent.getDisplay());
//		parent.setLayout(new FormLayout());
	}
	
	/**
	 * Update the visualized information with data from the card
	 * @param card
	 */
	public void notifySelectionChanged(ICard card) {
		log.info("entered");
		
		if (alreadyKnowAboutThisOne(card))
			return;
		count.setText("You have selected   "+ ++howManyCards +"   I-Cards");
		
		Text newCard = new Text(body, SWT.NONE);
		newCard.setText(card.getName());

		Text type = new Text(body, SWT.NONE);
		type.setText((card.isSelfIssued() ? "Self-issued Card" : "Managed Card"));

		Date time = card.getTimeIssued();
		String timeStr = "Not specified";
		String dateStr = "Not specified";
		if (time != null) {
			timeStr = time.toString();
			dateStr = DateFormat.getDateInstance().format(time);
		}

		Text addlInfo = new Text(body, SWT.NONE);
		addlInfo.setText((card.isSelfIssued() ? "Created on: " : "Issued on: ")+dateStr);
		
//		Text timeissuedText = new Text(form, SWT.NONE);
//		Text timeissuedText = new Text(body, SWT.NONE);
//		timeissuedText.setText(timeStr);
		toolkit.createSeparator(body, SWT.WRAP | SWT.SEPARATOR | SWT.HORIZONTAL);
		myParent.pack();
	}

	public Composite getComposite() {
		return this.form;
	}
	
	public boolean isCardDirty() {
		return false;
	}

	public void reset() {
		if (this.form != null) {
			form.dispose();
			form = null;
		}
		cards = new ArrayList();
		howManyCards = 0;
		form = toolkit.createScrolledForm(myParent);
		body = form.getBody();
		RowLayout rl = new RowLayout(SWT.VERTICAL);
		body.setLayout(rl);
		form.setText("Summary information on the selected i-cards");
		Path path = new Path("/image/form_banner.gif");
		URL url = FileLocator.find(Platform.getBundle("org.eclipse.higgins.crpps"), 
				path, null);
		ImageDescriptor imageDesc = ImageDescriptor.createFromURL(url);
		form.setBackgroundImage(imageDesc.createImage());
		count = new Text(body, SWT.NONE);
		count.setText("You have selected "+howManyCards+" I-Cards");
		Label sep = new Label(body, SWT.SEPARATOR | SWT.HORIZONTAL);
		sep.setLayoutData(new RowData(160, SWT.DEFAULT));
	}

//	/**
//	 * React to multiselect events only
//	 */
//	public void selectionChanged(SelectionChangedEvent event) {
//		if (event.getSelection() instanceof CardSelection) {
//			CardSelection cs = (CardSelection)event.getSelection();
//			if (CardSelection.TYPE_MULTISELECT == cs.getSelType())
//				notifySelectionChanged(cs.getCard());
//		}
//	}

	private boolean alreadyKnowAboutThisOne(ICard card) {
		boolean ans = false;
		for (int i=0, j=cards.size(); i<j; i++) {
			if (card == cards.get(i)) {
				ans = true;
				break;
			}
		}
		if (!ans)
			cards.add(card);
		return ans;
	}
}
