/*******************************************************************************
 * Copyright (c) 2007-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tie Li  - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.crpps.ui;

import org.eclipse.higgins.crpps.service.UserInterfaceInfoBean;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.jface.viewers.ISelection;

public class CardSelection implements ISelection{

	private int selType = TYPE_INFORM ;
	
	public final static int TYPE_RESET = -1;
	public final static int TYPE_INFORM = 1;
	public final static int TYPE_MULTISELECT = 2;
	public final static int TYPE_MODIFIED = 4;
	
	private ICard card;
	private UserInterfaceInfoBean uiib;
	
	public CardSelection(int type){
		selType = type;
	}
		
	public boolean isEmpty() {
		return false;
	}

	public ICard getCard() {
		return card;
	}

	public void setCard(ICard card) {
		this.card = card;
	}

	public UserInterfaceInfoBean getUiib() {
		return uiib;
	}

	public void setUiib(UserInterfaceInfoBean uiib) {
		this.uiib = uiib;
	}

	public int getSelType() {
		return selType;
	}

	public void setSelType(int selType) {
		this.selType = selType;
	}
}
