/*******************************************************************************
 * Copyright (c) 2007-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tie Li  - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.crpps.ui;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import javax.security.auth.callback.Callback;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.higgins.crpps.service.InfoCardController;
import org.eclipse.higgins.crpps.service.SecurityTokenBean;
import org.eclipse.higgins.crpps.service.UserInterfaceInfoBean;
import org.eclipse.higgins.crpps.ui.dialogs.BrowserDialog;
import org.eclipse.higgins.crpps.ui.dialogs.PasswordDialog;
import org.eclipse.higgins.crpps.ui.dialogs.PersonalCardCreationDialog;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.auth.ISelfIssuedCredential;
import org.eclipse.higgins.icard.auth.IUsernamePasswordCredential;
import org.eclipse.higgins.icard.auth.IX509V3Credential;
import org.eclipse.higgins.icard.common.auth.TSUsernamePasswordCredential;
import org.eclipse.higgins.icard.provider.cardspace.common.CardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.CardspaceDisplayMappings;
import org.eclipse.higgins.icard.provider.cardspace.common.ManagedCard;
import org.eclipse.higgins.icard.provider.cardspace.common.PersonalCard;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.eclipse.higgins.icard.provider.securestorage.CardStorePersonalCard;
import org.eclipse.higgins.iss.IDisplayToken;
import org.eclipse.higgins.iss.cardspace.STSFaultException;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.Element;

public class CardTaskView extends ViewPart implements ISelectionListener{
	
	private static Log log = LogFactory.getLog(CardTaskView.class);
	private static final String label = "FormText_Label";
	
	private FormToolkit toolkit;
	private Form main_panel;
		
	private FormText cardNameTypeControl;      //Show the card name and type
	private ScrolledForm claimPanel;
	private FormText requiredClaimsControl;	    //Show the required claims
	private Composite optionalClaimsPanel;     //Show the optional claims
	private Composite stsAccessPanel = null;  //STS credential input panel
	
	private Text cardUsernameControl = null;
	private Text cardPasswordControl = null;
	private Label claimsLabelControl; 
	
	private Button editButton = null;
	
	private StackLayout stackLayout = null;	
	private Composite emptyComposite = null;
	private Composite userPassComposite = null; 
	private Composite personalComposite = null;
	private Composite otherAuthComposite = null;
	
	private ICard card = null;
	private List requiredClaims = null;
	private Vector selectedOptionalClaims;
	
	public CardTaskView() {	
		selectedOptionalClaims = new Vector();
	}
	
	private void reset(){
		StringBuffer buf = new StringBuffer();
		buf.append("<form>");
		buf.append("<p><b>Card Name</b></p>");
		buf.append("<p>card type and import date</p>");
		buf.append("<p>card privacy noticy</p>");
		buf.append("</form>");
		cardNameTypeControl.setText(buf.toString(), true, false);
		
		requiredClaimsControl.setText("<form><p></p><p></p></form>", true, false);
		
		Control[] optCtrls = optionalClaimsPanel.getChildren();
		if(optCtrls.length>0){
			for(int i=0; i<optCtrls.length; i++){
				optCtrls[i].dispose();
			}
		}	
		
		requiredClaims = null;
		selectedOptionalClaims.clear();
				
		if(cardPasswordControl!=null) cardPasswordControl.setText("");
		if(claimsLabelControl!=null) claimsLabelControl.setText("");
		if(stackLayout!=null && !emptyComposite.isDisposed()){
			stackLayout.topControl = emptyComposite;
			stsAccessPanel.layout();
		}
	}

	public void createPartControl(Composite parent) {
		getSite().getPage()
			.addSelectionListener("org.eclipse.higgins.crpps.card_selector_view", this);
		
		toolkit = new FormToolkit(parent.getDisplay());
		main_panel = toolkit.createForm(parent);
		main_panel.getBody().setLayout(new FormLayout());
		
		//----Title bar----
		main_panel.setText("Tasks can be done by this i-card");
		Path path = new Path("/image/form_banner.gif");
		URL url = FileLocator.find(Platform.getBundle("org.eclipse.higgins.crpps"), 
			path, null);
		ImageDescriptor imageDesc = ImageDescriptor.createFromURL(url);
		main_panel.setBackgroundImage(imageDesc.createImage());
		
		//----Tool bar----
		Composite toolBarComp = toolkit.createComposite(main_panel.getBody());		
		FormData fd = new FormData();
		fd.top = new FormAttachment(0, 0);
		fd.left = new FormAttachment(0, 0);
		fd.right = new FormAttachment(100, 0);
		toolBarComp.setLayoutData(fd);
		toolBarComp.setLayout(new RowLayout());
		
		editButton = toolkit.createButton(toolBarComp, "Edit", SWT.PUSH);
		editButton.addSelectionListener(new SelectionListener(){
			public void widgetDefaultSelected(SelectionEvent e) {
				editPressed();
			}

			public void widgetSelected(SelectionEvent e) {
				editPressed();
			}
		});
		
		Composite separator1 = toolkit.createCompositeSeparator(main_panel.getBody());
		fd = new FormData();
		fd.top = new FormAttachment(toolBarComp, 5);
		fd.left = new FormAttachment(0, 0);
		fd.right = new FormAttachment(100, 0);
		fd.height = 1;
		separator1.setLayoutData(fd);
		
		//----Content----
		//----The first part, card name, and card type----
		StringBuffer buf = new StringBuffer();
		buf.append("<form>");
		buf.append("<p><b>Card Name</b></p>");
		buf.append("<p>card type and import date</p>");
		buf.append("<p>card privacy noticy</p>");
		buf.append("</form>");
		cardNameTypeControl = toolkit.createFormText(main_panel.getBody(), true);
		cardNameTypeControl.setText(buf.toString(), true, false);
		fd = new FormData();
		fd.top = new FormAttachment(separator1, 5);
		fd.left = new FormAttachment(0, 0);
		fd.right = new FormAttachment(100, 0);
		cardNameTypeControl.setLayoutData(fd);
		
		Composite separator2 = toolkit.createCompositeSeparator(main_panel.getBody());
		fd = new FormData();
		fd.top = new FormAttachment(cardNameTypeControl, 5);
		fd.left = new FormAttachment(0, 0);
		fd.right = new FormAttachment(100, 0);
		fd.height = 1;
		separator2.setLayoutData(fd);
		
		//----The second part, required and optional claims ----
		claimPanel = toolkit.createScrolledForm(main_panel.getBody());
		fd = new FormData();
		fd.top = new FormAttachment(separator2, 5);
		fd.left = new FormAttachment(0, 0);
		fd.right = new FormAttachment(100, 0);
		fd.bottom = new FormAttachment(62, 0);
		claimPanel.setLayoutData(fd);
		
			TableWrapLayout twl = new TableWrapLayout();
			twl.numColumns = 1;
			claimPanel.getBody().setLayout(twl);
			
			FormText ft = toolkit.createFormText(claimPanel.getBody(), true);
			ft.setText("<form><p>This card will the following required information: </p></form>", 
					true, false);
			TableWrapData td = new TableWrapData();
			ft.setLayoutData(td);
					
			requiredClaimsControl = toolkit.createFormText(claimPanel.getBody(), true);
			requiredClaimsControl.setText("<form><p></p><p></p></form>", true, false);
			td = new TableWrapData();
			requiredClaimsControl.setLayoutData(td);
			
			ft = toolkit.createFormText(claimPanel.getBody(), true);
			ft.setText("<form><p>Select the optional information you want to send: </p></form>", 
					true, false);
			td = new TableWrapData();
			ft.setLayoutData(td);
			
			optionalClaimsPanel = toolkit.createComposite(claimPanel.getBody());
			td = new TableWrapData(TableWrapData.FILL);
			td.grabHorizontal = true;
			optionalClaimsPanel.setLayoutData(td);
			TableWrapLayout layout = new TableWrapLayout();
			layout.numColumns = 2;
			optionalClaimsPanel.setLayout(layout);
		
		Composite separator3 = toolkit.createCompositeSeparator(main_panel.getBody());
		fd = new FormData();
		fd.top = new FormAttachment(claimPanel, 5);
		fd.left = new FormAttachment(0, 0);
		fd.right = new FormAttachment(100, 0);
		fd.height = 1;
		separator3.setLayoutData(fd);
		
		//----The third part, identity provider access panel ----
		stsAccessPanel = toolkit.createComposite(main_panel.getBody());
		fd = new FormData();
		fd.top = new FormAttachment(separator3, 5);
		fd.left = new FormAttachment(0, 0);
		fd.right = new FormAttachment(100, 0);
		fd.bottom = new FormAttachment(100, 0);
		stsAccessPanel.setLayoutData(fd);
		this.stackLayout = new StackLayout();
		this.stsAccessPanel.setLayout(stackLayout);
		
		constructEmptyComposite(this.stsAccessPanel);
		constructUserPassComposite(this.stsAccessPanel);	
		constructPersonalComposite(this.stsAccessPanel);
		constructCardBackedComposite(this.stsAccessPanel);
		
		this.stackLayout.topControl = emptyComposite;
		this.stsAccessPanel.layout();
	}
	
	private void constructEmptyComposite(Composite parent){
		emptyComposite = toolkit.createComposite(parent);
		emptyComposite.setLayout(new RowLayout(SWT.VERTICAL));
		toolkit.createLabel(emptyComposite, "You have not seleced a card");
		Button cb = toolkit.createButton(emptyComposite, "Cancel", SWT.PUSH);
		cb.addSelectionListener(new SelectionListener(){
			public void widgetDefaultSelected(SelectionEvent e) {
				cancelPressed();
			}
			public void widgetSelected(SelectionEvent e) {
				cancelPressed();
			}
		});
	}
		
	private void constructCardBackedComposite(Composite parent){
		otherAuthComposite = toolkit.createComposite(parent);
		otherAuthComposite.setLayout(new FormLayout());
		
		FormText l1 = toolkit.createFormText(otherAuthComposite, true);
		l1.setText("<form><p>This is a managed I-Card. </p></form>", 
			true, false);
		FormData fd = new FormData();
		fd.top = new FormAttachment(0, 5);
		fd.left = new FormAttachment(0, 5);
		l1.setLayoutData(fd);
		
		FormText l2 = toolkit.createFormText(otherAuthComposite, true);
		l2.setText("<form><p>Issuer</p><p></p></form>", true, false);
		l2.setData(label);
		fd = new FormData();
		fd.top = new FormAttachment(l1, 5);
		fd.left = new FormAttachment(0, 5);
		l2.setLayoutData(fd);		
		
		Composite submitComp = toolkit.createComposite(otherAuthComposite);
		FormData mainfd = new FormData();
		mainfd.top = new FormAttachment(l2, 10);
		mainfd.left = new FormAttachment(0, 15);
		mainfd.right = new FormAttachment(100, -15);
		submitComp.setLayoutData(mainfd);
		submitComp.setLayout(new FormLayout());
		submitComp.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
		
		Button previewBtn = toolkit.createButton(submitComp, 
			"Preview information", SWT.NONE);		
		fd = new FormData();
		fd.top = new FormAttachment(0,0);
		fd.left = new FormAttachment(0, 15);
		previewBtn.setLayoutData(fd);
		previewBtn.addSelectionListener(new SelectionListener(){
			public void widgetDefaultSelected(SelectionEvent e) {
				previewPressed();
			}
			public void widgetSelected(SelectionEvent e) {
				previewPressed();
			}
		});
		
		Button submitBtn = toolkit.createButton(submitComp, "Submit token", SWT.NONE);
		fd = new FormData();
		fd.top = new FormAttachment(0,0);
		fd.left = new FormAttachment(previewBtn, 10);
		submitBtn.setLayoutData(fd);
		submitBtn.addSelectionListener(new SelectionListener(){
			public void widgetDefaultSelected(SelectionEvent e) {
				okPressed(false);
			}
			public void widgetSelected(SelectionEvent e) {
				okPressed(false);
			}
		});
		
		Button cancelBtn = toolkit.createButton(submitComp, "Cancel", SWT.NONE);
		fd = new FormData();
		fd.top = new FormAttachment(0,0);
		fd.left = new FormAttachment(submitBtn, 10);
		cancelBtn.setLayoutData(fd);
		cancelBtn.addSelectionListener(new SelectionListener(){
			public void widgetDefaultSelected(SelectionEvent e) {
				cancelPressed();
			}

			public void widgetSelected(SelectionEvent e) {
				cancelPressed();
			}
		});
	}
	
	private void constructPersonalComposite(Composite parent){
		personalComposite = toolkit.createComposite(parent);
		personalComposite.setLayout(new FormLayout());
		
		FormText l1 = toolkit.createFormText(personalComposite, true);
		l1.setText("<form><p>This is a personal I-Card.</p>" + 
			"<p>Send the card information to the site.</p></form>", 
			true, false);
		FormData fd = new FormData();
		fd.top = new FormAttachment(0, 5);
		fd.left = new FormAttachment(0, 5);
		l1.setLayoutData(fd);
		
		Composite submitComp = toolkit.createComposite(personalComposite, SWT.NONE);
		FormData mainfd = new FormData();
		mainfd.top = new FormAttachment(l1, 10);
		mainfd.left = new FormAttachment(0, 15);
		mainfd.right = new FormAttachment(100, -15);
		submitComp.setLayoutData(mainfd);
		submitComp.setLayout(new FormLayout());
			
		Button submitBtn = toolkit.createButton(submitComp, "Submit token", SWT.NONE);
		fd = new FormData();
		fd.top = new FormAttachment(0,0);
		fd.left = new FormAttachment(0, 10);
		submitBtn.setLayoutData(fd);
		submitBtn.addSelectionListener(new SelectionListener(){
			public void widgetDefaultSelected(SelectionEvent e) {
				okPressed(false);
			}
			public void widgetSelected(SelectionEvent e) {
				okPressed(false);
			}
		});
		
		Button cancelBtn = toolkit.createButton(submitComp, "Cancel", SWT.NONE);
		fd = new FormData();
		fd.top = new FormAttachment(0,0);
		fd.left = new FormAttachment(submitBtn, 10);
		cancelBtn.setLayoutData(fd);
		cancelBtn.addSelectionListener(new SelectionListener(){
			public void widgetDefaultSelected(SelectionEvent e) {
				cancelPressed();
			}

			public void widgetSelected(SelectionEvent e) {
				cancelPressed();
			}
		});
	}	
	
	private void constructUserPassComposite(Composite parent){
		userPassComposite = toolkit.createComposite(parent, SWT.NONE);
		userPassComposite.setLayout(new FormLayout());
		
		FormText l1 = toolkit.createFormText(userPassComposite, true);
		l1.setText("<form><p>This is a managed I-Card.</p></form>"
			, true, false);
		FormData fd = new FormData();
		fd.top = new FormAttachment(0, 5);
		fd.left = new FormAttachment(0, 5);
		fd.right = new FormAttachment(90, 0);
		l1.setLayoutData(fd);
		
		FormText l2 = toolkit.createFormText(userPassComposite, true);
		l2.setText("<form><p>Issuer name</p><p></p></form>", true, false);
		l2.setData(label);
		fd = new FormData();
		fd.top = new FormAttachment(l1, 5);
		fd.left = new FormAttachment(0, 5);
		fd.right = new FormAttachment(90, 0);
		l2.setLayoutData(fd);
				
		Label l3 = toolkit.createLabel(userPassComposite, "User Name: ");
		fd = new FormData();
		fd.top = new FormAttachment(l2, 10);
		fd.left = new FormAttachment(0, 5);
		l3.setLayoutData(fd);
		
		this.cardUsernameControl = toolkit.createText(userPassComposite, " ");
		fd = new FormData();
		fd.top = new FormAttachment(l2, 10);
		fd.left = new FormAttachment(l3, 10);
		fd.right = new FormAttachment(90, 0);
		cardUsernameControl.setLayoutData(fd);
		
		Label l4 = toolkit.createLabel(userPassComposite, "Password: ");
		fd = new FormData();
		fd.top = new FormAttachment(cardUsernameControl, 5);
		fd.left = new FormAttachment(0, 5);
		l4.setLayoutData(fd);
		
		this.cardPasswordControl = toolkit.createText(userPassComposite, 
			" ", SWT.PASSWORD);
		fd = new FormData();
		fd.top = new FormAttachment(cardUsernameControl, 5);
		fd.left = new FormAttachment(l3, 10);
		fd.right = new FormAttachment(90, 0);
		cardPasswordControl.setLayoutData(fd);
						
		Composite submitComp = toolkit.createComposite(userPassComposite, SWT.NONE);
		FormData mainfd = new FormData();
		mainfd.top = new FormAttachment(this.cardPasswordControl, 10);
		mainfd.left = new FormAttachment(0, 15);
		mainfd.right = new FormAttachment(100, -15);
		submitComp.setLayoutData(mainfd);
		submitComp.setLayout(new FormLayout());
		
		Button previewBtn = toolkit.createButton(submitComp, 
				"Preview information", SWT.NONE);
		fd = new FormData();
		fd.top = new FormAttachment(0,0);
		fd.left = new FormAttachment(0, 15);
		previewBtn.setLayoutData(fd);
		previewBtn.addSelectionListener(new SelectionListener(){
			public void widgetDefaultSelected(SelectionEvent e) {
				previewPressed();
			}
			public void widgetSelected(SelectionEvent e) {
				previewPressed();
			}
		});
		
		Button submitBtn = toolkit.createButton(submitComp, 
				"Submit token", SWT.NONE);
		fd = new FormData();
		fd.top = new FormAttachment(0,0);
		fd.left = new FormAttachment(previewBtn, 10);
		submitBtn.setLayoutData(fd);
		submitBtn.addSelectionListener(new SelectionListener(){
			public void widgetDefaultSelected(SelectionEvent e) {
				okPressed(true);
			}
			public void widgetSelected(SelectionEvent e) {
				okPressed(true);
			}
		});
		
		Button cancelBtn = toolkit.createButton(submitComp, 
				"Cancel", SWT.NONE);
		fd = new FormData();
		fd.top = new FormAttachment(0,0);
		fd.left = new FormAttachment(submitBtn, 10);
		cancelBtn.setLayoutData(fd);
		cancelBtn.addSelectionListener(new SelectionListener(){
			public void widgetDefaultSelected(SelectionEvent e) {
				cancelPressed();
			}

			public void widgetSelected(SelectionEvent e) {
				cancelPressed();
			}
		});
	}
	
	private String checkPinCode(){
		PersonalCard pcard = (PersonalCard) card;
		if(PersonalCard.LOCKED == pcard.getPinStatus()){
			PasswordDialog pd = new PasswordDialog(getSite().getShell());
			pd.create();
			pd.open();
			final String pinCode = pd.getPassword();
			
			boolean pass = false;
			try {
				pass = pcard.validatePINCode(pinCode);
				if(pass){
					return pinCode;
				} else {
					MessageBox mb = new MessageBox(getSite().getShell(), 
							SWT.ERROR_FAILED_EXEC);
					mb.setMessage("Your PIN code is invalid.");
					mb.setText("Error");
					mb.open();
					return null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			} 
		}
		
		return null;
	}
	
	protected void previewPressed(){
		final String username = cardUsernameControl.getText();
		final String pw = cardPasswordControl.getText(); 
		
		String pinCode = null;
		if((card instanceof PersonalCard) && 
				(((PersonalCard) card).getPinStatus() == PersonalCard.LOCKED)){
			pinCode = checkPinCode();
			if(pinCode == null){
				return;
			}
		}
		
		final String fpincode = pinCode;
		ProgressMonitorDialog pmd = new ProgressMonitorDialog(
			this.getSite().getShell());
		try {
			pmd.run(true, false, new IRunnableWithProgress(){
				public void run(IProgressMonitor monitor)
						throws InvocationTargetException, InterruptedException {
					monitor.beginTask("Retrieve security token", 
							IProgressMonitor.UNKNOWN);				
					ICredentialDescriptor[] credDescr = card.getRequiredCredentials();
					ICredential cred = credDescr[0].getCredential();				
					if (cred instanceof TSUsernamePasswordCredential){
						TSUsernamePasswordCredential tsupc = 
							(TSUsernamePasswordCredential)cred;
						if (!tsupc.isUsernamePredefined()){
							tsupc.setUsername(username);
						}
						tsupc.setPassword(pw);
					}
					
					SecurityTokenBean token = null;
					try {
						token = InfoCardController.getInst()
							.previewToken(selectedOptionalClaims, card, fpincode);
					} catch (Exception e) {
						throw new InvocationTargetException(e);
					}	
					
					if(token!=null){
						IDisplayToken displaytoken = token.getDisplayToken();
						updateUI(displaytoken);
					}
					monitor.done();	
				}
			});
		} catch (InvocationTargetException e1) {
			Throwable e2 = e1.getCause();
			String message = "Got an exception when receiving token from identity provider";
			if(e2 instanceof STSFaultException){
				STSFaultException e3 = (STSFaultException) e2;
				IFault fault = e3.fault;
				message = fault.getReason() + ": " + fault.getDetail();
			}
			log.error(message, e2);
			
			MessageBox mb = new MessageBox(this.getSite().getShell(), 
					SWT.ERROR_FAILED_EXEC);
			mb.setText("Error");
			mb.setMessage(message);
			mb.open();
		} catch (InterruptedException e1) {
			MessageBox mb = new MessageBox(this.getSite().getShell(), 
					SWT.ERROR_FAILED_EXEC);
			mb.setText("Error");
			mb.setMessage(e1.getLocalizedMessage());
			mb.open();
		} 
	}
	
	private void updateUI(final IDisplayToken displaytoken){
		Display.getDefault().asyncExec(new Runnable(){
			public void run() {
				StringBuffer buf = new StringBuffer();
				buf.append("<form>");
				if(requiredClaims!=null){
					for(int i=0; i<requiredClaims.size(); i++){
						String currClaimType = (String)requiredClaims.get(i);
						buf.append("<li>");
						buf.append("<b>");
						buf.append(CardspaceDisplayMappings.getString(currClaimType));
						buf.append("</b>");
						try {
							IClaim currClaim = displaytoken.getClaim(currClaimType);
							String value = "";
							if ((currClaim != null)&&(currClaim instanceof ISimpleClaim)){
								ISimpleClaim simpleClaim = (ISimpleClaim) currClaim;
								List l = simpleClaim.getValues();
								if (l!=null && l.size() > 0) {
									value = (String) l.get(0);
								}
							}
							if(!"".equals(value)){
								buf.append(" : ");
								buf.append(value);
							}
						} catch (Exception e) {
							e.printStackTrace();
						} 
						buf.append("</li>");										
					}		
					buf.append("</form>");
					requiredClaimsControl.setText(buf.toString(), true, false);
					requiredClaimsControl.setWhitespaceNormalized(true);
				}	
				
				Control[] optLabels = optionalClaimsPanel.getChildren();
				if(optLabels!=null){
					for(int i=0; i<optLabels.length; i++){
						if(optLabels[i] instanceof FormText){
							FormText currLabel = (FormText) optLabels[i];
							if(!currLabel.isDisposed()){
								String claimType = (String)(currLabel.getData());
								IClaim claim = displaytoken.getClaim(claimType);
								StringBuffer value = new StringBuffer();
								value.append("<form><p>");
								
								if ((claim != null)&&(claim instanceof ISimpleClaim)){
									ISimpleClaim simpleClaim = (ISimpleClaim) claim;
									List l = simpleClaim.getValues();
									if (l!=null && l.size() > 0) {
										value.append((String) l.get(0));
									}
								}
								
								value.append("</p></form>");
								
								currLabel.setText(value.toString(), true, false);
								currLabel.layout(true);
							}
						}
					}
				}
				optionalClaimsPanel.layout();
				optionalClaimsPanel.pack();
			}
		});
	}
	
	protected void okPressed(boolean pwRequired) {
		String pinCode = null;
		
		if(card instanceof PersonalCard){
			if((card instanceof PersonalCard) && 
					(((PersonalCard) card).getPinStatus() == PersonalCard.LOCKED)){
				pinCode = checkPinCode();
				if(pinCode == null){
					return;
				}
			}
		}
		
		final String username = cardUsernameControl.getText();
		final String pw = cardPasswordControl.getText(); 
		final String fpincode = pinCode;
		
		if("".equals(pw) && pwRequired){
			MessageBox md = new MessageBox(this.getSite().getShell(),
					SWT.OK | SWT.CANCEL | SWT.ICON_WARNING);
			md.setText("Password required");
			md.setMessage("You don't enter the password for the i-card, confirm?");
			int status = md.open();
			if(status == SWT.CANCEL){
				return;
			}
		}
		
		ProgressMonitorDialog pmd = new ProgressMonitorDialog(
				this.getSite().getShell());
		try {
			pmd.run(true, false, new IRunnableWithProgress(){
				public void run(IProgressMonitor monitor)
						throws InvocationTargetException, InterruptedException {
					monitor.beginTask("Send the security token.", 
							IProgressMonitor.UNKNOWN);
					ICredentialDescriptor [] credDescr = card.getRequiredCredentials();
					if(credDescr!=null){
						ICredential cred = credDescr[0].getCredential();				
						if (cred instanceof IUsernamePasswordCredential){
							TSUsernamePasswordCredential tsupc = 
								(TSUsernamePasswordCredential)cred;
							if (!tsupc.isUsernamePredefined()){
								tsupc.setUsername(username);
							}
							tsupc.setPassword(pw);
						}
						if (cred instanceof ISelfIssuedCredential){
							PersonalCard pcard = null;
							try {
								pcard = InfoCardController.getInst()
									.findPersonalCardForManagedCard(card);
							} catch (Exception e) {
								throw new InvocationTargetException(e);
							}
							if(pcard!=null){
								if(PersonalCard.LOCKED == pcard.getPinStatus()){
									String pinCode = checkPinCode();
									if(pinCode!=null){
										final byte[] fpinCode = pinCode.getBytes();
										IPinCodeCredential ipc = new IPinCodeCredential(){
											public byte[] getPinCode() {
												return fpinCode;
											}
											public void setPinCode(byte[] pin) {}
											public Callback[] getCallbacks() {return null;}
										};										
										((ISelfIssuedCredential)cred).setPinCodeCredential(ipc);
									}
								}
							}
						}
					}
					
					try {
						InfoCardController.getInst()
							.sendToken(selectedOptionalClaims, card, fpincode);
					} catch (Exception e) {
						throw new InvocationTargetException(e);
					}	
					Display.getDefault().asyncExec(new Runnable(){
						public void run() {
							PlatformUI.getWorkbench().getActiveWorkbenchWindow()
								.getShell().close();
						}
					});
					monitor.done();
				}
			});
		} catch (InvocationTargetException e1) {
			Throwable e2 = e1.getCause();
			String message = "Got an exception when receiving token from identity provider";
			if(e2 instanceof STSFaultException){
				STSFaultException e3 = (STSFaultException) e2;
				IFault fault = e3.fault;
				message = fault.getReason() + ": " + fault.getDetail();
			}
			log.error(message, e2);
			MessageBox mb = new MessageBox(this.getSite().getShell(), 
					SWT.ERROR_FAILED_EXEC);
			mb.setMessage(message);
			mb.setText("Error");
			mb.open();
		} catch (InterruptedException e1) {
			MessageBox mb = new MessageBox(this.getSite().getShell(), 
					SWT.ERROR_FAILED_EXEC);
			mb.setMessage(e1.getLocalizedMessage());
			mb.setText("Error");
			mb.open();
		}
	}
	
	protected void cancelPressed() {
		MessageBox md = new MessageBox(this.getSite().getShell(),
				SWT.OK | SWT.CANCEL | SWT.ICON_WARNING);
		md.setText("Cancel the login");
		md.setMessage("If you click cancel, you'll not able to access this site, confirm?");
		int status = md.open();
		if(status == SWT.CANCEL){
			return;
		}
		
		InfoCardController.getInst().cancelPressed();
		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().close();
	}
	
	protected void editPressed(){
		CardStorePersonalCard personalCard = (CardStorePersonalCard) card;
		CardStorePersonalCard copyPersonalCard = 
			new CardStorePersonalCard(personalCard);
		PersonalCardCreationDialog pccd = 
			new PersonalCardCreationDialog(this.getSite().getShell(), personalCard);
		pccd.setBlockOnOpen(true);
		int ret = pccd.open();
		ICard icard = pccd.getPersonalCard();
		if (ret == 0) {
			log.info("icard:\n" + icard.getID());
			try {
				PerspectiveCardStore.getSecureCardProvider()
					.deleteCard(null, copyPersonalCard);
				PerspectiveCardStore.getSecureCardProvider()
					.addCard(null, personalCard);
			} catch (Exception e) {
				log.error("Error when modifying card [" + icard.getName() + "]", e);
				MessageBox messageBox = new MessageBox(this.getSite().getShell(), 
						SWT.ERROR_IO);
				messageBox.setMessage("Error when modifying card:"
						+ icard.getName() + "\n\n" + e);
				messageBox.setText("Error while modifying a card");
				messageBox.open();
			}
		}
	}

	public void selectionChanged(IWorkbenchPart part, ISelection selection) {		
		if(selection instanceof CardSelection){
			CardSelection cs = (CardSelection) selection;
			if(cs.getSelType()==CardSelection.TYPE_INFORM){
				applyData(cs.getCard(), cs.getUiib());
			}
			if(cs.getSelType()==CardSelection.TYPE_RESET){
				reset();
			}
		}
	}
	
	private void applyData(ICard card, UserInterfaceInfoBean uiib){
		this.card = card;	
		
		//Update the Edit button.
		editButton.setEnabled(false);
		if(this.card.isSelfIssued()){
			editButton.setEnabled(true);
		}
		
		//Update the card name and type.
		StringBuffer buf = new StringBuffer();
		buf.append("<form>");
		buf.append("<p><b>"+ card.getName() + "</b></p>");
		buf.append("<p>");
		if(card.isSelfIssued()){
			buf.append("<b>Personal</b> ");
		} else {
			buf.append("<b>Managed</b> ");
		}
		buf.append(card.getType());
		DateFormat df = DateFormat.getDateInstance();	
		if(card.getTimeLastUpdated()!=null){
			buf.append(", imported at " + df.format(card.getTimeLastUpdated()));
		}
				
		buf.append("</p>");
		
		boolean isPrivacyNoticeExist = false;
		String privacyNotice = "";
		if(card instanceof ManagedCard){
			ManagedCard mc = (ManagedCard) card;
			Element ele_privacyNotice = mc.getPrivacyNotice();
			if(ele_privacyNotice!=null){
				privacyNotice = XMLUtils.getTextContent(ele_privacyNotice);
				if((privacyNotice==null) || ("".equals(privacyNotice))){
					privacyNotice = "The card provider don't provide privacy notice";
				} else {
					privacyNotice = "<b>Privacy Notice: </b><a href=\"" 
						+ privacyNotice + "\">" + privacyNotice + "</a>";
					isPrivacyNoticeExist = true;
				}
				buf.append("<p>" + privacyNotice + "</p>");
			}
		}
		
		buf.append("</form>");
		cardNameTypeControl.setText(buf.toString(), true, true);
		if(isPrivacyNoticeExist){
			final String idp_purl = privacyNotice;
			cardNameTypeControl.addHyperlinkListener(new IHyperlinkListener(){
				public void linkActivated(HyperlinkEvent e) {
					BrowserDialog bd = new BrowserDialog(getSite().getShell(), idp_purl);
					bd.open();
				}

				public void linkEntered(HyperlinkEvent e) {}
				public void linkExited(HyperlinkEvent e) {}
			});
		}
		
		//The required claims part.
		buf = new StringBuffer();
		buf.append("<form>");
		IPolicy policy = uiib.getPolicy();
		if(policy instanceof CardSpacePolicy){
			CardSpacePolicy csp = (CardSpacePolicy) policy;	
			requiredClaims = csp.getRequiredClaims();
			if(requiredClaims!=null){
				for(int i=0; i<requiredClaims.size(); i++){
					String currClaimType = (String)requiredClaims.get(i);
					buf.append("<li>");
					buf.append("<b>");
					buf.append(CardspaceDisplayMappings.getString(currClaimType));
					buf.append("</b>");
					try {
						IClaim currClaim = card.getClaim(currClaimType);
			    		String value = "";
			    		if ((currClaim != null)&&(currClaim instanceof ISimpleClaim)){
			    			ISimpleClaim simpleClaim = (ISimpleClaim) currClaim;
			    			List l = simpleClaim.getValues();
			    			if (l!=null && l.size() > 0) {
			    				value = (String) l.get(0);
			    			}
			    		}
			    		if(!"".equals(value)){
			    			buf.append(" : ");
			    			if(card instanceof PersonalCard){
			    				PersonalCard pcard = (PersonalCard) card;
			    				if(pcard.getPinStatus() == PersonalCard.LOCKED){
			    					value = "Not accessabile";
			    				}
			    			}
			    			
			    			buf.append(value);
			    		}
					} catch (Exception e) {
						e.printStackTrace();
					} 
					buf.append("</li>");
				}
			}			
		}		
		buf.append("</form>");
		requiredClaimsControl.setText(buf.toString(), true, false);
		
		//The optional claims part
		Control[] optCtrls = this.optionalClaimsPanel.getChildren();
		if(optCtrls.length>0){
			for(int i=0; i<optCtrls.length; i++){
				optCtrls[i].dispose();
			}
		}	
		this.optionalClaimsPanel.layout();
		if(policy instanceof CardSpacePolicy){
			CardSpacePolicy csp = (CardSpacePolicy) policy;		
			final List optionalClaims = matchOptionalCliams(csp.getOptionalClaims());
			if(optionalClaims.size()>0){
				for(int i=0; i<optionalClaims.size(); i++){
					String optClaimType = (String)optionalClaims.get(i);
					String summaryClaim = CardspaceDisplayMappings.getString(optClaimType);
					Button optBtn = toolkit.createButton(this.optionalClaimsPanel, 
							summaryClaim, SWT.CHECK);
					optBtn.setData(optionalClaims.get(i));				
					optBtn.setText(summaryClaim);
					optBtn.addSelectionListener(new SelectionListener(){
						public void widgetDefaultSelected(SelectionEvent e) {
						}

						public void widgetSelected(SelectionEvent e) {
							Button btn = (Button) e.widget;
							check(btn);
						}
						
						private void check(Button btn){
							Object data = btn.getData();
							
							if(btn.getSelection()){
								if(!selectedOptionalClaims.contains(data)){
									selectedOptionalClaims.add(data);
									log.info("put " + (String)data + " to selection");
								}
							} else {
								if(selectedOptionalClaims.contains(data)){
									selectedOptionalClaims.remove(data);
									log.info("remove " + (String)data + " from selection");
								}
							}
						}
					});
					TableWrapData td = new TableWrapData();
					td.colspan = 1;
					optBtn.setLayoutData(td);
					
					FormText optLabel = toolkit.createFormText(this.optionalClaimsPanel, true);
					optLabel.setData(optClaimType);
					td = new TableWrapData();
					td.colspan = 1;
					optLabel.setLayoutData(td);
					try {
						IClaim currClaim = card.getClaim(optClaimType);
			    		String value = "";
			    		if ((currClaim != null)&&(currClaim instanceof ISimpleClaim)){
			    			ISimpleClaim simpleClaim = (ISimpleClaim) currClaim;
			    			List l = simpleClaim.getValues();
			    			if (l!=null && l.size() > 0) {
			    				value = (String) l.get(0);
			    			}
			    		}
		    			if(card instanceof PersonalCard){
		    				PersonalCard pcard = (PersonalCard) card;
		    				if(pcard.getPinStatus() == PersonalCard.LOCKED){
		    					value = "Not accessabile";
		    				}
		    			}
			    		optLabel.setText("<form><p>"+value+"</p></form>", true, false);
					} 
					catch (AuthenticationRequiredException e0){
						//do nothing, for managed card.
					}					
					catch (Exception e1) {
						e1.printStackTrace();
					} 
				}
			}
		}
		this.optionalClaimsPanel.layout();
		this.claimPanel.layout();
		this.claimPanel.pack();
		
		if(this.card.isSelfIssued()){
			this.stackLayout.topControl = this.personalComposite;
		} else {
			ICredentialDescriptor [] credDescr = this.card.getRequiredCredentials();
			ICredential cred = credDescr[0].getCredential();
			Control[] children = null;
			String idp_prompt = "";
			if (cred instanceof IUsernamePasswordCredential){				
				String username = ((TSUsernamePasswordCredential)cred).getUsername();
				if(username!=null && !("".equals(username))){
					this.cardUsernameControl.setText(username);
					this.cardUsernameControl.setEditable(false);
				}
				children = this.userPassComposite.getChildren();	
				idp_prompt = "Input your username and password to access the provider site";
				this.stackLayout.topControl = this.userPassComposite;				
			} 
			else if (cred instanceof ISelfIssuedCredential){
				children = this.otherAuthComposite.getChildren();
				idp_prompt = "Your peronsal i-card is used to access the provider site";
				this.stackLayout.topControl = this.otherAuthComposite;
			}
			else if (cred instanceof IX509V3Credential){
				children = this.otherAuthComposite.getChildren();
				idp_prompt = "Your X509 certificate is used to access the provider site";
				this.stackLayout.topControl = this.otherAuthComposite;
			}
			
			if(children!=null){
				for(int i=0; i<children.length; i++){
					Object data = children[i].getData();
					if((data!=null) && (data instanceof String) 
							&& (label.equals((String)data))){
						FormText ft = (FormText) children[i];
						String issuer = card.getIssuerName();
						if(issuer==null){
							issuer = card.getIssuer();
						}
						
						ft.setText("<form><p>It is issued by <b>"+ issuer +
							"</b></p><p>" + idp_prompt + "</p></form>", 
							true, false);
						break;
					}
				}
			}	
		}
		this.stsAccessPanel.layout();	
		this.stsAccessPanel.pack();
		this.main_panel.layout();
	}
	
	private List matchOptionalCliams(List optionalClaims){
		List result = new ArrayList();
		if(optionalClaims!=null && optionalClaims.size()>0){
			List list = this.card.getSupportedClaimTypesUris();
			for(int i=0; i<list.size(); i++){
				String supportedClaim = (String)list.get(i);
				for(int j=0; j<optionalClaims.size(); j++){
					String neededClaim = (String)optionalClaims.get(j);
					if(supportedClaim.equalsIgnoreCase(neededClaim)){
						result.add(neededClaim);
					}
				}
			}
		}
				
		return result;
	}
		
	public void setFocus() {
		main_panel.setFocus();
	}
}
