/******************************************************************************
 * Copyright (c) 20062007 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Anthony Bussani (IBM Research) - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.crpps.ui;

import org.eclipse.higgins.crpps.Activator;
import org.eclipse.higgins.crpps.app.ApplicationWorkbenchWindowAdvisor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * @author bus at zurich dot ibm dot com
 *
 */
public class DirSurveyPreferencePage extends PreferencePage implements
	IWorkbenchPreferencePage {

    Text dirSurvey;

    Text delay;

    public DirSurveyPreferencePage() {
	super();
    }

    public DirSurveyPreferencePage(String arg0) {
	super(arg0);
    }

    public DirSurveyPreferencePage(String arg0, ImageDescriptor arg1) {
	super(arg0, arg1);
    }

    protected Control createContents(Composite parent) {
	Composite composite = new Composite(parent, SWT.NONE);
	composite.setLayout(new FormLayout());

	Label lab1 = new Label(composite, SWT.NONE);
	lab1.setText("Directory to survey: ");
	FormData fd = new FormData();
	fd.top = new FormAttachment(0, 10);
	fd.left = new FormAttachment(0, 5);
	lab1.setLayoutData(fd);

	dirSurvey = new Text(composite, SWT.BORDER);
	fd = new FormData();
	fd.top = new FormAttachment(0, 5);
	fd.left = new FormAttachment(lab1, 5);
	fd.right = new FormAttachment(90, 0);
	dirSurvey.setLayoutData(fd);

	Button dirButton = new Button(composite, SWT.NONE);
	fd = new FormData();
	fd.top = new FormAttachment(0, 5);
	fd.left = new FormAttachment(dirSurvey, 5);
	// fd.right = new FormAttachment(40, 0);
	dirButton.setLayoutData(fd);
	dirButton.setText("...");
	dirButton.setEnabled(true);
	dirButton.addSelectionListener(new SelectionAdapter() {
	    public void widgetSelected(SelectionEvent e) {
		Shell shell = getShell();
		DirectoryDialog directoryDialog = new DirectoryDialog(shell,
			SWT.OPEN | SWT.SINGLE);
		String ret = directoryDialog.open();
		if (ret == null)
		    return;
		dirSurvey.setText(ret);
	    }
	});

	Label lab2 = new Label(composite, SWT.NONE);
	lab2.setText("Delay between each check:");
	fd = new FormData();
	fd.top = new FormAttachment(dirSurvey, 15);
	fd.left = new FormAttachment(0, 5);
	lab2.setLayoutData(fd);

	delay = new Text(composite, SWT.BORDER);
	fd = new FormData();
	fd.top = new FormAttachment(dirSurvey, 10);
	fd.left = new FormAttachment(lab2, 5);
	fd.right = new FormAttachment(90, 0);
	delay.setLayoutData(fd);

	String delaySz = Activator.getDefault().getPreferenceStore()
		.getString("dirSurvey.delay");
	delay.setText(delaySz);

	String surveyPath = Activator.getDefault().getPreferenceStore().getString(
		"dirSurvey.path");
	dirSurvey.setText(surveyPath);

	return composite;
    }

    public void init(IWorkbench arg0) {
	// Preferences pref = Activator.getDefault().getPluginPreferences();
	// Activator.getDefault().
    }

    protected void performApply() {
	Activator.getDefault().getPreferenceStore().setValue("dirSurvey.delay",
		delay.getText());
	Activator.getDefault().getPreferenceStore().setValue(
		"dirSurvey.path", dirSurvey.getText());
	Activator.getDefault().savePluginPreferences();
	super.performApply();
    }

    public boolean performOk() {
	Activator.getDefault().getPreferenceStore().setValue("dirSurvey.delay",
		delay.getText());
	Activator.getDefault().getPreferenceStore().setValue(
		"dirSurvey.path", dirSurvey.getText());
	Activator.getDefault().getPreferenceStore().needsSaving();
	return super.performOk();
    }

    protected void performDefaults() {
	super.performDefaults();

	Activator.getDefault().getPreferenceStore().setValue("dirSurvey.delay",
		"1000");
	delay.setText("1000");
	Activator.getDefault().getPreferenceStore().setValue(
		"dirSurvey.path",
		"/media/disk");
	dirSurvey.setText("/media/disk");
    }

}
