/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Tie Li (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.crpps.ui;

import org.eclipse.higgins.crpps.Activator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

/**
 * @author litie at cn dot ibm dot com
 *
 */
public class PerspectiveCardSelector implements IPerspectiveFactory {
	
	private IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();

	public void createInitialLayout(IPageLayout layout) {
		layout.setEditorAreaVisible(false);
		
//		layout.addStandaloneView("org.eclipse.higgins.crpps.rp_info_view", 
//				false, IPageLayout.LEFT, 0.6f, IPageLayout.ID_EDITOR_AREA);
		
		layout.addStandaloneView("org.eclipse.higgins.crpps.card_selector_view", 
				false, IPageLayout.LEFT, prefs.getFloat(Activator.LEFT_PANE_RATIO), IPageLayout.ID_EDITOR_AREA);
//		layout.addStandaloneView("org.eclipse.higgins.crpps.card_selector_view", 
//				false, IPageLayout.LEFT, 0.6f, IPageLayout.ID_EDITOR_AREA);
		
		layout.addStandaloneView("org.eclipse.higgins.crpps.card_tasks", 
				false, IPageLayout.RIGHT, prefs.getFloat(Activator.RIGHT_PANE_RATIO), IPageLayout.ID_EDITOR_AREA);
//		layout.addStandaloneView("org.eclipse.higgins.crpps.card_tasks", 
//				false, IPageLayout.RIGHT, 0.4f, IPageLayout.ID_EDITOR_AREA);
		
//		layout.addStandaloneView("org.eclipse.higgins.crpps.idp_access", 
//				false, IPageLayout.BOTTOM, 0.7f, "org.eclipse.higgins.zrpps.cardeditor");
	}
}
