/*******************************************************************************
 * Copyright (c) 2007-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tie Li  - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.crpps.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class BrowserDialog extends Dialog{

	private Browser _browser;
	private String url;
	private ProgressBar pb;
	private Label label;
	
	public BrowserDialog(Shell parentShell, String url) {
		super(parentShell);
		this.url = url;
	}
	
	public void setURL(String url){
		_browser.setUrl(url);
	}

	protected Control createDialogArea(Composite parent) {
		Composite panel = (Composite) super.createDialogArea(parent);
		panel.setLayout(new FormLayout());		
		_browser = new Browser(panel, SWT.BORDER);	
		_browser.setUrl(url);
		FormData fd = new FormData();
		fd.top = new FormAttachment(0, 0);
		fd.left = new FormAttachment(0, 5);
		fd.right = new FormAttachment(100, -5);
		fd.bottom = new FormAttachment(90, 0);
		_browser.setLayoutData(fd);
		
		label = new Label(panel, SWT.NONE);
		label.setText("Retrieving the privacy notice content");
		fd = new FormData();
		fd.top = new FormAttachment(_browser, 7);
		fd.left = new FormAttachment(0, 5);
		label.setLayoutData(fd);
		
		pb = new ProgressBar(panel, SWT.NONE);
		fd = new FormData();
		fd.top = new FormAttachment(_browser, 5);
		fd.left = new FormAttachment(label, 10);
		fd.right = new FormAttachment(100, -5);
		pb.setLayoutData(fd);
		
		_browser.addProgressListener(new ProgressListener(){
			public void changed(ProgressEvent event) {
				int ratio = event.current * 100 / event.total;
				pb.setSelection(ratio);
			}

			public void completed(ProgressEvent event) {
				if (pb != null) 
					pb.setSelection(0);
				if (label != null)
					label.setText("Completed");
			}
		});
		
		panel.layout();
		return panel;
	}
	
	protected void configureShell(Shell arg0) {
		super.configureShell(arg0);
		arg0.setText("Browse privacy notice");
		arg0.setSize(600, 480);
	}
}
