/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Anthony Bussani (IBM Research) - initial API and implementation
 *    Bruce Rich (IBM Corporation) - revamp to return ICard list
 *******************************************************************************/

package org.eclipse.higgins.crpps.ui.dialogs;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.crpps.ui.CardListView;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.provider.securestorage.PasswordHandler;
import org.eclipse.higgins.icard.provider.securestorage.ProviderConfiguration;
import org.eclipse.higgins.icard.provider.securestorage.SecureStorageICardProvider;
import org.eclipse.higgins.icard.provider.securestorage.SecureStorageStrategy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ImportCardstoreDialog extends Dialog {

	private Log log = LogFactory.getLog(ImportCardstoreDialog.class);

	Composite mainParent;
	Table cardsTable;

//	TableViewer tableViewer;
	CheckboxTableViewer cbtv;

	private String filename;

	private String password;

	private Text textPassword;

	private Text textCardStore;
	
	private SecureStorageICardProvider cardProvider;
	
	private List cardsToCopy = new ArrayList();
	
	private Shell shell;
	
	private Font font;
	
	private static final int IMAGE_COLUMN = 1;
	private static final int NAME_COLUMN = 2;
	private static final int PROVIDER_COLUMN = 3;
	
	private static final int STYLE = SWT.APPLICATION_MODAL | SWT.BORDER | SWT.RESIZE | SWT.TITLE | SWT.CLOSE | SWT.V_SCROLL;

	public ImportCardstoreDialog(Shell parentShell, String filename) {
		super(parentShell);
		this.filename = filename;
//		this.setShellStyle(STYLE);
	}
	

	public List getCardsList() {
		return cardsToCopy;
	}
	
	public void dispose() {
		if (font != null) {
			font.dispose();
			font = null;
		}
	}

	private void createTable(Table table) {
		// REQUIRED DATA TABLES
		TableColumn tc1;

		tc1 = new TableColumn(table, SWT.NONE);
		tc1.setWidth(100);
		tc1 = new TableColumn(table, SWT.NONE);
		tc1.setText("Image");
		tc1.setWidth(120);
		tc1 = new TableColumn(table, SWT.NONE);
		tc1.setText("Name");
		tc1.setWidth(200);
		tc1 = new TableColumn(table, SWT.NONE);
		tc1.setText("Issuer");
		tc1.setWidth(350);
		table.setHeaderVisible(true);
	}

	private Iterator getCards() throws CardException {
		if (cardProvider == null) {
			SecureStorageStrategy secureStorageStrategy = new SecureStorageStrategy();
			ProviderConfiguration provider = new ProviderConfiguration(
			"org.eclipse.higgins.icard.provider.securestorage");
			PasswordHandler pwdH = new PasswordHandler(password);
			cardProvider = new SecureStorageICardProvider();
			secureStorageStrategy.initialize(null, cardProvider, filename, pwdH,
					provider);
			cardProvider.setStrategy(secureStorageStrategy);
		}
		return cardProvider.getICards(null);
	}


	private void updateCardsTable(String password2) {
		try {
			List icards = new ArrayList();
			Iterator iter = getCards();
			while (iter.hasNext())
				icards.add(iter.next());
			cbtv.setInput(icards.toArray());
			cbtv.getTable().pack();
			super.dialogArea.pack();
			mainParent.layout(true);
		} catch (CardException e) {
			CardListView.openSecureStore(super.getShell(), e, filename);
			cardProvider = null;
		}

	}

	protected void okPressed() {
		for (int i=0; i<cardsTable.getItemCount(); i++) {
			TableItem ti = cardsTable.getItem(i);
			ICard thisCard = (ICard)ti.getData();
			if (cbtv.getChecked(thisCard)) {
				log.info("Found a card selected");
				cardsToCopy.add(thisCard);
			}
		}
		// TODO add are-you-sure check for nothing selected but OK pressed
		super.okPressed();
	}

	protected void configureShell(Shell arg0) {
		super.configureShell(arg0); // default layout would be grid
		shell = arg0;
		arg0.setText("Import cards from cardstore");
	}
	
    protected Control createDialogArea(Composite arg0) {
		mainParent = new Composite(arg0, SWT.BORDER | SWT.CLOSE | SWT.OK);
		FormLayout formLayout = new FormLayout();
		formLayout.marginBottom = 10;
		formLayout.marginTop = 10;
		formLayout.marginLeft = 10;
		formLayout.marginRight = 10;
		mainParent.setLayout(formLayout);
		Label label_ = new Label(mainParent, SWT.NONE);
		label_.setText("Choose a cardstore, enter its password, and select the cards to import");
		font = new Font(Display.getCurrent(), "Ariel", 8, SWT.BOLD);
		label_.setFont(font);
		FormData fd = new FormData();
		fd.top = new FormAttachment(0, 0);
		fd.left = new FormAttachment(0, 5);
		label_.setLayoutData(fd);

//		Label label_1 = new Label(mainParent, SWT.NONE);
//		label_1.setText("(It is possible to change and select another cardstore)");
//		font = new Font(Display.getCurrent(), "Ariel", 7, SWT.NONE);
//		label_1.setFont(font);
//		fd = new FormData();
//		fd.top = new FormAttachment(label_, 0);
//		fd.left = new FormAttachment(0, 10);
//		label_1.setLayoutData(fd);

		// Separator
		Label sep = new Label(mainParent, SWT.SEPARATOR | SWT.HORIZONTAL);
		fd = new FormData();
		fd.top = new FormAttachment(label_, 5);
		fd.left = new FormAttachment(0);
		fd.right = new FormAttachment(100);
//		fd.width = 600;
		sep.setLayoutData(fd);

		Label labelFilename = new Label(mainParent, SWT.NONE);
		fd = new FormData();
		fd.top = new FormAttachment(sep, 15);
		fd.left = new FormAttachment(0, 5);
		labelFilename.setLayoutData(fd);
		labelFilename.setText("Card Store :");

		textCardStore = new Text(mainParent, SWT.BORDER);
		fd = new FormData();
		fd.top = new FormAttachment(sep, 10);
		fd.left = new FormAttachment(labelFilename, 5);
		fd.width = 400;
		textCardStore.setText(filename);
		textCardStore.setLayoutData(fd);

		Button filenameButton = new Button(mainParent, SWT.NONE);
		filenameButton.setText("...");
		filenameButton.setToolTipText("Choose a cardstore file");
		filenameButton.setEnabled(true);
		filenameButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				FileDialog fileDialog = new FileDialog(shell, SWT.OPEN);
				fileDialog.setFilterExtensions(new String[] { "*.crds", "*" });
				filename = fileDialog.open();
				if( filename != null) textCardStore.setText(filename);
			}
		});
		fd = new FormData();
		fd.top = new FormAttachment(sep, 8);
		fd.left = new FormAttachment(textCardStore, 5);
		filenameButton.setLayoutData(fd);

		Label labelPassword = new Label(mainParent, SWT.NONE);
		fd = new FormData();
		fd.top = new FormAttachment(labelFilename, 15);
		fd.left = new FormAttachment(0, 5);
		labelPassword.setLayoutData(fd);
		labelPassword.setText("Password :");

		textPassword = new Text(mainParent, SWT.BORDER | SWT.PASSWORD);
		fd = new FormData();
		fd.top = new FormAttachment(labelFilename, 10);
		fd.left = new FormAttachment(labelFilename, 5);
		fd.width = 150;
		textPassword.setLayoutData(fd);

		Button decryptButton = new Button(mainParent, SWT.NONE);
		decryptButton.setText("Decrypt cardstore");
		decryptButton.setEnabled(true);
		decryptButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				password = textPassword.getText();
				textPassword.setText("");
				updateCardsTable(password);
			}
		});
		fd = new FormData();
		fd.top = new FormAttachment(labelFilename, 8);
		fd.left = new FormAttachment(textPassword, 5);
		decryptButton.setLayoutData(fd);

		// Separator
		Label sep1 = new Label(mainParent, SWT.SEPARATOR | SWT.HORIZONTAL);
		fd = new FormData();
		fd.top = new FormAttachment(labelPassword, 10);
		fd.left = new FormAttachment(0);
		fd.right = new FormAttachment(100);
		sep1.setLayoutData(fd);

		// INTERNAL DATA
		cardsTable = new Table(mainParent, SWT.BORDER | SWT.CHECK | SWT.MULTI);
		fd = new FormData();
		fd.top = new FormAttachment(sep1, 10);
		fd.left = new FormAttachment(0, 5);
		fd.bottom = new FormAttachment(100);
		fd.right = new FormAttachment(100);
		fd.height = 500;
		cardsTable.setLayoutData(fd);

		createTable(cardsTable);
		cbtv = new CheckboxTableViewer(cardsTable);
		cbtv.setContentProvider(new MyContentProvider());
		cbtv.setLabelProvider(new MyLabelProvider());
				
		arg0.layout();
		arg0.pack(true);
		return mainParent;		
	}
    
    protected void createButtonsForButtonBar(Composite parent) {
		Button okB = createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		okB.setToolTipText("Completed card selection");
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
    }
    
	class MyLabelProvider implements ITableLabelProvider {
		// remember the listeners
		List listeners = new ArrayList();
		List images = new ArrayList();
		
		public void addListener(ILabelProviderListener listener) {
			listeners.add(listener);
		}

		public Image getColumnImage(Object element, int columnIndex) {
			Image ans = null;
			if (columnIndex == IMAGE_COLUMN) {
				byte [] data = ((ICard)element).getImage();
				ByteArrayInputStream bis = new ByteArrayInputStream(data);
				Image image = new Image(Display.getCurrent(), bis);
				ImageData imd = image.getImageData().scaledTo(120, 80);
				Image newimg = new Image(Display.getCurrent(), imd);
				image.dispose();
				ans = newimg;
				images.add(newimg); //remember for dispose()
			}
			return ans;
		}

		public String getColumnText(Object element, int columnIndex) {
			String ans = "";
			switch (columnIndex) {
			case NAME_COLUMN :
				ans = ((ICard)element).getName();
				break;
			case PROVIDER_COLUMN :
				ans = ((ICard)element).getIssuer();
				break;
			}
			return ans;
		}

		public void dispose() {
			Iterator iter = images.iterator();
			while (iter.hasNext()) {
				((Image)iter.next()).dispose();
			}
		}

		public boolean isLabelProperty(Object element, String property) {
			return false;
		}

		public void removeListener(ILabelProviderListener listener) {
			listeners.remove(listener);			
		}		
	}
	
	class MyContentProvider implements IStructuredContentProvider {

		public Object[] getElements(Object inputElement) {
			// we should have been passed an array of ICard
			Object[] ans = (Object[])inputElement;			
			return ans;
		}

		public void dispose() {
			// Nothing to do			
		}

		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			// Nothing to do			
		}		
	}

}
