/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Tie Li (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.crpps.ui.dialogs;

import java.io.File;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewCardStoreDialog extends Dialog {

	private Log log = LogFactory.getLog(NewCardStoreDialog.class);

	Shell shell;

	public String workdir = "";

	public String config = "";

	public String passwd = "";

	protected String confirmPasswd = "";

	Text text1;

	Text text2;

	Text text3;

	protected String filename;

	private Text path;

	private Text passwdText;

	private Text confirmPasswdText;

//	private boolean newRepository = false;

	public NewCardStoreDialog(Shell parentShell, String filename) {
//		public NewCardStoreDialog(Shell parentShell, String filename, boolean newRep) {
		super(parentShell);
		this.shell = parentShell;
		this.filename = filename;
//		this.newRep = newRep;
	}

	protected void setShellStyle(int newShellStyle) {
		// super.setShellStyle(newShellStyle);
		super.setShellStyle(SWT.APPLICATION_MODAL  | SWT.CLOSE | SWT.TITLE);
	}

	protected Control createDialogArea(Composite arg0) {
		Composite parent_ = (Composite) super.createDialogArea(arg0);
		Composite parent = new Composite(parent_, SWT.BORDER);
		FormLayout formLayout = new FormLayout();
		formLayout.marginBottom = 10;
		formLayout.marginTop = 10;
		formLayout.marginLeft = 10;
		formLayout.marginRight = 10;
		parent.setLayout(formLayout);

		Label label_ = new Label(parent, SWT.NONE);
		Font font = new Font(Display.getCurrent(),"Ariel", 8, SWT.BOLD);
		label_.setFont(font);
		label_.setText("Please supply the cardstore file and password:");
		FormData fd = new FormData();
		fd.top = new FormAttachment(0, 0);
		fd.left = new FormAttachment(0, 5);
		label_.setLayoutData(fd);

		// Separator
		Label label = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		fd = new FormData();
		fd.top = new FormAttachment(label_, 5);
		fd.left = new FormAttachment(0, 0);
		fd.width = 600;
		label.setLayoutData(fd);

		// CardStore location
		Label labelLocation = new Label(parent, SWT.NONE);
		fd = new FormData();
		fd.top = new FormAttachment(label, 30);
		fd.left = new FormAttachment(0, 10);
		labelLocation.setLayoutData(fd);
		labelLocation.setText("Cardstore file:");

		path = new Text(parent, SWT.BORDER);
		path.setText(filename);
		path.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				filename = path.getText();
			}
		});
		fd = new FormData();
		fd.top = new FormAttachment(label, 27);
		fd.left = new FormAttachment(labelLocation, 35);
		fd.width = 300;
		path.setLayoutData(fd);

		Button location = new Button(parent, SWT.BORDER);
		location.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				log.info("new repository?");
//				int flag = SWT.SAVE;
//				if( !newRepository) flag = SWT.OPEN;
				int flag = SWT.OPEN;
				FileDialog fileDialog = new FileDialog(shell, flag);
				fileDialog.setFilterExtensions(new String[] { "*.crds", "*" });
				filename = fileDialog.open();
				path.setText(filename);
//				if (!isExtant(filename))
//					newRepository = true;
//				path.setText(filename);
			}
		});
		location.setText("...");
		location.setEnabled(true);
		fd = new FormData();
		fd.top = new FormAttachment(label, 25);
		fd.left = new FormAttachment(path, 10);
		location.setLayoutData(fd);

		// PASSWD
		// Store Password
		Label labelPasswd = new Label(parent, SWT.NONE);
		labelPasswd.setText("Cardstore Password:");
		fd = new FormData();
		fd.top = new FormAttachment(labelLocation, 20);
		fd.left = new FormAttachment(0, 10);
		labelPasswd.setLayoutData(fd);

		passwdText = new Text(parent, SWT.BORDER|SWT.PASSWORD);
		passwdText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				passwd = passwdText.getText();
			}
		});
		fd = new FormData();
		fd.top = new FormAttachment(labelLocation, 16);
		fd.left = new FormAttachment(labelLocation, 35);
		fd.width = 100;
		passwdText.setLayoutData(fd);

		// CONFIRM PASSWD
		Label confirmlabelPasswd = new Label(parent, SWT.NONE);
		confirmlabelPasswd.setText("Confirm Password:");
		fd = new FormData();
		fd.top = new FormAttachment(labelPasswd, 10);
		fd.left = new FormAttachment(0, 10);
		confirmlabelPasswd.setLayoutData(fd);
		// Field password
		confirmPasswdText = new Text(parent, SWT.BORDER|SWT.PASSWORD);
		confirmPasswdText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				confirmPasswd = confirmPasswdText.getText();
			}
		});
		fd = new FormData();
		fd.top = new FormAttachment(labelPasswd, 5);
		fd.left = new FormAttachment(labelLocation, 35);
		fd.width = 100;
		confirmPasswdText.setLayoutData(fd);
		
		// parenthetical remark
		
		Label parentheticalRemark = new Label(parent, SWT.NONE);
		parentheticalRemark.setText("(if creating a new cardstore)");
		fd = new FormData();
		fd.top = new FormAttachment(labelPasswd, 10);
		fd.left = new FormAttachment(confirmPasswdText, 5);
		parentheticalRemark.setLayoutData(fd);
		
		return super.createDialogArea(arg0);
	}

	protected void okPressed() {
		if (("".equals(passwd)) || ( !isExtant(filename) && !passwd.equals(confirmPasswd))) {
			MessageBox messageBox = new MessageBox(shell, SWT.ERROR_UNSPECIFIED);
			messageBox.setMessage("Password mismatch");
			messageBox.setText("Password not correct");
			messageBox.open();
			return;
		}
		super.okPressed();
	}

	protected void cancelPressed() {
		filename = "";
		passwd = "";
		super.cancelPressed();
	}

	protected void configureShell(Shell arg0) {
		super.configureShell(arg0);
		String title = "Choose an i-Card Store";
		arg0.setText(title);
//		/	arg0.setSize(600, 250);
	}

	public String getPasswd() {
		return passwd;
	}

	public String getFilename() {
		return filename;
	}

	private boolean isExtant(String filename) {
		boolean ans = false;
		File icardFile = new File(filename);
		if ((icardFile.exists()) && (icardFile.isFile()))
			ans = true;
		return ans;
	}
}
