/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Tie Li (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.crpps.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * This dialog is now used for PIN code input
 * 
 * @author Li Tie
 */
public class PasswordDialog extends Dialog {

    Text text = null;

//    String filename;

    private String passwd = null;

    public PasswordDialog(Shell arg0) {
	super(arg0);
    }

    protected void setShellStyle(int newShellStyle) {
	// super.setShellStyle(newShellStyle);
	super.setShellStyle(SWT.APPLICATION_MODAL  | SWT.CLOSE | SWT.TITLE);
    }

    protected Control createDialogArea(Composite arg0) {
	Composite parent = new Composite(arg0, SWT.NONE);
	parent.setLayout(new FormLayout());

	Label label = new Label(parent, SWT.NONE);
	label.setText("The card is locked by your PIN code.");
	FormData fd = new FormData();
	fd.top = new FormAttachment(0, 5);
	fd.left = new FormAttachment(0, 5);
	label.setLayoutData(fd);

	Label label2 = new Label(parent, SWT.NONE);
	label2.setText("Please input the PIN code: ");
	fd = new FormData();
	fd.top = new FormAttachment(label, 10);
	fd.left = new FormAttachment(0, 5);
	label2.setLayoutData(fd);

	text = new Text(parent, SWT.BORDER | SWT.PASSWORD);
	fd = new FormData();
	fd.top = new FormAttachment(label2, 5);
	fd.left = new FormAttachment(0, 5);
	fd.right = new FormAttachment(100, -10);
	text.setLayoutData(fd);

	return super.createDialogArea(arg0);
    }

    protected void okPressed() {
	this.passwd = text.getText();
	super.okPressed();
    }

    protected void configureShell(Shell arg0) {
	super.configureShell(arg0);
	arg0.setText("Password Dialog");
    }

    public String getPassword() {
	return this.passwd;
    }
}
