/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Tie Li (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.crpps.app;

import org.eclipse.higgins.crpps.ui.CardListView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ApplicationTray {
	private TrayItem trayItem;
	private Image	  trayImage;
	
	public ApplicationTray(){
		trayImage = AbstractUIPlugin.imageDescriptorFromPlugin("org.eclipse.higgins.crpps", "/image/tb16.png").createImage();
	}
	
	public void createSysTray(final IWorkbenchWindow window){
		final Tray tray = window.getShell().getDisplay().getSystemTray();
        trayItem = new TrayItem(tray, SWT.NONE);
        trayItem.setImage(trayImage); 
		if(trayItem!=null){
			trayItem.addListener(SWT.MenuDetect, new Listener(){
				public void handleEvent(Event event) {
					MenuManager trayMenu = new MenuManager();
					Menu menu = trayMenu.createContextMenu(window.getShell());
				    Action exitSystem = new Action("Exit [&E]", null) {
				       public void run() {
				            PlatformUI.getWorkbench().close();
				       }
				    };
				    trayMenu.add(exitSystem);
					menu.setVisible(true);
				}
			});
			window.getShell().addShellListener(new ShellAdapter(){
				public void shellIconified(ShellEvent e) {
	                window.getShell().setVisible(false);
	           }
			});
			trayItem.addListener(SWT.Selection, new Listener(){
				public void handleEvent(Event event) {
					Shell shell = window.getShell();
					if(!shell.isVisible()){
						IWorkbenchWindow iww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
						try {
							// don't reset the CardListView, else we lose info on selected card
							//CardListView.observerPart.reset();
							PlatformUI.getWorkbench()
								.showPerspective("org.eclipse.higgins.crpps.perspective_manager", iww);
						} catch (WorkbenchException e) {
							e.printStackTrace();
						}
						shell.setVisible(true);
						window.getShell().setMinimized(false);
					}
				}
			});
		}
	}
	
	public void windowMinimized(final Shell shell){
		shell.setMinimized(true);
		shell.setVisible(false);
	}
	
    public void Dispose() {
        if (trayItem != null)   trayItem.dispose();
        if (trayImage != null)  trayImage.dispose();
    } 
}
