/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Tie Li (IBM Corporation) - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.crpps.service;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;

import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.crpps.Activator;

public class RPPSService2 {

	private ServerSocket _server;
	private int port = 8088;
	private Socket _conn;
	private PrintStream _out;
	//private Timer _timer;

	private Log log = LogFactory.getLog(RPPSService2.class);

	public RPPSService2() {
		//_timer = new Timer();		
		if (Activator.getDefault() != null) {
			System.setProperty("org.eclipse.higgins.sts.conf", Activator
					.getDefault().getPreferenceStore().getString(
							"org.eclipse.higgins.sts.conf"));
			System.setProperty("work.dir", Activator.getDefault()
					.getPreferenceStore().getString("work.dir"));
		}
	}

	public void listenOnPort() throws IOException, SOAPException {
		this._server = new ServerSocket(this.port);
		this._conn = null;

		log.info("RPPS service begin to work...");
		while (!Thread.interrupted()) {
			_conn = this._server.accept();
			_out = new PrintStream(_conn.getOutputStream(), true);

			BufferedReader in = new BufferedReader(new InputStreamReader(_conn
					.getInputStream()));
			log.info("Received a message from " + _conn.getInetAddress());

			parseInput(in, _out);
		}

		this._server.close();
	}

	private void parseInput(BufferedReader in, PrintStream out)
			throws IOException, SOAPException {
		StringBuffer buffer = new StringBuffer();

		while (true) {
			int ch = in.read();
			if (ch == -1  || ch == '\0' || ch== 0){
				// end-of-stream, assumes that sender closes sock @ end
				// of message. which is not a must in HTTP....
				break; 						
			} else {
				// beware: must coerce to char for proper append.
				// append(int) appends the string value of the integer....
				buffer.append((char) (ch & 0xFFFF));
			}
		}

		String raw_message = buffer.toString();
		// there seems to be cases, where the IE extension (HBXIE DLL) sends an
		// empty message. We need to recover somewhat gracefully by closing the 
		// sockets so that the browser doesn't hang up. (cbd@zurich.ibm.com)
		if (raw_message == null || raw_message.length() == 0) {
			log.warn("parseInput: empty message");
			in.close();
			out.close();
			return;
		}

		//_conn.shutdownInput();		
		
		String message = preprocess(raw_message);
		log.info("The message is : \n" + message);

		boolean error_seen = false;
		if (message.startsWith("<hbx_request>")) {
			//send maintain message every minute.
//			if(_timer==null){
//				_timer = new Timer();
//			}
//			_timer.schedule(new MaintainTask(), 0, 60000);
			
			SOAPMessage mess = parseMessage(message);
			try {
				InfoCardController.getInst().startup(mess, this);
			} catch (SOAPException soapex) {
				log.error("Error when receiving SOAPMessage: "+soapex.getLocalizedMessage(), soapex);
				error_seen = true;
			} catch (Exception ex) {
				log.error("Error when receiving SOAPMessage: "+ex.getLocalizedMessage(), ex);
				error_seen = true;
			} catch (Error rex) {
				log.error("Error when receiving SOAPMessage: "+rex.getLocalizedMessage(), rex);
				error_seen = true;
			}
		}
		
		if(error_seen){
			in.close();
			out.close();
		}
	}

	private String preprocess(String message) {
		if (message == null || "".equals(message))
			return "";
		StringBuffer sb = new StringBuffer();

		for (int i = 0; i < message.length(); i++) {
			char currChar = message.charAt(i);
			if (currChar != '\n' && currChar != '\r') {
				sb.append(currChar);
			}
		}

		return sb.toString();
	}

	public void notifyCanceled() {
//		if(_timer!=null){
//			_timer.cancel();
//			_timer = null;
//		}		
		try {
			_out.print("<COMMAND>CLOSE</COMMAND>/n");
			_out.flush();
			_out.close();
			_conn.close();
		} catch (IOException e) {
			log.error(e);
		}
	}

	public void notifySecurityToken(String token) {
//		if(_timer!=null){
//			_timer.cancel();
//			_timer = null;
//		}		
		try {
			if (token == null || "".equals(token)) {
				token = "<COMMAND>NO TOKEN</COMMAND>/n";
			}

			log.debug("token to be sent: " + token);
			_out.print(token);
			_out.flush();
			_out.close();
			_conn.close();
		} catch (IOException e) {
			log.error("");
		}
	}

	private SOAPMessage parseMessage(String message) throws SOAPException,
			IOException {
		String prefix = "<?xml version='1.0' encoding='UTF-8'?>\n<soap11:Envelope xmlns=\"http://www.eclipse.org/higgins\" xmlns:soap11=\"http://schemas.xmlsoap.org/soap/envelope/\">\n<soap11:Body>\n";
		String postfix = "</soap11:Body>\n</soap11:Envelope>\n";
		String target = prefix + message + postfix;
		// target = urlEncoding(target);
		// System.out.println(target);

		MessageFactory mf = MessageFactory.newInstance();
		ByteArrayInputStream bstr = new ByteArrayInputStream(target.getBytes());
		SOAPMessage mess = null;
		try {
			mess = mf.createMessage(new MimeHeaders(), bstr);
		} catch (SOAPException soapex) {
			log.error("Error: "+soapex.getLocalizedMessage(), soapex);
			return null;
		} catch (IOException ioex) {
			log.error("Error: "+ioex.getLocalizedMessage(), ioex);
			return null;
		} catch (Exception ex) {
			log.error("Error: "+ex.getLocalizedMessage(), ex);
			return null;
		} catch (Error rex) {
			log.error("Error: "+rex.getLocalizedMessage(), rex);
			return null;
		}
		return mess;
	}
	
//	private class MaintainTask extends TimerTask{
//		public void run() {
//			if(_conn.isConnected()){
//				_out.print("<COMMAND>KEEP CONNECTED</COMMAND>");
//				_out.flush();
//			}
//		}
//	}
}
