/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Bruce Rich (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 
package org.eclipse.higgins.crpps.ui;

import org.eclipse.higgins.icard.ICard;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BlankComposite implements ICardEdit {
	
	private Composite blank;
	
	public BlankComposite(Composite parent, final ICardEditView icev, FormToolkit toolkit) {
		blank = new Composite(parent, SWT.NONE);
	}

	public Composite getComposite() {
		return blank;
	}

	public boolean isCardDirty() {
		return false;
	}

	public void notifySelectionChanged(ICard card) {
	}

	public void reset() {
	}

}
