/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Tie Li (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.crpps.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * This dialog is now used for PIN code input
 */
public class PasswordDialog extends Dialog {

	private Text text = null;
	private Text confirmText = null;
    private boolean needConfirm;
    private String passwd = null;
    private String passwdConfirm = null;

    public PasswordDialog(Shell arg0, boolean needConfirm) {
		super(arg0);
		this.needConfirm = needConfirm;
    }

    protected void setShellStyle(int newShellStyle) {
		// super.setShellStyle(newShellStyle);
		super.setShellStyle(SWT.APPLICATION_MODAL  | SWT.CLOSE | SWT.TITLE);
    }

    protected Control createDialogArea(Composite arg0) {
		Composite parent = new Composite(arg0, SWT.NONE);
		parent.setLayout(new FormLayout());
	
		Label label = new Label(parent, SWT.NONE);
		if(needConfirm){
			label.setText("You want to lock the card by the PIN code.");
		} else {
			label.setText("The card has been locked by your PIN code.");
		}
		FormData fd = new FormData();
		fd.top = new FormAttachment(0, 5);
		fd.left = new FormAttachment(0, 5);
		label.setLayoutData(fd);
	
		Label label2 = new Label(parent, SWT.NONE);
		label2.setText("PIN code: ");
		fd = new FormData();
		fd.top = new FormAttachment(label, 10);
		fd.left = new FormAttachment(0, 5);
		label2.setLayoutData(fd);
	
		text = new Text(parent, SWT.BORDER | SWT.PASSWORD);
		fd = new FormData();
		fd.top = new FormAttachment(label, 10);
		fd.left = new FormAttachment(label2, 5);
		fd.right = new FormAttachment(100, -10);
		text.setLayoutData(fd);
				
		if(needConfirm){
			Label label3 = new Label(parent, SWT.NONE);
			fd = new FormData();
			fd.top = new FormAttachment(text, 10);
			fd.left = new FormAttachment(0, 5);
			label3.setLayoutData(fd);
			label3.setText("Confirm: ");
			
			confirmText = new Text(parent, SWT.BORDER | SWT.PASSWORD);
			fd = new FormData();
			fd.top = new FormAttachment(text, 10);
			fd.left = new FormAttachment(label3, 5);
			fd.right = new FormAttachment(100, -10);
			confirmText.setLayoutData(fd);
		}
	
		return super.createDialogArea(arg0);
    }

    protected void okPressed() {
		this.passwd = text.getText();
		if(needConfirm){
			this.passwdConfirm = confirmText.getText();
		}
		super.okPressed();
    }

    protected void configureShell(Shell arg0) {
		super.configureShell(arg0);
		arg0.setText("Password Dialog");
    }

    public String getPassword() {
		return this.passwd;
    }
    
    public boolean validateConfirm(){    	
    	if(passwd==null || passwd.equals("")) return false;
    	if(passwdConfirm==null || passwdConfirm.equals("")) return false;
    	
    	if(passwd.equals(passwdConfirm)) return true;
    	
    	return false;
    }
}
