/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Tie Li (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.crpps.app;

import higgins.login.demo.HigginsLogin;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.crpps.Activator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchWindowAdvisor extends WorkbenchWindowAdvisor {

    private Log log = LogFactory.getLog(ApplicationWorkbenchWindowAdvisor.class);
    
    private boolean debugMode;
    
	final static String TITLE = "Higgins Identity Selector";
	
	private ApplicationTray at;

	private static ApplicationWorkbenchWindowAdvisor instance;
	
	private Shell newShell;
	
	private IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
			
	public static ApplicationWorkbenchWindowAdvisor getInstance() {
	    return instance;
	}
	
	public boolean preWindowShellClose() {
		at.windowMinimized(getWindowConfigurer().getWindow().getShell());
		return false;
	}

	public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
		super(configurer);
		this.instance = this;
		
		String mode = System.getProperty("crpps_debug");
		if("true".equalsIgnoreCase(mode)){
			debugMode = true;
		} else {
			debugMode = false;
		}
	}

	public ActionBarAdvisor createActionBarAdvisor(
			IActionBarConfigurer configurer) {
		return new ApplicationActionBarAdvisor(configurer);
	}

	public void preWindowOpen() {
		log.debug("PreWindowOpen");
		IWorkbenchWindowConfigurer configurer = getWindowConfigurer();
		configurer.setInitialSize(new Point(prefs.getInt(Activator.SHELL_WIDTH), prefs.getInt(Activator.SHELL_HEIGHT)));
		configurer.setShowCoolBar(false);
		configurer.setShowProgressIndicator(true);
		configurer.setShowStatusLine(true);
		configurer.setTitle(TITLE+" [Provider default]");
		
		log.debug("Not set the window on top in debug mode");
		if(!debugMode){
			configurer.setShellStyle(SWT.ON_TOP | SWT.MAX | SWT.CLOSE);
		}
	}

	public void setTitle(String title) {
	    IWorkbenchWindowConfigurer configurer = getWindowConfigurer();
	    configurer.setTitle(TITLE+" "+title);
	}

	public void postWindowOpen() {		
		log.debug("PostWindowOpen");
	    Shell shell = getWindowConfigurer().getWindow().getShell();
	    Rectangle screenSize = Display.getDefault().getClientArea();
	    Rectangle frameSize = shell.getBounds();
	    // see if a previous location has been noted in Preferences
	    int location_x = prefs.getInt(Activator.SHELL_LOCATION_X);
	    int location_y = prefs.getInt(Activator.SHELL_LOCATION_Y);
	    if ((location_x == -1) || (location_y == -1)) {
	    	// center the window by default
	    	shell.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
	    } else {
	    	// user already positioned window
	    	//TODO error checking to make sure the window wasn't moved too far off-screen
	    	shell.setLocation(location_x, location_y);
	    }
	    at = new ApplicationTray();
	    at.createSysTray(getWindowConfigurer().getWindow());
	    
	    // track window being resized
	    shell.addControlListener(new ControlListener() {
	    	public void controlResized(ControlEvent ce) {
	    		Shell shell = (Shell)ce.getSource();
	    		Rectangle rect = shell.getBounds();
	    		prefs.setValue(Activator.SHELL_HEIGHT, rect.height);
	    		prefs.setValue(Activator.SHELL_WIDTH, rect.width);
	    	}
	    	
	    	public void controlMoved(ControlEvent ce) {
	    		Shell shell = (Shell)ce.getSource();
	    		Point point = shell.getLocation();
	    		prefs.setValue(Activator.SHELL_LOCATION_X, point.x);
	    		prefs.setValue(Activator.SHELL_LOCATION_Y, point.y);	    		
	    	}
	    });

	    if(!debugMode){
		    shell.addShellListener(new ShellListener(){
				public void shellActivated(ShellEvent e) {
					if(newShell!=null && !newShell.isDisposed()){
						newShell.setVisible(true);
						getWindowConfigurer().getWindow().getShell().moveAbove(newShell);
					}
				}
	
				public void shellClosed(ShellEvent e) {
					if(newShell!=null && !newShell.isDisposed()){
						newShell.setVisible(false);
					}
				}
	
				public void shellDeactivated(ShellEvent e) {
				}
	
				public void shellDeiconified(ShellEvent e) {
					if(newShell!=null && !newShell.isDisposed()){
						newShell.setVisible(true);
						getWindowConfigurer().getWindow().getShell().moveAbove(newShell);
					}				
				}
	
				public void shellIconified(ShellEvent e) {
					if(newShell!=null && !newShell.isDisposed()){
						newShell.setVisible(false);
					}
				}
			});
			
			Display display = shell.getDisplay();
			newShell = new Shell(display, SWT.ON_TOP);
			newShell.setBackground(shell.getDisplay().getSystemColor(SWT.COLOR_BLACK));
			newShell.setMaximized(true);
			new HigginsLogin().SetLayeredWindowAttributes(newShell.handle, null, 128, 2);
			newShell.open();
			newShell.addShellListener(new ShellListener(){
				public void shellActivated(ShellEvent e) {
					Shell prevShell = getWindowConfigurer().getWindow().getShell();
					if (!prevShell.isDisposed())
						prevShell.moveAbove(newShell);
				}
	
				public void shellClosed(ShellEvent e) {
					
				}
	
				public void shellDeactivated(ShellEvent e) {
					
				}
	
				public void shellDeiconified(ShellEvent e) {
					
				}
	
				public void shellIconified(ShellEvent e) {
					
				}
			});
			
			shell.setEnabled(true);
			shell.setVisible(true);
			shell.moveAbove(newShell);
		}
//		else {
//			Shell shell = getWindowConfigurer().getWindow().getShell();
//			shell = getWindowConfigurer().getWindow().getShell();
//			Rectangle screenSize = Display.getDefault().getClientArea();
//			Rectangle frameSize = shell.getBounds(); 
//			shell.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2); 
//			at = new ApplicationTray();
//			at.createSysTray(getWindowConfigurer().getWindow()); 
//		}
	}

	public void dispose() {
		if (at != null)
		at.Dispose();
	}
}
