package org.eclipse.higgins.crpps.service;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Vector;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CardHistoryManager {
	
	private Log log = LogFactory.getLog(CardHistoryManager.class);
	
	private static CardHistoryManager inst_ = null;
	
	private CardHistoryManager(){

	}
		
	public static CardHistoryManager getInst(){
		if(inst_==null){
			inst_ = new CardHistoryManager();
		}
		return inst_;
	}
	
	public Vector searchCardHistoryBean(String site_URL){
		if(site_URL== null){
			return null;
		}
		
		Vector chbs = new Vector();
		Document doc = null;
		Element rootElement = null;
		
		String configFolder = null;
		try {
			configFolder = getDefaultConfigFolder();
			if(configFolder!=null && configFolder.length()>0){
				String historyFileName = configFolder + "/cardHistory.xml";
				File historyFile = new File (historyFileName);
				byte[] fileData = null;
				if(historyFile.exists()){					
					fileData = new byte[(int) historyFile.length()];
					FileInputStream fis = new FileInputStream(historyFile);
					fis.read(fileData);
					fis.close();
				}
				if(fileData!=null){
					DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
					DocumentBuilder db = dbf.newDocumentBuilder();
					doc = db.parse(new ByteArrayInputStream(fileData));
					rootElement = doc.getDocumentElement();
				}
			}
		} catch (IOException e) {
			log.error("Can not get card history file" , e);
			return chbs;
		} catch (ParserConfigurationException e) {
			log.error("XML parse error" , e);
			return chbs;
		} catch (SAXException e) {
			log.error("XML parse error" , e);
			return chbs;
		}
		
		NodeList nl = rootElement==null ? null : rootElement.getChildNodes();
		if(nl!=null && nl.getLength()>0){
			for(int i=0; i<nl.getLength(); i++){
				Node node = nl.item(i);
				if(node instanceof Element){
					Element element = (Element)node;
					String url = element.getAttribute("url");
					if(site_URL.equals(url)){
						NodeList cardElements = element.getChildNodes();
						int length = cardElements.getLength();
						for(int j=0; j<length; j++){
							Node cardElement = cardElements.item(j);
							if(cardElement!=null && cardElement instanceof Element){
								Element cardElement_ = (Element) cardElement;
								CardHistoryBean chb = new CardHistoryBean();
								chb.setCard_id(cardElement_.getAttribute("id"));
								NodeList cardFields = cardElement_.getChildNodes();
								for(int k=0; k<cardFields.getLength(); k++){
									Node cardField = cardFields.item(k);
									if(cardField!=null && (cardField instanceof Element)){
										if("last_visit_date".equals(cardField.getNodeName())){											
											chb.setLast_visit_date(
												org.eclipse.higgins.sts.utilities.XMLHelper
													.getTextContent((Element)cardField));								
											//chb.setLast_visit_date(cardField.getTextContent());
										}
										if("frequency".equals(cardField.getNodeName())){
											chb.setFrequency(
												org.eclipse.higgins.sts.utilities.XMLHelper
													.getTextContent((Element)cardField));
											//chb.setFrequency(cardField.getTextContent());
										}
									}
								}
								chbs.add(chb);
							}
						}
						break;
					}
				}
			}
		}
		
		return chbs;
	}
	
	public synchronized void writeCardHistory(CardHistoryBean chb){	
		Document doc = null;
		Element rootElement = null;
		File historyFile = null;
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		DocumentBuilder db = null;
		
		String configFolder = null;
		try {
			db = dbf.newDocumentBuilder();
			configFolder = getDefaultConfigFolder();
			if(configFolder!=null && configFolder.length()>0){
				String historyFileName = configFolder + "/cardHistory.xml";
				historyFile = new File (historyFileName);
				byte[] fileData = null;
				if(historyFile.exists()){					
					fileData = new byte[(int) historyFile.length()];
					FileInputStream fis = new FileInputStream(historyFile);
					fis.read(fileData);
					fis.close();
				} else {
					historyFile.createNewFile();
				}
				
				if(fileData!=null){
					doc = db.parse(new ByteArrayInputStream(fileData));
					rootElement = doc.getDocumentElement();
				}
			}
		} catch (IOException e) {
			log.error("Can not get card history file" , e);
		} catch (ParserConfigurationException e) {
			log.error("XML parse error" , e);
		} catch (SAXException e) {
			log.error("XML parse error" , e);
		}
		
		if(rootElement==null){	
			doc = db.newDocument();
			rootElement = doc.createElement("card_history");
		} 
		
		String url = chb.getDoc_url();
		Element siteElem = null;
		
		NodeList nl = rootElement.getChildNodes();
		for(int i=0 ; i<nl.getLength(); i++){		
			Node tmpSiteNode = nl.item(i);
			if(tmpSiteNode instanceof Element){
				Element tmpSiteElem = (Element) tmpSiteNode;
				if(url.equals(tmpSiteElem.getAttribute("url"))){
					siteElem = tmpSiteElem;
					break;
				}
			}
		}
		if(siteElem == null){
			siteElem = doc.createElement("site");
			siteElem.setAttribute("url", url);
			rootElement.appendChild(siteElem);
		}
			
		Element cardElem = null;
		
		NodeList cardElems = siteElem.getChildNodes();
		for(int i=0; i<cardElems.getLength(); i++){			
			Node tmpCardNode = cardElems.item(i);
			if(tmpCardNode instanceof Element){
				Element tmpCardElem = (Element) tmpCardNode;
				if(chb.getCard_id().equals(tmpCardElem.getAttribute("id"))){
					cardElem = tmpCardElem;
					break;
				}
			}
		}
		if(cardElem == null){
			cardElem = doc.createElement("card");
			cardElem.setAttribute("id", chb.getCard_id());
			siteElem.appendChild(cardElem);
			
			Element last_dateElem = doc.createElement("last_visit_date");
			Date now = new Date();
			org.eclipse.higgins.sts.utilities
				.XMLHelper.setTextContent(last_dateElem, now.toString());
			//last_dateElem.setTextContent(now.toString());
			cardElem.appendChild(last_dateElem);
				
			Element freqElem = doc.createElement("frequency");
			org.eclipse.higgins.sts.utilities
				.XMLHelper.setTextContent(freqElem, "1");
			//freqElem.setTextContent("1");
			cardElem.appendChild(freqElem);
		} else {
			NodeList cardElemChildren = cardElem.getChildNodes();
			for(int i=0; i<cardElemChildren.getLength(); i++){
				Node cardNode = cardElemChildren.item(i);
				if(cardNode!=null && (cardNode instanceof Element)){
					Element elem = (Element) cardNode;
					if("last_visit_date".equals(elem.getNodeName())){
						Date now = new Date();
						org.eclipse.higgins.sts.utilities
							.XMLHelper.setTextContent(elem, now.toString());
						//elem.setTextContent(now.toString());
					}
					if("frequency".equals(elem.getNodeName())){
						//String freq = elem.getTextContent();
						String freq = org.eclipse.higgins.sts.utilities
							.XMLHelper.getTextContent(elem);						
						org.eclipse.higgins.sts.utilities
							.XMLHelper.setTextContent(elem, 
									Integer.toString((Integer.parseInt(freq) + 1)));
						//elem.setTextContent(Integer.toString((Integer.parseInt(freq) + 1)));
					}
				}
			}
		}
			
		TransformerFactory tf = TransformerFactory.newInstance();
		Transformer ts = null;
		try {
			ts = tf.newTransformer();
			DOMSource source = new DOMSource(rootElement);
			StreamResult result = new StreamResult(new FileOutputStream(historyFile));
			ts.transform(source, result);
		} catch (TransformerConfigurationException e) {
			log.error("cannot create transformer.", e);
		} catch (FileNotFoundException e) {
			log.error("history file not exist.", e);
		} catch (TransformerException e) {
			log.error("transform exception", e);
		}
	}
	
    private String getDefaultConfigFolder() throws IOException {
		Bundle bundle = Platform.getBundle("org.eclipse.higgins.crpps");
		URL configURL = FileLocator.find(bundle, new Path("/configuration"), null);
    	if(configURL!=null){
			URL fileUrl = FileLocator.resolve(configURL);
			String configAbsolutePath = fileUrl.getPath();
			return configAbsolutePath;
    	}
		
		return "";
	}
}
