/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Bruce Rich (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 
package org.eclipse.higgins.crpps.ui;

import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class CardListComposite implements ICardEdit, ISelectionChangedListener {
	
//	private Composite myComposite;
	private Composite body;
	private Composite myParent;
	private FormToolkit toolkit;
	private ScrolledForm form;
	private Text count;

	private Log log = LogFactory.getLog(CardListComposite.class);

	private int howManyCards = 0;
	private List cards = new ArrayList();

	public CardListComposite(Composite parent, 
			final ICardEditView icev, 
			FormToolkit toolkit) {
		log.info("constructor entered");
		this.myParent = parent;
		this.toolkit = toolkit;
		reset();
		CardListView.getInstance().addSelectionChangedListener(this);
	}
	
	/**
	 * React to single select events only.
	 * When we turn off reset() as a public API, then we
	 * need to react to that one also
	 */
	public void selectionChanged(SelectionChangedEvent event) {
		if (event.getSelection() instanceof CardSelection) {
			CardSelection cs = (CardSelection)event.getSelection();
			switch  (cs.getSelType()) {
			case CardSelection.TYPE_INFORM :
				notifySelectionChanged(cs.getCard());
				break;
			case CardSelection.TYPE_MULTISELECT :
				ICard card = cs.getCard();
				if (card != null)
					notifySelectionChanged(card);
				List cards = cs.getCardList();
				if ((cards != null) && (cards.size() > 0))
					notifySelectionChanged(cards);
				break;
			}
		}
	}
	
	/**
	 * Update the visualized information with data from the card
	 * @param card
	 */
	public void notifySelectionChanged(ICard card) {
		log.info("notifySelectionChanged(ICard) entered");
		
		if (alreadyKnowAboutThisOne(card))
			return;
		count.setText("You have selected   "+ ++howManyCards +"   I-Cards");
		
		Text newCard = new Text(body, SWT.NONE);
		newCard.setText(card.getName());

		Text type = new Text(body, SWT.NONE);
		type.setText((card.isSelfIssued() ? "Self-issued Card" : "Managed Card"));

		Date time = card.getTimeIssued();
		String dateStr = "Not specified";
		if (time != null) {
			dateStr = DateFormat.getDateInstance().format(time);
		}

		Text addlInfo = new Text(body, SWT.NONE);
		addlInfo.setText((card.isSelfIssued() ? "Created on: " : "Issued on: ")+dateStr);
		
		toolkit.createSeparator(body, SWT.WRAP | SWT.SEPARATOR | SWT.HORIZONTAL);
		myParent.getParent().layout(true, true);
	}

	/**
	 * Update the visualized information with data from the card
	 * @param card
	 */
	public void notifySelectionChanged(List cards) {
		log.info("notifySelectionChanged(List) entered");
		
		if (cards == null)
			cards = new ArrayList();
		howManyCards = cards.size();			
		count.setText("You have selected   "+howManyCards +"   I-Cards");
		Iterator iter = cards.iterator();
		while (iter.hasNext()) {
			ICard card = (ICard) iter.next();
			Text newCard = new Text(body, SWT.NONE);
			newCard.setText(card.getName());
	
			Text type = new Text(body, SWT.NONE);
			type.setText((card.isSelfIssued() ? "Self-issued Card" : "Managed Card"));
	
			Date time = card.getTimeIssued();
			String dateStr = "Not specified";
			if (time != null) {
				dateStr = DateFormat.getDateInstance().format(time);
			}
	
			Text addlInfo = new Text(body, SWT.NONE);
			addlInfo.setText((card.isSelfIssued() ? "Created on: " : "Issued on: ")+dateStr);
			
			toolkit.createSeparator(body, SWT.WRAP | SWT.SEPARATOR | SWT.HORIZONTAL);
		}
		myParent.getParent().layout(true, true);
	}

	public Composite getComposite() {
		return this.form;
	}
	
	public boolean isCardDirty() {
		return false;
	}

	public void reset() {
		if (this.form != null) {
			form.dispose();
			form = null;
		}
		cards = new ArrayList();
		howManyCards = 0;
		form = toolkit.createScrolledForm(myParent);
		body = form.getBody();
		RowLayout rl = new RowLayout(SWT.VERTICAL);
		body.setLayout(rl);
		form.setText("Summary information on the selected i-cards");
		Path path = new Path("/image/form_banner.gif");
		URL url = FileLocator.find(Platform.getBundle("org.eclipse.higgins.crpps"), 
				path, null);
		ImageDescriptor imageDesc = ImageDescriptor.createFromURL(url);
		form.setBackgroundImage(imageDesc.createImage());
		count = new Text(body, SWT.NONE);
		count.setText("You have selected "+howManyCards+" I-Cards");
		Label sep = new Label(body, SWT.SEPARATOR | SWT.HORIZONTAL);
		sep.setLayoutData(new RowData(160, SWT.DEFAULT));
	}

	private boolean alreadyKnowAboutThisOne(ICard card) {
		boolean ans = false;
		for (int i=0, j=cards.size(); i<j; i++) {
			if (card == cards.get(i)) {
				ans = true;
				break;
			}
		}
		if (!ans)
			cards.add(card);
		return ans;
	}
}
