/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Tie Li (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 
package org.eclipse.higgins.crpps.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.higgins.crpps.ui.dialogs.ConfirmAbandonEdit;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.io.RoamingStoreElementFormat;
import org.eclipse.higgins.icard.provider.securestorage.CardStorePersonalCard;
import org.eclipse.higgins.sts.utilities.XMLHelper;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EditComposite implements ICardEdit, ISelectionChangedListener {
	
	private Log log = LogFactory.getLog(EditComposite.class);
 
	private ICard card;
	private ICardEditView icev;
	private Composite myParent;
	private Composite comp;
	private FormToolkit toolkit;

	private Text idText = null;
	private Text cuidText = null;
	private Text issuerText = null;
	private Text issuerNameText = null;
	private Text timeissuedText = null;

	private Text cardName = null;
	private Text cardType = null;
	
	private Button saveButton;
	private Button cancelButton;

	private Composite cardEditTableAnchor;
    private Table cardEditTable;
	final int EDITABLECOLUMN = 1;

	private Table claimTypeList = null;

//	private boolean isEditable;
//	private boolean isEditActive;
	private boolean isCardDirty;
	private boolean isOldCard;
	
	private Form editForm;
//	private String imageFilename;
	private static final int imageX = 100;
	private static final int imageY = 60;
    private final Point imageSize = new Point(imageX, imageY);
	private byte[] img_rawdata = null;
	private String imageType;
    private Image image;
    private Composite imageComp;
    
	private static final int ELEMENTSPREPENDEDTOTABLE = 1; // we added the cardname to front, if icon is added, that would make two
	private static int textWidth = 240;
    
    // this should be replaced by data coming from the preferences window
    String[][] claims = {
	    { "First Name",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname" },
	    { "Last Name",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname" },
	    { "Street",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/streetaddress" },
	    { "Locality (City)",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/locality" },
	    { "State or Province",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/stateorprovince" },
	    { "Postal Code",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/postalcode" },
	    { "Country/Region",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/country" },
	    { "Phone Number",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/homephone" },
	    { "Other Phone",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/otherphone" },
	    { "Mobile Phone",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/mobilephone" },
	    { "Date of Birth",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/dateofbirth" },
	    { "Gender",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/gender" },
	    { "Web Page",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/webpage" },
	    { "Email",
		    "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress" } };

//    private String exportedCardName;

//    private Text cardNameText;
//
//    private String imageFilename = null;




	public EditComposite(Composite parent, final ICardEditView icev, FormToolkit toolkit) {
		this.icev = icev;
		this.myParent = parent;
		final Shell shell = myParent.getShell();
		//parent.setLayout(new FillLayout());

		this.toolkit = toolkit;
		editForm = toolkit.createForm(parent);
		this.comp = editForm;
		Composite mainComp = editForm.getBody();
		FormLayout formLayout = new FormLayout();
//		formLayout.marginBottom = 10;
//		formLayout.marginTop = 10;
//		formLayout.marginLeft = 10;
//		formLayout.marginRight = 10;
		mainComp.setLayout(formLayout);

		String titleS = "Detailed information about the selected i-card";
		editForm.setText(titleS);
		Path path = new Path("/image/form_banner.gif");
		URL url = FileLocator.find(Platform.getBundle("org.eclipse.higgins.crpps"), 
				path, null);
		ImageDescriptor imageDesc = ImageDescriptor.createFromURL(url);
		editForm.setBackgroundImage(imageDesc.createImage());

		Composite controlComp = new Composite(mainComp, SWT.NONE);
		controlComp.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
		FormData fd = new FormData();
		fd.top = new FormAttachment(0, 0);
		fd.left = new FormAttachment(0, 0);
		controlComp.setLayoutData(fd);
		controlComp.setLayout(new RowLayout());

		this.saveButton = new Button(controlComp, SWT.NONE);
		saveButton.setText("Save");
		saveButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				log.info("save card");
				if (!isCardDirty && ((card.getID() == null) || ("".equals(card.getID())))) {
					MessageBox messageBox = new MessageBox(shell, SWT.ERROR_UNSPECIFIED);
					messageBox.setMessage("Cannot save an empty card\n\n" +
							"Please enter some information (other than Card Name) or select Cancel");
					messageBox.setText("Error while saving");
					messageBox.open();
				} else {
//todo				if (icev.isCardDirty()) {
					saveChanges(isOldCard);
//todo				}
//					icev.reset();
					CardListView.getInstance().setSelection(new CardSelection(CardSelection.TYPE_RESET)); // clear any residual information from the edit window
				}
			}
		});

		this.cancelButton = new Button(controlComp, SWT.NONE);
		cancelButton.setText("Cancel");
		cancelButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				log.info("cancel edit");
				int resp = IDialogConstants.OK_ID;
				if (icev.isCardDirty()) {
					ConfirmAbandonEdit cae = new ConfirmAbandonEdit(shell);
					cae.setBlockOnOpen(true);
					resp = cae.open();
				}
				if (resp == IDialogConstants.OK_ID) {
//					icev.reset();
					CardSelection cs = new CardSelection(CardSelection.TYPE_RESET); // clear any residual information from the edit window
					cs.setCard(card);
					CardListView.getInstance().setSelection(cs);
				}
			}
		});

		// Separator
		Label sep1 = new Label(mainComp, SWT.SEPARATOR | SWT.HORIZONTAL);
		fd = new FormData();
		fd.top = new FormAttachment(controlComp, 5);
		fd.left = new FormAttachment(0,0);
		fd.right = new FormAttachment(100,0);;
		sep1.setLayoutData(fd);

		/* 
		 * Create the visualization for the card
		 */
		Composite cardNameComp = visualizeCard(mainComp);
		//Composite cardNameComp = new Composite(mainComp, SWT.NONE);
		fd = new FormData();
		fd.top = new FormAttachment(sep1, 0);
		fd.left = new FormAttachment(0, 0);
		fd.bottom = new FormAttachment(100, 0); //fill the window
		//fd.right = new FormAttachment(100, 0);
		//fd.bottom = new FormAttachment(0, 100);
		cardNameComp.setLayoutData(fd);
//		cardNameComp.setLayout(new FormLayout());
//		cardNameComp.setBackground(new Color(Display.getCurrent(), 255, 255, 255));

		this.cardName = new Text(parent, SWT.NONE);
//		cardName.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
//		fd = new FormData();
//		fd.top = new FormAttachment(0, 0);
//		fd.left = new FormAttachment(0, 10);
//		fd.right = new FormAttachment(100, -10);
//		this.cardName.setLayoutData(fd);
//		FontData fontData = new FontData();
//		fontData.setHeight(20);
//		fontData.setName("Arial");
//		fontData.setStyle(SWT.BOLD);
//		Font font = new Font(Display.getDefault(), fontData);
//		this.cardName.setFont(font);
//
		this.cardType = new Text(parent, SWT.NONE);
//		cardType.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
//		fd = new FormData();
//		fd.top = new FormAttachment(cardName, 5);
//		fd.left = new FormAttachment(0, 0);
//		fd.right = new FormAttachment(100, -10);
//		this.cardType.setLayoutData(fd);
//		fontData = new FontData();
//		fontData.setHeight(8);
//		font = new Font(Display.getDefault(), fontData);
//		this.cardType.setFont(font);
//
//		Label line = new Label(mainComp, SWT.SEPARATOR | SWT.HORIZONTAL);
//		fd = new FormData();
//		fd.top = new FormAttachment(cardNameComp, 10);
//		fd.left = new FormAttachment(0, 0);
//		fd.width = 600;
//		line.setLayoutData(fd);
//
//		Label idLabel = new Label(mainComp, SWT.NONE);
//		idLabel.setText("ID: ");
//		idLabel.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
//		fd = new FormData();
//		fd.top = new FormAttachment(line, 10);
//		fd.left = new FormAttachment(0, 10);
//		fd.right = new FormAttachment(20, 0);
//		idLabel.setLayoutData(fd);
//
		idText = new Text(parent, SWT.BORDER);
//		idText.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
//		idText.setEditable(false);
//		fd = new FormData();
//		fd.top = new FormAttachment(line, 10);
//		fd.left = new FormAttachment(idLabel, 5);
//		fd.right = new FormAttachment(90, 0);
//		idText.setLayoutData(fd);
//
//		Label cuidLabel = new Label(mainComp, SWT.None);
//		cuidLabel.setText("UUID: ");
//		cuidLabel.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
//		fd = new FormData();
//		fd.top = new FormAttachment(idText, 10);
//		fd.left = new FormAttachment(0, 10);
//		fd.right = new FormAttachment(20, 0);
//		cuidLabel.setLayoutData(fd);
//
		cuidText = new Text(parent, SWT.BORDER);
//		cuidText.setEditable(false);
//		cuidText.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
//		fd = new FormData();
//		fd.top = new FormAttachment(idText, 10);
//		fd.left = new FormAttachment(cuidLabel, 5);
//		fd.right = new FormAttachment(90, 0);
//		cuidText.setLayoutData(fd);
//
//		Label issuerLabel = new Label(mainComp, SWT.NONE);
//		issuerLabel.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
//		issuerLabel.setText("Issuer: ");
//		fd = new FormData();
//		fd.top = new FormAttachment(cuidText, 10);
//		fd.left = new FormAttachment(0, 10);
//		fd.right = new FormAttachment(20, 0);
//		issuerLabel.setLayoutData(fd);
//
		issuerText = new Text(parent, SWT.BORDER);
//		issuerText.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
//		issuerText.setEditable(false);
//		fd = new FormData();
//		fd.top = new FormAttachment(cuidText, 10);
//		fd.left = new FormAttachment(issuerLabel, 5);
//		fd.right = new FormAttachment(90, 0);
//		issuerText.setLayoutData(fd);
//
//		Label issuerNameLabel = new Label(mainComp, SWT.NONE);
//		issuerNameLabel.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
//		issuerNameLabel.setText("Issuer Name: ");
//		fd = new FormData();
//		fd.top = new FormAttachment(issuerText, 10);
//		fd.left = new FormAttachment(0, 10);
//		fd.right = new FormAttachment(20, 0);
//		issuerNameLabel.setLayoutData(fd);
//
		issuerNameText = new Text(parent, SWT.BORDER);
//		issuerNameText.setEditable(false);
//		issuerNameText.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
//		fd = new FormData();
//		fd.top = new FormAttachment(issuerText, 10);
//		fd.left = new FormAttachment(issuerNameLabel, 5);
//		fd.right = new FormAttachment(90, 0);
//		issuerNameText.setLayoutData(fd);
//
//		Label timeIssued = new Label(mainComp, SWT.NONE);
//		timeIssued.setText("Time issued: ");
//		timeIssued.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
//		fd = new FormData();
//		fd.top = new FormAttachment(issuerNameText, 10);
//		fd.left = new FormAttachment(0, 10);
//		fd.right = new FormAttachment(20, 0);
//		timeIssued.setLayoutData(fd);
//
		this.timeissuedText = new Text(parent, SWT.BORDER);
//		this.timeissuedText.setEditable(false);
//		this.timeissuedText.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
//		fd = new FormData();
//		fd.top = new FormAttachment(issuerNameText, 10);
//		fd.left = new FormAttachment(timeIssued, 5);
//		fd.right = new FormAttachment(90, 0);
//		this.timeissuedText.setLayoutData(fd);
//
//		Label supportedClaims = new Label(mainComp, SWT.NONE);
//		supportedClaims.setText("Information: ");
//		supportedClaims.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
//		fd = new FormData();
//		fd.top = new FormAttachment(timeissuedText, 10);
//		fd.left = new FormAttachment(0, 10);
//		fd.right = new FormAttachment(20, 0);
//		supportedClaims.setLayoutData(fd);
//
		this.claimTypeList = new Table(parent, SWT.BORDER | SWT.FULL_SELECTION);
//		this.claimTypeList.setLinesVisible(true);
//		fd = new FormData();
//		fd.top = new FormAttachment(timeissuedText, 10);
//		fd.left = new FormAttachment(supportedClaims, 5);
//		fd.right = new FormAttachment(90, 0);
//		fd.bottom = new FormAttachment(100, -15);
//		this.claimTypeList.setLayoutData(fd);
//
//		TableColumn tc = new TableColumn(this.claimTypeList, SWT.NONE);
//		tc.setText("Name");
//		tc.setWidth(150);
//		tc = new TableColumn(this.claimTypeList, SWT.NONE);
//		tc.setText("Value");
//		tc.setWidth(300);
//		this.claimTypeList.setHeaderVisible(true);
		CardListView.getInstance().addSelectionChangedListener(this);
	}
	
	/**
	 * React to single select events only.
	 * If/when we turn off reset() as a public API, then we
	 * need to react to that one also
	 */
	public void selectionChanged(SelectionChangedEvent event) {
		if (event.getSelection() instanceof CardSelection) {
			CardSelection cs = (CardSelection)event.getSelection();
			switch  (cs.getSelType()) {
			case CardSelection.TYPE_INFORM :
				notifySelectionChanged(cs.getCard());
				break;
			}
		}
	}
	
	/**
	 * Update the visualized information with data from the card
	 * @param card
	 */
	public void notifySelectionChanged(ICard card) {
		log.info("notifySelectionChanged");
		reset();
		cardEditTable = new Table(cardEditTableAnchor, SWT.BORDER | SWT.FULL_SELECTION);
		cardEditTable.setLinesVisible(true);
		FormData fd = new FormData();
		fd.top = new FormAttachment(cardEditTableAnchor, 0);
		fd.left = new FormAttachment(cardEditTableAnchor, 0);
		fd.right = new FormAttachment(100, 0);
		cardEditTable.setLayoutData(fd);
		this.card = card; // remember the card for modify
//		if (card.isEditable())
//			this.isEditable = true;
		cardName.setText(card.getName());
		editForm.setText("Edit information for "+card.getName());
		cardType.setText(card.getDescription());

		idText.setText(card.getID());
		cuidText.setText(card.getCUID().toString());
		issuerText.setText(card.getIssuer());

		String issuer = card.getIssuerName();
		if (issuer == null) issuer = "Not specified";		
		issuerNameText.setText(issuer);

		Date time = card.getTimeIssued();
		String timeStr = "Not specified";
		String dateStr = "Not specified";
		if (time != null) {
			timeStr = time.toString();
			dateStr = DateFormat.getDateInstance().format(time);
		}
		timeissuedText.setText(timeStr);

		// get the raw bytes out of the card
		img_rawdata = card.getImage();
		imageType = card.getImageType();
		Image image = null;
		if (img_rawdata == null) {
			log.warn("Error when loading ICard image of type [" + imageType
					+ "] for Icard [" + card.getID() + "]");
			image = CardListView.INFOCARD;
		}
		if (image == null) {
			ByteArrayInputStream bis = new ByteArrayInputStream(img_rawdata);
			try {
				image = new Image(Display.getCurrent(), bis);
			} catch(org.eclipse.swt.SWTException e) {
				// in case of failure try to decode the stream as base64 and reconstruct the image
				log.warn("Could not construct the image, trying again after base64 decoding");
				img_rawdata = Base64.decodeBase64(img_rawdata);
				bis = new ByteArrayInputStream(img_rawdata);
				try {
					image = new Image(Display.getCurrent(), bis);
				} catch(org.eclipse.swt.SWTException e1) {
					log.warn("Could not construct the image using base64 decoding: we keep the default image");
				}
			}
		}
		
		if (image != null) {
			// scale the image to fit inside the real estate we have to offer...
			ImageData imd = image.getImageData().scaledTo(imageSize.x, imageSize.y);
			image.dispose();
			Image newimg = new Image(Display.getCurrent(), imd);
			imageComp.setBackgroundImage(newimg);
		}

		this.claimTypeList.removeAll();
		Iterator claims = card.getSupportedClaimTypes();
		if (claims == null) {
			log.debug("getting claims: no claims");		
		} else {
			log.debug("getting claims: "+claims);
			while (claims.hasNext()) {
				IClaimType type = (IClaimType) claims.next();
				IClaim claim = null;
				try {
					claim = card.getClaim(type.getType());
				}catch(AuthenticationRequiredException e){
				}catch(InvalidTypeException e){ 
				}catch (CardException e) {
					log.error("Error when getting claims", e);
				}
				String value = "";
				if (claim != null && claim instanceof ISimpleClaim) {
					ISimpleClaim simpleClaim = (ISimpleClaim) claim;
					List l = simpleClaim.getValues();
					if (l!=null && l.size() > 0) {
						value = (String) l.get(0);
					}
				}

				TableItem ti = new TableItem(this.claimTypeList, SWT.NONE);
				ti.setText(0, type.getDisplayName());
				ti.setText(1, value);	
			}
		}
		String cardNameS = "";
		if (card != null)
			cardNameS = card.getName();
		createTable(cardEditTable);
		// gotta look at the incoming card and use values from it when set
		// when NOT set in the incoming card, put it in the possible set
		// if these are still blank on the other side of the editor, don't
		//   put them in the card image
		addProperties(cardEditTable, "cardName", cardNameS, null);
		for (int i = 0; i < this.claims.length; i++) {
		    String value = "";
		    if (this.card != null) {
			try {
				boolean skipClaim = false;
			    Iterator iter = this.card.getClaims();
			    while (iter.hasNext()) {
			    	ClaimValue claimValue = (ClaimValue) iter.next();
					if (this.claims[i][1].equals(claimValue.getType().getType())) {
						value = claimValue.getValue();
					    addProperties(cardEditTable, this.claims[i][0], value, null);
					    skipClaim = true;
					    break;
					}
			    }
			    if (skipClaim)
			    	;
			    else
			    	addProperties(cardEditTable, this.claims[i][0], "", null);
			} catch (AuthenticationRequiredException are) {
				// do nothing for managed cards...it's ok
			} catch (CardException e) {
			    log.error("Error when retrieving claims", e);
			}

		    }
		    //addProperties(cardEditTable, this.claims[i][0], value, null);
		}
		// ok, should have everything in the table that we need
		
//		// create a TableCursor to allow arrows keys to work
//		final TableCursor cursor = new TableCursor(cardEditTable, SWT.NONE);
//		// create an editor that will work with the cursor
//		// (have to use a ControlEditor because now we're working off the cursor, not the table
//		final ControlEditor cEditor = new ControlEditor(cursor);
//		cEditor.grabHorizontal = true;
//		cEditor.grabVertical = true;
//		// add the eventhandling
//		cursor.addSelectionListener(new SelectionAdapter() {
//			public void widgetSelected(SelectionEvent ev) {
//				// select the row where the cursor is
//				cardEditTable.setSelection(new TableItem[] { cursor.getRow() }); // 
//			}
//			// called when the user hits Enter
//			public void widgetDefaultSelected(SelectionEvent ev) {
//				// begin editing session
//				final Text text = new Text(cursor, SWT.NONE);
//				text.setFocus();
//				
//				// copy from the cell to the control
//				text.setText(cursor.getRow().getText(EDITABLECOLUMN));
//				text.setFocus();
//				// add a handler to respond to key presses
//				text.addKeyListener(new KeyAdapter() {
//					public void keyPressed(KeyEvent ev) {
//						// end the editing and save the text if Enter
//						// end the editing and throw away changes if Esc
//						switch(ev.keyCode) {
//						case SWT.CR:
//							cursor.getRow().setText(EDITABLECOLUMN, text.getText());
//						case SWT.ESC:
//							text.dispose();
//							break;
//						}
//						
//					}
//				});
//				cEditor.setEditor(text);
//			}
//		});
		
		cardEditTable.pack();
		myParent.getParent().layout(true, true);
	}

	public Composite getComposite() {
		return this.comp;
	}
	
	public boolean isCardDirty() {
		return this.isCardDirty;
	}
	
	public void reset(){
		if(idText!=null) idText.setText("");
		if(cuidText!=null) cuidText.setText("");
		if(issuerText!=null) issuerText.setText("");
		if(issuerNameText!=null) issuerNameText.setText("");
		if(timeissuedText!=null) timeissuedText.setText("");
		if(claimTypeList!=null) claimTypeList.removeAll();
		if(cardName!=null) cardName.setText("");
		if(cardType!=null) cardType.setText("");
		if(image!=null) image.dispose();
		if (cardEditTable!=null) {
			cardEditTable.dispose();
			cardEditTable = null;
		}
		
		image = null;
		isCardDirty = false;
		isOldCard = false;
		comp.layout();
	}

	private Composite visualizeCard(Composite parent) {
		FormData fd = null;
//		ScrolledComposite editableComp = new ScrolledComposite(parent,
//				SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);

		Composite editableComp = new Composite(parent, SWT.BORDER);
		FormLayout formLayout = new FormLayout();
		formLayout.marginBottom = 10;
		formLayout.marginTop = 10;
		formLayout.marginLeft = 10;
		formLayout.marginRight = 10;
		editableComp.setLayout(formLayout);

//		Label label_ = new Label(editableComp, SWT.NONE);
//		label_.setText("Personalize this card");
//		Font font = new Font(Display.getCurrent(),"Ariel", 8, SWT.BOLD);
//		label_.setFont(font);
//		fd = new FormData();
//		fd.top = new FormAttachment(0, 0);
//		fd.left = new FormAttachment(0, 5);
//		label_.setLayoutData(fd);
//
//		// Separator
//		Label label = new Label(editableComp, SWT.SEPARATOR | SWT.HORIZONTAL);
//		fd = new FormData();
//		fd.top = new FormAttachment(label_, 5);
//		fd.left = new FormAttachment(0,0);
//		fd.width = 600;
//		label.setLayoutData(fd);
//
		imageComp = new Composite(editableComp, SWT.BORDER);
//		updateImage(personalCardImage, personalCard == null ? "default"
//			: "defined in card");
		fd = new FormData();
		fd.top = new FormAttachment(editableComp, 10);
		fd.left = new FormAttachment(0, 5);
		fd.width = imageSize.x;
		fd.height = imageSize.y;
		imageComp.setLayoutData(fd);

		Button imageButton = new Button(editableComp, SWT.NONE);
		imageButton.setText("Choose a picture");
		imageButton.setEnabled(true);
		imageButton.addSelectionListener(new SelectionAdapter() {
		    public void widgetSelected(SelectionEvent e) {
			log.info("choose image");
			chooseImage();
		    }
		});
		fd = new FormData();
		fd.top = new FormAttachment(editableComp, 25);
		fd.left = new FormAttachment(imageComp, 5);
		imageButton.setLayoutData(fd);

		// Separator
		Label sep = new Label(editableComp, SWT.SEPARATOR | SWT.HORIZONTAL);
		fd = new FormData();
		fd.top = new FormAttachment(imageComp, 5);
		fd.left = new FormAttachment(0,0);
		fd.right = new FormAttachment(100, 0);
//		fd.width = 600;
		sep.setLayoutData(fd);

//		// REQUIRED DATA
//		// CardStore location
//		Label labelName = new Label(mainParent, SWT.NONE);
//		fd = new FormData();
//		fd.top = new FormAttachment(sep, 15);
//		fd.left = new FormAttachment(0, 5);
//		labelName.setLayoutData(fd);
//		labelName.setText("Card Name");
//
//		String value = "Name";
//		if (card != null) {
//		    value = card.getName();
//		}
//		name = new Text(mainParent, SWT.BORDER);
//		name.setText(value);
//		fd = new FormData();
//		fd.top = new FormAttachment(sep, 10);
//		fd.left = new FormAttachment(labelName, 15);
//		fd.width = 300;
//		name.setLayoutData(fd);
//
//		// Separator
//		Label sep1 = new Label(mainParent, SWT.SEPARATOR | SWT.HORIZONTAL);
//		fd = new FormData();
//		fd.top = new FormAttachment(labelName, 15);
//		fd.left = new FormAttachment(0,0);
//		fd.width = 600;
//		sep1.setLayoutData(fd);

		cardEditTableAnchor = new Composite(editableComp, SWT.NONE);
		cardEditTableAnchor.setBackground(new Color(Display.getCurrent(), 255, 255, 255));
		fd = new FormData();
		fd.top = new FormAttachment(sep, 10);
		fd.left = new FormAttachment(0, 0);
		fd.right = new FormAttachment(100, 0);
		fd.bottom = new FormAttachment(100, 0);
		//fd.width = 560;
		cardEditTableAnchor.setLayoutData(fd);

		// INTERNAL DATA
//		cardEditTable = new Table(editableComp, SWT.BORDER | SWT.FULL_SELECTION);
//		cardEditTable.setLinesVisible(true);
//		fd = new FormData();
////		fd.top = new FormAttachment(sep1, 10);
//		fd.top = new FormAttachment(sep, 10);
//		fd.left = new FormAttachment(0, 0);
//		fd.right = new FormAttachment(100, 0);
//		fd.bottom = new FormAttachment(100, 0);
//		//fd.width = 560;
//		cardEditTable.setLayoutData(fd);
		
//		String cardNameS = "";
//		if (card != null)
//			cardNameS = card.getName();
//		createTable(cardEditTable);
//		addProperties(cardEditTable, "cardName", cardNameS, null);
//		for (int i = 0; i < claims.length; i++) {
//		    String value = "";
//		    if (this.card != null) {
//			try {
//			    Iterator iter = this.card.getClaims();
//			    while (iter.hasNext()) {
//				ClaimValue claimValue = (ClaimValue) iter.next();
//				if (claims[i][1].equals(claimValue.getType().getType())) {
//				    value = claimValue.getValue();
//				}
//			    }
//			} catch (CardException e) {
//			    log.error("Error when retrieving claims", e);
//			}
//
//		    }
//		    addProperties(cardEditTable, claims[i][0], value, null);
//		}
		return editableComp;
	}
	
	TableEditor createTable(Table table) {
		
		//table.clearAll();
		// REQUIRED DATA TABLES
		TableColumn tc1;

		tc1 = new TableColumn(table, SWT.NONE);
		tc1.setText("Property");
		tc1.setWidth(200);
		tc1 = new TableColumn(table, SWT.NONE);
		tc1.setText("Value");
		tc1.setWidth(330);
		table.setHeaderVisible(true);

		final Table tableP = table;
		final TableEditor editor = new TableEditor(table);
		// The editor must have the same size as the cell and must
		// not be any smaller than 50 pixels.
		editor.horizontalAlignment = SWT.LEFT;
		editor.grabHorizontal = true;
		editor.minimumWidth = 50;
		// editing the second column

		table.addSelectionListener(new SelectionAdapter() {
//			Table table;
//
//			public void SelectionAdapter(Table tableP) {
//				table = tableP;
//			}
			public void widgetSelected(SelectionEvent e) {
				// Clean up any previous editor control
				Control oldEditor = editor.getEditor();
				if (oldEditor != null)
					oldEditor.dispose();

				// Identify the selected row
				final TableItem item = (TableItem) e.item;
				if (item == null)
					return;

				// The control that will be the editor must be a child of the
				// Table
//				Text newEditor = new Text(tableP, SWT.NONE);
//				newEditor.setText(item.getText(EDITABLECOLUMN));
//				newEditor.addModifyListener(new ModifyListener() {
//					public void modifyText(ModifyEvent me) {
//						Text text = (Text) editor.getEditor();
//						editor.getItem()
//						.setText(EDITABLECOLUMN, text.getText());
//					}
//				});
//				newEditor.selectAll();
//				newEditor.setFocus();
//				editor.setEditor(newEditor, item, EDITABLECOLUMN);
				final int index = tableP.indexOf(item);
				final Text text = new Text(tableP, SWT.NONE);
				editor.setEditor(text, item, EDITABLECOLUMN);
				final String originalText = item.getText(EDITABLECOLUMN);
				// transfer text from the selected cell to the Text control
				text.setText(originalText);
				text.selectAll();
				text.setFocus();
				// set the text control into the editor
				editor.setEditor(text, item, EDITABLECOLUMN);
				// add a handler to transfer the text back to the cell any time it's modified
				text.addModifyListener(new ModifyListener() {
					public void modifyText(ModifyEvent me) {
						item.setText(EDITABLECOLUMN, text.getText());
//						if (index >= ELEMENTSPREPENDEDTOTABLE)
							isCardDirty = true;
					}
				});
				// add a handler to transfer the text back to the cell when Enter is pressed
				text.addKeyListener(new KeyAdapter() {
					public void keyPressed(KeyEvent ev) {
						switch(ev.keyCode) {
						case SWT.CR:
							item.setText(EDITABLECOLUMN, text.getText());
							text.dispose();
//							if (index >= ELEMENTSPREPENDEDTOTABLE)
								isCardDirty = true;
							break;
						case SWT.ESC:
							item.setText(EDITABLECOLUMN, originalText);
							text.dispose();
							break;
						}
					}
				});
			}
		});
		return editor;
	}
	
	/**
	 * @param Number
	 * @param value
	 */
	void addProperties(Table table, String name, String value, Color color) {
		String sz[] = { name, value };
		TableItem tableItem;
		tableItem = new TableItem(table, SWT.NONE);
		if (color != null)
			tableItem.setForeground(color);
		tableItem.setText(sz);
//		tableItem.setText(0, name);
//		tableItem.setText(1, value);
	}

//	void addProperties(Table table, String name, Text value, Color color) {
//		//String sz[] = { name, value };
//		TableItem tableItem;
//		tableItem = new TableItem(table, SWT.NONE);
//		if (color != null)
//			tableItem.setForeground(color);
//		//tableItem.setText(sz);
//		tableItem.setText(0, name);
//		tableItem.setText(1, value.getText());
//		// Create the cell editor
//		TableEditor editor = new TableEditor(table);
//		editor.setEditor(value, tableItem, 1);
//	}
	
	private void saveChanges(boolean preexistingCard) {
		//if (preexistingCard) {
		int version = Integer.parseInt(card.getVersion());
		version++;
		if (version == 1) {
			// new card
			isOldCard = false;
		} else {
			isOldCard = true;
			// delete the old card from the cardstore
			try {
				PerspectiveCardStore.getSecureCardProvider().deleteCard(null,
						card);
			} catch (Exception e) {
				log.error(
						"Error when modifying card [" + card.getName() + "]",
						e);
				MessageBox messageBox = new MessageBox(this.getComposite().getShell(), SWT.ERROR_IO);
				messageBox.setMessage("Error when deleting card:"
						+ card.getName() + "\n\n" + e);
				messageBox.setText("Error while modifying a card");
				messageBox.open();
			}
		}
//		}
		
		String iid = null;
		MyCardStorePersonalCard newCard = null;
		
		try {
			newCard = new MyCardStorePersonalCard();
			// look at the "old" card for some stuff
			iid = card.getID();
			newCard.setIId(new URI(iid));
			newCard.setVersion(Integer.toString(version));
			newCard.setName(cardEditTable.getItem(0).getText(EDITABLECOLUMN)); // dependency on location of name
			newCard.setImage(img_rawdata, imageType);
			Date now = new Date();
			if (version == 1) {
				// new card
				newCard.setTimeIssued(now);
				
			    Calendar rightNow = Calendar.getInstance();
			    rightNow.add(Calendar.YEAR, 1000);
			    Date inSomeyear = rightNow.getTime();
			    newCard.setTimeExpires(inSomeyear);
			    
				// supported Token Type list
				ArrayList supportedTokenTypes = new ArrayList();
				supportedTokenTypes.add(URI
					.create("urn:oasis:names:tc:SAML:1.0:assertion"));
				supportedTokenTypes
					.add(URI
						.create("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"));
				newCard.setSupportedTokenTypeList(supportedTokenTypes);				

			} else {
				// "old" card, copy values across
				newCard.setTimeIssued(card.getTimeIssued());
				newCard.setTimeExpires(card.getTimeExpires());
				newCard.setSupportedTokenTypeList(card.getSupportedClaimTypesUris());
			}
			
			newCard.setTimeLastUpdate(now);
			
			// claim types
			ArrayList claimTypes = new ArrayList();
			for (int i = 0; i < claims.length; i++) {
			    String displayTag = claims[i][0];
			    String uri = claims[i][1];
			    String description = claims[i][0];
			    log.info("Set Claims type [" + displayTag + "]");
			    claimTypes.add(new ClaimType(uri, displayTag, description));
			}
			newCard.setClaimsTypeList(claimTypes);

			// claim List
			TableItem[] tableItems = cardEditTable.getItems();
			List claimList = new ArrayList();
			List claimsT = new ArrayList();
			for (int i = ELEMENTSPREPENDEDTOTABLE; i < tableItems.length; i++) {
				String newValue = tableItems[i].getText(EDITABLECOLUMN);
				log.info("Set Claims Value" + tableItems[i].getText(0) + ":"
						+ newValue);
				ISimpleClaimType simpleClaimType = new ClaimType(claims[i-ELEMENTSPREPENDEDTOTABLE][1],
						claims[i-ELEMENTSPREPENDEDTOTABLE][0], claims[i-ELEMENTSPREPENDEDTOTABLE][1]);
				claimsT.add(simpleClaimType);
				ClaimValue claim = null;
				if (!newValue.equals(""))
					claim = new ClaimValue(simpleClaimType, newValue, newCard);
				else
					claim = new ClaimValue(simpleClaimType, (String) null,
							newCard);
				if (claim != null)
					newCard.addClaimValue(claims[i-ELEMENTSPREPENDEDTOTABLE][1], claim);
				// the claimlist isn't looked at...claimList.add(claim);
			}
			
			// the claimlist isn't looked at...newCard.setClaimList(claimList);

			newCard.setName(tableItems[0].getText(EDITABLECOLUMN));
			
			// read the values out of the Table
			
			
			// put the values into the correct locations in the card
			
		    IElement ie = newCard.toElement(RoamingStoreElementFormat.getInstance());
			if (log.isDebugEnabled()) {
//			    DocumentBuilderFactory factory = DocumentBuilderFactory
//				    .newInstance();
//			    DocumentBuilder documentBuilder = factory.newDocumentBuilder();
//			    Document doc = documentBuilder.newDocument();
//			    Element domCard = newCard.toXML(doc);
//			    String xml = XMLHelper.toString(domCard);
//			    log.trace("Created personal card:\n" + xml);
//			    IElement e = newCard.toElement(RoamingStoreElementFormat.getInstance());
			    log.trace("Created personal card:\n" + ie.getAs(String.class));
			}
			
			try {
				PerspectiveCardStore.getSecureCardProvider().addCard(null,
						newCard);
				card = PerspectiveCardStore.getSecureCardProvider().getICardByID(null, iid);
				
			} catch (Exception e) {
				if (!isOldCard) {
					// could not save the new card, but nothing to restore
					log.error(
							"Error when creating new card [" + card.getName() + "]",
							e);
					MessageBox messageBox = new MessageBox(this.getComposite().getShell(), SWT.ERROR_IO);
					messageBox.setMessage("Error when creating new card: "
							+ card.getName() + "\n" + e);
					messageBox.setText("Error while creating a card");
					messageBox.open();
				} else {
					log.error(
							"Error when creating new version of card [" + card.getName() + "], attempting to restore old version",
							e);
					try {
						PerspectiveCardStore.getSecureCardProvider().addCard(null,
								card);
						MessageBox messageBox = new MessageBox(this.getComposite().getShell(), SWT.ERROR_IO);
						messageBox.setMessage("Error when creating new version of card:"
								+ card.getName() + "\nOld version was restored\n" + e);
						messageBox.setText("Error while creating a card");
						messageBox.open();
					} catch (Exception e2) {
						log.error("Could not restore old version of card [" + card.getName() + "], attempting to restore old version",
							e2);
						MessageBox messageBox = new MessageBox(this.getComposite().getShell(), SWT.ERROR_IO);
						messageBox.setMessage("Error when creating new version of card:"
								+ card.getName() + "\nOld version could NOT be restored\n" + e);
						messageBox.setText("Error while creating a card");
						messageBox.open();
					}
				}
			}
		} catch (Exception e) {
			log.error(
					"Error when creating new version of card [" + card.getName() + "]",
					e);
			MessageBox messageBox = new MessageBox(this.getComposite().getShell(), SWT.ERROR_IO);
			messageBox.setMessage("Error when creating new version of card:"
					+ card.getName() + "\n\n" + e);
			messageBox.setText("Error while creating a card");
			messageBox.open();
		}
		
//		this.icev.reset(); // clear junk out
		
		// notify any listeners that the object changed
		CardSelection cs = new CardSelection(CardSelection.TYPE_MODIFIED);
		cs.setCard(card);
		CardListView.getInstance().setSelection(cs); // clear any residual information from the edit window
	}
	
	private void chooseImage() {
		FileDialog fileDialog = new FileDialog(this.comp.getShell(), SWT.OPEN
				| SWT.SINGLE);
		fileDialog.setFilterExtensions(new String[] { "*.bmp", "*.gif",
				"*.jpg", "*.jpeg", "*.png", "*.tif", "*.tiff", "*.*" });
		String ret = fileDialog.open();
		if (ret != null) {
			try {
				InputStream personalCardImageIns = new java.io.FileInputStream(
						ret);
				int length;
				length = personalCardImageIns.available();
				img_rawdata = new byte[length];
				personalCardImageIns.read(img_rawdata);
				updateImage(img_rawdata, ret);
				personalCardImageIns.close();
				//todo need image type
				imageType = "image/jpeg"; // guessing
			} catch (IOException e) {
				MessageBox messageBox = new MessageBox(this.comp.getShell(),
						SWT.ERROR_IO);
				messageBox.setMessage("Error when reading file:" + ret);
				messageBox.setText("Error while reading image");
				messageBox.open();
				return;
			} catch (SWTException e) {
				MessageBox messageBox = new MessageBox(this.comp.getShell(),
						SWT.ERROR_IO);
				messageBox.setMessage("Image format not supported for:" + ret);
				messageBox.setText("Error while reading image");
				messageBox.open();
				return;
			}
//			imageFilename = ret;
		}
	}

	protected void updateImage(byte data[], String toolTipText)
	throws SWTException {
		ByteArrayInputStream bis = new ByteArrayInputStream(data);
		Image image = new Image(Display.getCurrent(), bis);
		ImageData imd = image.getImageData().scaledTo(imageSize.x, imageSize.y);
		Image newimg = new Image(Display.getCurrent(), imd);
		imageComp.setBackgroundImage(newimg);
		imageComp.setToolTipText(toolTipText);
		imageComp.redraw();
		image.dispose();
	}
	
	class MyCardStorePersonalCard extends CardStorePersonalCard {
		MyCardStorePersonalCard() throws IOException, Exception {
			super();
			dirtyClaimValueMap_ = new HashMap();
			hashSalt_ = SecureRandom.getSeed(32);
			this.masterKey_ = SecureRandom.getSeed(32);
		}
		
		/**
		 * Add this to the dirty claims list
		 * @param uri the URI of the claim
		 * @param cv the ClaimValue
		 */
		void addClaimValue(String uri, ClaimValue cv) {
			dirtyClaimValueMap_.put(uri, cv);
		}
	}

}
