/*******************************************************************************
 * Copyright (c) 20062007 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Anthony Bussani (IBM Research) - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.crpps.ui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

    /**
     * (C) Copyright International Business Machines Corporation, 2002
     * <p>
     * This Dialog is responsible for the management of the window that manages
     * node names, when adding/renaming File, Folder or Rule.
     */
    public class OpeningSecureStorageDialog extends Dialog {
	Object result = null;

	Text nodeText;

	Text error;

	boolean ok = false;

	Shell shell;

	/**
	 * @see org.eclipse.swt.widgets.Dialog#Dialog(Shell, int)
	 */
	public OpeningSecureStorageDialog(Shell parent, int style) {
	    super(parent, style);
	}

	/**
	 * Method open. Open this Dialog Window.
	 * 
	 * @param oldText
	 *                the old Node in case of renaming
	 * @param source
	 *                typically the RuleTree form the main window
	 * @param ruleGroupParent
	 *                the parent of the current selected node
	 * @param currentMouseX
	 *                the current mouse X coordinate
	 * @param currentMouseY
	 *                the current mouse Y coordinate
	 * @return Object the edited text as String
	 */
	public Object open(String title, String field, Composite source) {

	    Shell parent = getParent();
	    shell = new Shell(parent, SWT.APPLICATION_MODAL);
	    shell.setText("Password");

	    GridLayout gridLayoutShell = new GridLayout();
	    gridLayoutShell.numColumns = 2;
	    gridLayoutShell.makeColumnsEqualWidth = false;
	    gridLayoutShell.marginBottom = 3;
	    gridLayoutShell.marginTop = 3;
	    gridLayoutShell.marginLeft = 5;
	    gridLayoutShell.marginRight = 5;
	    shell.setLayout(gridLayoutShell);

	    // TITLE
	    if (title != null) {
		Label label = new Label(shell, SWT.SHADOW_IN);
		label.setText(title);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.horizontalSpan = 2;
		label.setLayoutData(gridData);
	    }
	    // LINE 1
	    Label label = new Label(shell, SWT.NONE);
	    label.setText(field);
	    GridData gridData = new GridData();
	    gridData.horizontalAlignment = GridData.FILL;
	    gridData.horizontalSpan = 2;
	    label.setLayoutData(gridData);
	    // LINE 2
	    nodeText = new Text(shell, SWT.BORDER);
	    nodeText.setEchoChar('*');
	    int columns = 20;
	    GC gc = new GC(nodeText);
	    FontMetrics fm = gc.getFontMetrics();
	    int width = columns * fm.getAverageCharWidth();
	    int height = fm.getHeight();
	    gc.dispose();
	    nodeText.setSize(nodeText.computeSize(width, height));
	    gridData = new GridData();
	    gridData.horizontalAlignment = GridData.FILL;
	    gridData.grabExcessHorizontalSpace = true;
	    gridData.horizontalSpan = 2;
	    nodeText.setLayoutData(gridData);

	    /*
	     * // LINE 3 Button ok_button = new Button(shell, SWT.PUSH);
	     * ok_button.setImage(CardManager.ACCEPT); gridData = new
	     * GridData(); gridData.horizontalAlignment = GridData.FILL;
	     * ok_button.setLayoutData(gridData);
	     * ok_button.addSelectionListener(new SelectionAdapter() { public
	     * void widgetSelected(SelectionEvent e) { if (ok) { result =
	     * password.getText(); shell.dispose(); } } });
	     * 
	     * Button cancel_button = new Button(shell, SWT.PUSH);
	     * cancel_button.setImage(CardManager.CLOSE); gridData = new
	     * GridData(); gridData.horizontalAlignment = GridData.END;
	     * cancel_button.setLayoutData(gridData);
	     * cancel_button.addSelectionListener(new SelectionAdapter() {
	     * public void widgetSelected(SelectionEvent e) { shell.dispose(); }
	     * });
	     */

	    /*
	     * error = new Text(shell, SWT.READ_ONLY); gridData = new
	     * GridData(GridData.FILL_HORIZONTAL); gridData.horizontalSpan = 6;
	     * error.setLayoutData(gridData); Color red = new
	     * Color(parent.getDisplay(), 255, 0, 0); error.setForeground(red);
	     * error.setBackground(shell.getBackground());
	     */
	    nodeText.addVerifyListener(new VerifyListener() {
		public void verifyText(VerifyEvent e) {
		    if (Character.getNumericValue(e.character) > 0) {
			e.doit = validCharacter(e.character);
		    } else {
			char[] chars = e.text.toCharArray();
			if (chars.length > 0) {
			    for (int i = 0; i < chars.length; i++) {
				if (!validCharacter(chars[i]))
				    e.doit = false;
			    }
			}
		    }
		}
	    });
	    nodeText.addKeyListener(new KeyAdapter() {
		public void keyReleased(KeyEvent e) {
		    if (e.character == 0xd) {
			if (ok) {
			    result = nodeText.getText();
			    shell.dispose();
			    return;
			}
		    }
		    super.keyReleased(e);
		    verify();
		}
	    });
//	    int x = currentMouseX;
//	    int y = currentMouseY;
//	    Composite currentComposite = source;
//	    while (currentComposite != null) {
//		Point point = currentComposite.getLocation();
//		x += point.x;
//		y += point.y;
//		currentComposite = currentComposite.getParent();
//	    }
//	    shell.setLocation(x, y);
	    shell.pack();
	    // shell.setSize(500, 60);
	    shell.open();

	    Display display = parent.getDisplay();
	    while (!shell.isDisposed()) {
		if (!display.readAndDispatch())
		    display.sleep();
	    }
	    return result;
	}

	void verify() {
	    ok = !(nodeText.getText().trim().equals(""));
	}

	/**
	 * Method validCharacter. This method validate each characters pressed.
	 * Each character must be letter or digit or underscore.
	 * 
	 * @param c
	 * @return boolean
	 */
	boolean validCharacter(char c) {
	    return true; // Character.isLetterOrDigit(c) || c == '_' && c <
			    // 128;
	}

}
