/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Tie Li (IBM Corporation) - initial API and implementation
 *    Bruce Rich (IBM Corporation) - allow switching cardstore during login
 *******************************************************************************/ 

package org.eclipse.higgins.crpps.ui;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;

import javax.security.auth.callback.PasswordCallback;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.higgins.crpps.Activator;
import org.eclipse.higgins.crpps.app.Application;
import org.eclipse.higgins.crpps.app.ApplicationWorkbenchWindowAdvisor;
import org.eclipse.higgins.crpps.service.RPPSService2;
import org.eclipse.higgins.crpps.ui.dialogs.LoginDialog;
import org.eclipse.higgins.crpps.ui.dialogs.NewCardStoreDialog;
import org.eclipse.higgins.icard.provider.securestorage.ProviderConfiguration;
import org.eclipse.higgins.icard.provider.securestorage.SecureStorageICardProvider;
import org.eclipse.higgins.icard.provider.securestorage.SecureStorageStrategy;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.registry.IConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.Preferences;

/*
 * CHANGE LOG
 *   tili (2008-Jan-22): Remove the "STS configure" field, and put the configure folder into crpps/configuration.
 *
 */
public class PerspectiveCardStore implements IPerspectiveFactory {

    static SecureStorageICardProvider securecardProvider;

    private Log log = LogFactory.getLog(PerspectiveCardStore.class);
    private boolean canceled = false;
    private IPreferenceStore prefs;
    private static float NOT_SET = 0.0f;

    public void createInitialLayout(IPageLayout layout) {

	// System.setProperty("work.dir",
	// Activator.getDefault().getPreferenceStore().getString("work.dir"));
	// System.setProperty("work.dir", "D:\\Higgins\\icard_store");
	// System.setProperty("org.eclipse.higgins.sts.conf",
	// "D:/Higgins/STS_ConfigurationFiles");
    	
    	prefs = Activator.getDefault().getPreferenceStore();
    	
    	config();

    	if (!canceled) {
    		float leftRatioF = prefs.getFloat(Activator.LEFT_PANE_RATIO);
    		if (NOT_SET == leftRatioF) {
    			leftRatioF = 0.6f;
    			prefs.setValue(Activator.LEFT_PANE_RATIO, leftRatioF);
    		}
    		float rightRatioF = prefs.getFloat(Activator.RIGHT_PANE_RATIO);
    		if (NOT_SET == rightRatioF) {
    			rightRatioF = 0.4f;
    			prefs.setValue(Activator.RIGHT_PANE_RATIO, rightRatioF);
    		}
    		layout.setEditorAreaVisible(false);	
    		layout.addStandaloneView("org.eclipse.higgins.zrpps.cardlistview", 
    				false, IPageLayout.LEFT, leftRatioF, IPageLayout.ID_EDITOR_AREA);
    		layout.addStandaloneView("org.eclipse.higgins.zrpps.cardeditor",
    				false, IPageLayout.RIGHT, rightRatioF, IPageLayout.ID_EDITOR_AREA);
		}
    }

    private void config() {
    	String rememberedFilename = null;
//    	Preferences preferences = null;
//    	String workdir = Activator.getDefault().getPreferenceStore().getString(
//    	"work.dir");
//    	String config = Activator.getDefault().getPreferenceStore().getString(
    	String config = prefs.getString(
    	"org.eclipse.higgins.sts.conf");
    	Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    	// searching for the secure cardstore provider
    	Iterator iter = ICardRegistry.getInstance().getServiceProviders();
    	while (iter.hasNext()) {
    		Object element = iter.next();
    		log.info("element.type=[" + element.getClass() + ":" + element
    				+ "]");
    		if (element instanceof SecureStorageICardProvider) {
    			securecardProvider = (SecureStorageICardProvider) element;
    		}
    	}

//  	if (workdir == null || workdir.equals("")) {
//  	WelcomeDialog wd = new WelcomeDialog(shell);
    	// see if we already know the current info
    	String workdirS = prefs.getString("work.dir");
    	if ("".equals(workdirS)) {
    		workdirS = "@user.home/.higgins/.icard";
    		prefs.setValue("work.dir", workdirS);
    	}
    	String currentIcardFileS = prefs.getString(Activator.MOST_RECENT_CARDSTORE);
    	
    	if (("".equals(currentIcardFileS)) && (null != securecardProvider)) {
    		//fixme gross hack, shouldn't have to do this
    		currentIcardFileS = securecardProvider.getConfiguration().getProperty(ProviderConfiguration.CARDSTORE_FILE);
    	}
		rememberedFilename = currentIcardFileS;
    	boolean needToCreate = !isExtant(currentIcardFileS);
    	boolean setAsDefaultStore = false;
    	boolean loggedIn = false;
    	login: while (!loggedIn) {
    		String pwd = "";
    		while ("".equals(pwd)) {
    			if (needToCreate) {
    				// put up dialog to create a new store
    				NewCardStoreDialog dlog = new NewCardStoreDialog(shell, currentIcardFileS); //, true);
    				dlog.setBlockOnOpen(true);
    				dlog.open();
    				setAsDefaultStore = true;
    				pwd = dlog.getPasswd();
    				currentIcardFileS = dlog.getFilename();
    				if (dlog.getReturnCode() == Dialog.CANCEL) {
    					warnThenSleepThenClose(shell);
    					canceled = true;
    					break login;
    				}
    				needToCreate = !isExtant(currentIcardFileS);
    			} else {
    				LoginDialog ld = new LoginDialog(shell, currentIcardFileS);
    				ld.setBlockOnOpen(true);
    				ld.open();
    				boolean needDifferent = ld.pickADifferentStore();
    				if (needDifferent) {
    					NewCardStoreDialog dlog = new NewCardStoreDialog(shell, currentIcardFileS);//, false);
    					dlog.setBlockOnOpen(true);
    					dlog.open();
    					pwd = dlog.getPasswd();
    					needToCreate = !isExtant(dlog.getFilename());
    					currentIcardFileS = dlog.getFilename();
    					pwd = dlog.getPasswd();
    					continue;
    				} else {
    					setAsDefaultStore = ld.isDefaultStore();
    					pwd = ld.getPasswd();
    					if (ld.getReturnCode() == Dialog.CANCEL) {
    						warnThenSleepThenClose(shell);
    						canceled = true;
    						break login;
    					}
    				}
    			}
    			if ("".equals(pwd)) {
    				log.info("User did not supply password");
    				MessageBox messageBox = new MessageBox(shell, SWT.ERROR_IO);
    				messageBox.setText("Password required");
    				messageBox.setMessage("Please re-try and supply a password for the i-card store");
    				messageBox.open();
    			}
    		}
    		// now have a password and a cardstore name

    		try {
    			config = getDefaultConfigFolder();
    			prefs.setValue("org.eclipse.higgins.sts.conf", config);
    		} catch (IOException e2) {
    			log.error("Error when searching the STS configuration", e2);
    			MessageBox messageBox = new MessageBox(shell, SWT.ERROR_IO);
    			messageBox.setMessage("Error when searching STS configuration: \n" + e2);
    			messageBox.setText("Error while reading cardstore");
    			messageBox.open();
    		}

//  		}
    		try {
    			// see if there's already a cardstore open
    			SecureStorageStrategy secureStorageStrategy = (SecureStorageStrategy)securecardProvider.getStrategy();
    			IConfiguration conf = securecardProvider.getConfiguration();
    			// for there to be a cardstore already open, the ini files must have held both a cardstore filename and a password
    			if (secureStorageStrategy != null) {
    				// make sure the filename and pw match what the user provided
    				if ((pwd.equals(conf.getProperty(SecureStorageICardProvider.PASSWORD))) 
    						&& (currentIcardFileS.equals(conf.getProperty(SecureStorageICardProvider.FILENAME)))) {
    					// ok we can reuse the currently-open strategy and nothing changes
    				} else {
    					// can't use what's already open
    					secureStorageStrategy = null; // don't seem to have any way to dispose/close
    				}
    			}
    			if (secureStorageStrategy == null) {
    				// we now have no backing store for cards, so set one up
    				PasswordCallback passwordCallback = new PasswordCallback(
    						"---", false);
    				passwordCallback.setPassword(pwd.toCharArray());
    				secureStorageStrategy = new SecureStorageStrategy();
    				secureStorageStrategy.setPasswordCallback(passwordCallback);
//  				((ProviderConfiguration) securecardProvider
//  				.getConfiguration()).setPassword(wd.getPasswd());
    				secureStorageStrategy.initialize(null, securecardProvider, currentIcardFileS,
    						passwordCallback, null);
    				if (!isExtant(currentIcardFileS)) {
    					secureStorageStrategy.newStorage();
    				}
    				// change the configuration info for the card provider
    				((ProviderConfiguration)conf).setPassword(pwd);
    				((ProviderConfiguration)conf).setCardStoreFile(currentIcardFileS);
    				reInitCurrentSecureCardProvider(secureStorageStrategy);
    			}
    			// have to make up for the fact that the data passing scheme is a bit lame between PerspectiveCardStore and CardListView
    			// CardListView expects to find the securecardProvider reference in the ICardRegistry
    			// but that list was already initialized with the default cardstore location
    			// and there's no way to change it
    			// BreadCrumb.getInstance().add(securecardProvider);
    			// force the cardstore to be decrypted now, so we can retry if pw was no good
    			securecardProvider.getICards(null);
    			loggedIn = true;
    			ApplicationWorkbenchWindowAdvisor.getInstance().setTitle(
    					"[" + currentIcardFileS + "]");
    			// ok, we were able to decrypt the store, so remember this for next time
//  			if (setAsDefaultStore) {
//  			prefs.setDefault(Activator.MOST_RECENT_CARDSTORE, currentIcardFileS);
//  			} else {
//  			prefs.setValue(Activator.MOST_RECENT_CARDSTORE, currentIcardFileS);
//  			}
    			prefs.setValue(Activator.MOST_RECENT_CARDSTORE, currentIcardFileS);
    			break; // now have a successful login
//  			prefs.setDefault(Activator.MOST_RECENT_CARDSTORE, currentIcardFileS);
    		} catch (Exception e1) {
    			log.error("Error when reading the cardstore", e1);
    			MessageBox messageBox = new MessageBox(shell, SWT.ERROR_IO);
    			messageBox.setMessage("Error when reading the cardstore: \n" + e1);
    			messageBox.setText("Error while reading cardstore");
    			messageBox.open();
    		}
    	}

    	Job job = new Job("Waiting for HBX requests.") {
    		protected IStatus run(IProgressMonitor monitor) {
    			//monitor.setCanceled(true);
    			RPPSService2 ps = new RPPSService2();		
    			try {
    				ps.listenOnPort();
    			} catch (Exception e) {
    				e.printStackTrace();
    			}
    			return Status.OK_STATUS;
    		}
    	};

    	job.setSystem(true);
    	job.schedule();
    }

    private String getDefaultConfigFolder() throws IOException {
		Bundle bundle = Platform.getBundle("org.eclipse.higgins.crpps");
		URL configURL = FileLocator.find(bundle, new Path("/configuration"), null);
    	if(configURL!=null){
			URL fileUrl = FileLocator.resolve(configURL);
			String configAbsolutePath = fileUrl.getPath();
			return configAbsolutePath;
    	}
		
		return "";
	}
    
    private void warnThenSleepThenClose(Shell shell) {
    	canceled = true;
		MessageBox messageBox = new MessageBox(shell, SWT.ERROR_IO);
		messageBox.setText("Password required");
		messageBox.setMessage("Application terminated because password prompt was canceled");
		messageBox.open();		
		try {
			Thread.sleep(5000); // wait 5 seconds after msgbox acknowledged
		} catch (Exception e) {
		}
		try {
//			org.eclipse.ui.IWorkbenchWindow iww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
//			ActionFactory.QUIT.create(iww).run();
			PlatformUI.getWorkbench().close();
		} catch (Exception e) {
		}		
    }
    
    private boolean isExtant(String filename) {
    	boolean ans = false;
    	if ((filename != null) && (!"".equals(filename))) {
			File icardFile = new File(filename);
			if ((icardFile.exists()) && (icardFile.isFile()))
				ans = true;
    	}
		return ans;
    }
    
	public static SecureStorageICardProvider getSecureCardProvider() {
		return securecardProvider;
    }
	
	/**
	 * Provide a package-private mechanism to reset the currently-open cardstore
	 * @param sss the strategy to be used for current card source. This strategy
	 * must be initialized with a PasswordCallback.
	 */
	static void reInitCurrentSecureCardProvider(SecureStorageStrategy sss) {
		// may need a mechanism to signal change of provider
		securecardProvider.clear(null); // forget about all the current icards
		securecardProvider.setStrategy(sss);
	}

}
