/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Tie Li (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.crpps.ui;

import org.eclipse.higgins.crpps.Activator;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RPPSPreferencePage extends PreferencePage implements
		IWorkbenchPreferencePage {

	Text sts_conf;
	Text conf_conf;
	
	public RPPSPreferencePage() {
		super();
	}

	public RPPSPreferencePage(String arg0) {
		super(arg0);
	}

	public RPPSPreferencePage(String arg0, ImageDescriptor arg1) {
		super(arg0, arg1);
	}

	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new FormLayout());
		
		Label lab1 = new Label(composite, SWT.NONE);
		lab1.setText("STS Configure path: ");
		FormData fd = new FormData();
		fd.top = new FormAttachment(0, 5);
		fd.left = new FormAttachment(0, 5);
		lab1.setLayoutData(fd);
		
		sts_conf = new Text(composite, SWT.BORDER);
		fd = new FormData();
		fd.top = new FormAttachment(0, 5);
		fd.left = new FormAttachment(lab1, 5);
		fd.right = new FormAttachment(90, 0);
		sts_conf.setLayoutData(fd);
		
		Label lab2 = new Label(composite, SWT.NONE);
		lab2.setText("Card store path: ");
		fd = new FormData();
		fd.top = new FormAttachment(sts_conf, 10);
		fd.left = new FormAttachment(0, 5);
		lab2.setLayoutData(fd);
		
		conf_conf = new Text(composite, SWT.BORDER);
		fd = new FormData();
		fd.top = new FormAttachment(sts_conf, 10);
		fd.left = new FormAttachment(lab2, 5);
		fd.right = new FormAttachment(90, 0);
		conf_conf.setLayoutData(fd);
		
		String work_dir = Activator.getDefault().getPreferenceStore().getString("work.dir");
		conf_conf.setText(work_dir);
		
		String sts_dir = Activator.getDefault().getPreferenceStore().getString("org.eclipse.higgins.sts.conf");
		sts_conf.setText(sts_dir);
		
		return composite;
	}
	
	

	public void init(IWorkbench arg0) {
		
	}

	protected void performApply() {
		Activator.getDefault().getPreferenceStore().setValue("work.dir", conf_conf.getText());
		Activator.getDefault().getPreferenceStore().setValue("org.eclipse.higgins.sts.conf", sts_conf.getText());
		
		super.performApply();
	}

	public boolean performOk() {
		Activator.getDefault().getPreferenceStore().setValue("work.dir", conf_conf.getText());
		Activator.getDefault().getPreferenceStore().setValue("org.eclipse.higgins.sts.conf", sts_conf.getText());
		Activator.getDefault().getPreferenceStore().needsSaving();
		return super.performOk();
	}

	protected void performDefaults() {
		super.performDefaults();
		
		Activator.getDefault().getPreferenceStore().setValue("work.dir", "Currently not used.");
		conf_conf.setText("D:/Higgins/icard_store");
		Activator.getDefault().getPreferenceStore().setValue("org.eclipse.higgins.sts.conf", "D:/Higgins/STS_ConfigurationFiles");
		sts_conf.setText("D:/Higgins/STS_ConfigurationFiles");
	}

}
