/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tie Li  - Initial API and implementation
 *     Anthony bussani 
 *******************************************************************************/

package org.eclipse.higgins.crpps.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * @author litie at cn dot ibm dot com
 *
 */
public class ChangePasswordDialog extends Dialog {

    Text oldPasswd = null;

    Text newPasswd = null;

    Text confirmPasswd = null;

    String filename;

    private String passwdSz = null;

    private Shell shell;

    private String oldPasswdSz;

    public ChangePasswordDialog(Shell parentShell, String filename) {
	super(parentShell);
	this.filename = filename;
	this.shell = parentShell;
    }

    protected void setShellStyle(int newShellStyle) {
	// super.setShellStyle(newShellStyle);
	super.setShellStyle(SWT.APPLICATION_MODAL | SWT.CLOSE | SWT.TITLE);
    }

    protected Control createDialogArea(Composite arg0) {
	Composite parent_ = (Composite) super.createDialogArea(arg0);
	Composite parent = new Composite(parent_, SWT.BORDER);
//	GridLayout gridLayout = new GridLayout(1, true);
//	gridLayout.horizontalSpacing = 5;
//	gridLayout.verticalSpacing = 10;
//	parent.setLayout(gridLayout);
	FormLayout formLayout = new FormLayout();
	formLayout.marginBottom = 10;
	formLayout.marginTop = 10;
	formLayout.marginLeft = 10;
	formLayout.marginRight = 10;
	parent.setLayout(formLayout);

	Label label_1 = new Label(parent, SWT.NONE);
	Font font = new Font(Display.getCurrent(),"Ariel", 8, SWT.BOLD);
	label_1.setFont(font);
	label_1.setText("Please input old and new cardstore password");
	FormData fd = new FormData();
	fd.top = new FormAttachment(0, 0);
	fd.left = new FormAttachment(0, 5);
	label_1.setLayoutData(fd);

	// Separator
	Label label_ = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
	fd = new FormData();
	fd.top = new FormAttachment(label_1, 5);
	fd.left = new FormAttachment(0, 0);
	fd.width = 300;
	label_.setLayoutData(fd);

	Label label = new Label(parent, SWT.NONE);
	label.setText("Old password: ");
	fd = new FormData();
	fd.top = new FormAttachment(label_, 10);
	fd.left = new FormAttachment(0, 5);
	fd.width = 120;
	label.setLayoutData(fd);

	oldPasswd = new Text(parent, SWT.BORDER | SWT.PASSWORD);
	fd = new FormData();
	fd.top = new FormAttachment(label_, 5);
	fd.left = new FormAttachment(label, 5);
	fd.right = new FormAttachment(100, -10);
	oldPasswd.setLayoutData(fd);

	Label label2 = new Label(parent, SWT.NONE);
	label2.setText("New password: ");
	fd = new FormData();
	fd.top = new FormAttachment(oldPasswd, 20);
	fd.left = new FormAttachment(0, 5);
	fd.width = 120;
	label2.setLayoutData(fd);

	newPasswd = new Text(parent, SWT.BORDER | SWT.PASSWORD);
	fd = new FormData();
	fd.top = new FormAttachment(oldPasswd, 15);
	fd.left = new FormAttachment(label, 5);
	fd.right = new FormAttachment(100, -10);
	newPasswd.setLayoutData(fd);

	Label label3 = new Label(parent, SWT.NONE);
	label3.setText("Confirm password: ");
	fd = new FormData();
	fd.top = new FormAttachment(newPasswd, 10);
	fd.left = new FormAttachment(0, 5);
	fd.width = 120;
	label3.setLayoutData(fd);

	confirmPasswd = new Text(parent, SWT.BORDER | SWT.PASSWORD);
	fd = new FormData();
	fd.top = new FormAttachment(newPasswd, 5);
	fd.left = new FormAttachment(label3, 5);
	fd.right = new FormAttachment(100, -10);
	confirmPasswd.setLayoutData(fd);

	return super.createDialogArea(arg0);
    }

    protected void okPressed() {
	String newPassword = this.newPasswd.getText();
	String confirmPassword = this.confirmPasswd.getText();
	if (!newPassword.equals(confirmPassword)) {
	    MessageBox messageBox = new MessageBox(shell, SWT.ERROR_UNSPECIFIED);
	    messageBox.setMessage("Password mismatch");
	    messageBox.setText("Password not correct");
	    messageBox.open();
	    return;
	}
	this.passwdSz = newPasswd.getText();
	this.oldPasswdSz = oldPasswd.getText();
	super.okPressed();
    }

    protected void configureShell(Shell arg0) {
	super.configureShell(arg0);
	arg0.setText("Password Dialog");
    }

    public String getOldPassword() {
	return this.oldPasswdSz;
    }

    public String getNewPassword() {
	return this.passwdSz;
    }

}
