package org.eclipse.higgins.crpps.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/**
 * Provide a warning dialog when it looks like edit changes are going to be lost.
 * Returns IDialogConstants.OK_ID if the user confirms throwing away changes.
 * @author brich at-sign us dot ibm dot com
 *
 */
public class ConfirmAbandonEdit extends Dialog {
	
//    private Log log = LogFactory.getLog(ConfirmAbandonEdit.class);

	/**
	 * Provide a warning dialog when it looks like edit changes are going to be lost.
	 * Returns IDialogConstants.OK_ID if the user confirms throwing away changes.
	 *
	 */
	public ConfirmAbandonEdit(Shell parentShell) {
		super(parentShell);
	}
	
    protected void setShellStyle(int newShellStyle) {
    	super.setShellStyle(SWT.APPLICATION_MODAL|SWT.BORDER|SWT.RESIZE|SWT.CLOSE|SWT.TITLE);
    }

    protected Control createDialogArea(Composite arg0) {
    	Composite parent = (Composite) super.createDialogArea(arg0);
    	String warning1 = "You are leaving the i-card editor without having saved your changes.";
    	String warning2 = "Are you sure you want to discard your changes?";
    	String warning3 = "";
    	String prompt = "If you choose [Discard changes], all input to the editor will be lost.";
    	Label warnText = new Label(parent, SWT.NONE);
    	warnText.setText(warning1);
    	Label warnText2 = new Label(parent, SWT.NONE);
    	warnText2.setText(warning2);
    	Label warnText3 = new Label(parent, SWT.NONE);
    	warnText3.setText(warning3);
    	Label promptText = new Label(parent, SWT.NONE);
    	promptText.setText(prompt);
    	return parent;
    }
    
    protected void configureShell(Shell arg0) {
    	super.configureShell(arg0);
    	arg0.setText("Leaving the card editor");
    }
    
    protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, "Discard changes",
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				"Keep editing", true);
    }
    


}
