/*******************************************************************************
 * Copyright (c) 20062007 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Anthony Bussani (IBM Research) - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.crpps.ui.dialogs;

import java.io.File;
import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DirSurveyDialog extends Dialog {

    private static Log log = LogFactory.getLog(DirSurveyDialog.class);
    
    Text passwdText = null;

    String filename;
    String dir;
    
    private String passwd = null;

    private Shell shell;
    private File[] files;
    
    public DirSurveyDialog(Shell parentShell, File[] files, String dir) {
	super(parentShell);
	this.shell = parentShell;
	this.files = files;
	this.dir = dir;
    }
    
    protected void setShellStyle(int newShellStyle) {
	super.setShellStyle(SWT.APPLICATION_MODAL | SWT.CLOSE | SWT.TITLE);
    }

    protected Control createDialogArea(Composite arg0) {
	Composite parent_ = (Composite) super.createDialogArea(arg0);
	Composite parent = new Composite(parent_, SWT.BORDER);
	FormLayout formLayout = new FormLayout();
	formLayout.marginBottom = 0;
	formLayout.marginTop = 10;
	formLayout.marginLeft = 10;
	formLayout.marginRight  =10;
	parent.setLayout(new FormLayout());

	Label label_2 = new Label(parent, SWT.NONE);
	Font font = new Font(Display.getCurrent(),"Ariel", 8, SWT.BOLD);
	label_2.setFont(font);
	label_2.setText("New cardstore(s) detected, select a new one to open ");
	FormData fd = new FormData();
	fd.top = new FormAttachment(0, 5);
	fd.left = new FormAttachment(0, 5);
	label_2.setLayoutData(fd);

	Label label_1 = new Label(parent, SWT.NONE);
	font = new Font(Display.getCurrent(),"Ariel", 8, SWT.NONE);
	label_1.setFont(font);
	label_1.setText("Directory: "+dir);
	fd = new FormData();
	fd.top = new FormAttachment(label_2, 5);
	fd.left = new FormAttachment(0, 5);
	label_1.setLayoutData(fd);

	// Separator
	Label label_ = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
	fd = new FormData();
	fd.top = new FormAttachment(label_1, 5);
	fd.left = new FormAttachment(0, 0);
	fd.width = 500;
	label_.setLayoutData(fd);

	Label label = new Label(parent, SWT.NONE);
	label.setText("Detected cardstore(s): ");
	fd = new FormData();
	fd.top = new FormAttachment(label_, 15);
	fd.left = new FormAttachment(0, 5);
	fd.width = 120;
	label.setLayoutData(fd);

	// Combo with old Watched Dirs
	Combo filenameCombo = new Combo(parent, SWT.READ_ONLY);
	fd = new FormData();
	fd.top = new FormAttachment(label_, 10);
	fd.left = new FormAttachment(label, 5);
	fd.height = 10;
	fd.width = 300;
	filenameCombo.setLayoutData(fd);
	ArrayList filenames = new ArrayList();
	for(int i=0; i<files.length; i++) {
	    log.trace("filename=["+files[i]+"]");
	    filenames.add(files[i].getAbsolutePath());
	}
	filenameCombo.setItems((String[]) filenames.toArray(new String[0]));
	filenameCombo.setText((String)filenames.get(0));
	filenameCombo.addModifyListener(new ModifyListener() {
		public void modifyText(ModifyEvent e) {
			filename = ((Combo)e.getSource()).getText();
		}
	});

	Label label2 = new Label(parent, SWT.NONE);
	label2.setText("Password: ");
	fd = new FormData();
	fd.top = new FormAttachment(filenameCombo, 30);
	fd.left = new FormAttachment(0, 5);
	label2.setLayoutData(fd);

	passwdText = new Text(parent, SWT.BORDER | SWT.PASSWORD);
	fd = new FormData();
	fd.top = new FormAttachment(filenameCombo, 25);
	fd.left = new FormAttachment(label, 5);
	fd.width = 150;
	passwdText.setLayoutData(fd);
	return super.createDialogArea(arg0);
    }

    protected void okPressed() {
	this.passwd = this.passwdText.getText();
	super.okPressed();
    }

    protected void configureShell(Shell arg0) {
	super.configureShell(arg0);
	arg0.setText("Password Dialog");
    }

    public String getPassword() {
	return this.passwd;
    }

    public String getFilename() {
	return this.filename;
    }
}
