/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Anthony Bussani (IBM Research) - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.crpps.ui.dialogs;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;

import org.eclipse.higgins.crpps.ui.CardListView;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.iss.ICardSelectorService;
import org.eclipse.higgins.iss.IICardSelectorFactory;
import org.eclipse.higgins.registry.IConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

/**
 * @author bus at zurich dot ibm dot com
 *
 */
public class HigginsProvidersDialog extends Dialog {

	private static final String ABOUT_FILE = "about.txt";

	static String lf = System.getProperty("line.separator");

	private Color darkBlue;

	private Color white;

	private String input;

	Shell parentShell;

	Display display;

	private Image image;

	/**
	 * InputDialog constructor
	 * 
	 * @param parent
	 *            the parent
	 */
	public HigginsProvidersDialog(Shell parent) {
		// Pass the default styles here
		// this(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		this(parent, SWT.APPLICATION_MODAL | SWT.RESIZE  | SWT.CLOSE | SWT.TITLE);
	}

	/**
	 * InputDialog constructor
	 * 
	 * @param parent
	 *            the parent
	 * @param style
	 *            the style
	 */
	public HigginsProvidersDialog(Shell parent, int style) {
		// Let users override the default styles
		super(parent, style);
		this.parentShell = parent;
		this.display = parent.getDisplay();
		darkBlue = display.getSystemColor(SWT.COLOR_DARK_BLUE);
		white = display.getSystemColor(SWT.COLOR_WHITE);
		setText("Embedded Identity Selector / Higgins Providers Infos");
	}

	/**
	 * Gets the input
	 * 
	 * @return String
	 */
	public String getInput() {
		return input;
	}

	/**
	 * Sets the input
	 * 
	 * @param input
	 *            the new input
	 */
	public void setInput(String input) {
		this.input = input;
	}

	/**
	 * Opens the dialog and returns the input
	 * 
	 * @return String
	 */
	public String open() {
		// Create the dialog window
	    	//Shell shell = ApplicationWorkbenchWindowAdvisor.getShell();
		parentShell = new Shell(parentShell, getStyle());
		parentShell.setText(getText());
		parentShell.setBackground(darkBlue);
		//BUS createContents(cardManager);
		createContents();
		parentShell.setSize(200, 200);
		parentShell.pack();
		parentShell.open();
		Display display = getParent().getDisplay();
		while (!parentShell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		// Return the entered value, or null
		return input;
	}

	/**
	 * @param Number
	 * @param value
	 */
	void addProperties(Table table, String name, String value, Color color) {
		String sz[] = { name, value };
		TableItem tableItem;
		tableItem = new TableItem(table, SWT.NONE);
		if (color != null)
			tableItem.setForeground(color);
		tableItem.setText(sz);
	}

	/**
	 * Creates the dialog's contents
	 * 
	 * @param shell
	 *            the dialog window
	 */
	private void createContents() {
		FillLayout fillLayout = new FillLayout();

		fillLayout.type = SWT.VERTICAL;

		// shell.setLayout(fillLayout);
		parentShell.setLayout(new GridLayout(1, false));
		// Icon & Product name
		createIconDescription(parentShell);
		updateProperties(parentShell);

		// Create the OK button and add a handler
		// so that pressing it will set input
		// to the entered value
		Composite composite = new Composite(parentShell, SWT.NONE);
		composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL
				| GridData.FILL_VERTICAL));
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		gridLayout.makeColumnsEqualWidth = false;
		composite.setLayout(gridLayout);
		Button ok = new Button(parentShell, SWT.PUSH | SWT.CENTER);
		ok.setText("    OK    ");
		GridData gridData = new GridData(GridData.HORIZONTAL_ALIGN_END);
		gridData.horizontalSpan = 3;
		ok.setLayoutData(gridData);
		ok.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				parentShell.close();
			}
		});

		// Set the OK button as the default, so user can type input and press
		// Enter
		// to dismiss
		parentShell.setDefaultButton(ok);
	}

	private void createIconDescription(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setBackground(darkBlue);
		composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL
				| GridData.FILL_VERTICAL));
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		composite.setLayout(gridLayout);
		image = CardListView.MAUS;
		Canvas imageCanvas = new Canvas(composite, SWT.NONE);
		imageCanvas.setLayoutData(new GridData(GridData.CENTER));
		imageCanvas.setBackground(darkBlue);
		imageCanvas.addPaintListener(new PaintListener() {
			public void paintControl(PaintEvent e) {
				e.gc.setBackground(darkBlue);
				e.gc.drawImage((Image) image, 0, 0);
			}
		});
		int height = image.getImageData().height;
		int width = image.getImageData().width;
		GridData gridData = new GridData(GridData.FILL_BOTH);
		gridData.widthHint = width;
		gridData.heightHint = height;
		gridData.verticalSpan = 4;
		imageCanvas.setLayoutData(gridData);
		// Product Infos
		int style = SWT.MULTI | SWT.WRAP | SWT.READ_ONLY;
		Text text = new Text(composite, style);
		text.setBackground(darkBlue);
		text.setForeground(white);
		gridData = new GridData(GridData.FILL_BOTH);
		gridData.heightHint = height;
		gridData.horizontalAlignment = SWT.CENTER;
		gridData.horizontalIndent = 0;
		gridData.widthHint = 550;
		text.setLayoutData(gridData);
		text.setEditable(false);
		StringBuffer sb = new StringBuffer();
		InputStream inputStream = this.getClass().getResourceAsStream(
				ABOUT_FILE);
		if (inputStream != null) {
			BufferedReader br = new BufferedReader(new InputStreamReader(
					inputStream));
			String line = null;
			try {
				while ((line = br.readLine()) != null) {
					System.out.println("line[" + line + "]");
					sb.append(line + lf);
				}
				br.close();
			} catch (Exception e) {
				sb.append("Exception when reading about text file:\n\n" + e);
			}
		} else {
			sb.append("Coudl not find the " + ABOUT_FILE + " file");
		}
		text.setText(sb.toString());
		// composite.setSize(width, height);
	}

	private void updateProperties(Composite parent) {
		int i;
		Iterator iter;
		Label label;
		Table propertiesTable;
		TableColumn tc1;
		// CardManager Properties
		label = new Label(parent, SWT.BOLD);
		label.setText("Embedded Identity Selector / Higgins Providers Infos");
		label.setBackground(darkBlue);
		label.setForeground(white);
		propertiesTable = new Table(parent, SWT.BORDER
				| SWT.FULL_SELECTION);
		propertiesTable.setLinesVisible(true);

		propertiesTable.setLayoutData(new GridData(GridData.FILL_HORIZONTAL
				| GridData.FILL_VERTICAL));

		tc1 = new TableColumn(propertiesTable, SWT.NONE);
		tc1.setText("Property");
		tc1.setWidth(200);
		tc1 = new TableColumn(propertiesTable, SWT.NONE);
		tc1.setText("Value");
		tc1.setWidth(400);
		propertiesTable.setHeaderVisible(true);
		addProperties(propertiesTable, "Location", new File(".")
				.getAbsolutePath(), null);
		// Services Properties
		label = new Label(parent, SWT.BOLD);
		label.setText("Services Providers");
		label.setBackground(darkBlue);
		label.setForeground(white);
		propertiesTable = new Table(parent, SWT.BORDER
				| SWT.FULL_SELECTION);
		propertiesTable.setLinesVisible(true);

		propertiesTable.setLayoutData(new GridData(GridData.FILL_HORIZONTAL
				| GridData.FILL_VERTICAL));

		tc1 = new TableColumn(propertiesTable, SWT.NONE);
		tc1.setText("Identifiers");
		tc1.setWidth(200);
		tc1 = new TableColumn(propertiesTable, SWT.NONE);
		tc1.setText("Providers");
		tc1.setWidth(400);
		propertiesTable.setHeaderVisible(true);

		iter = ICardRegistry.getInstance().getServiceProviders();
		i = 0;
		while (iter.hasNext()) {
			Object element = iter.next();
			IICardSelectorFactory cardSelectorFactory;
			try {
				cardSelectorFactory = (IICardSelectorFactory) element;
			} catch (ClassCastException e) {
				String name = "ICardRegistry.ServiceProviders[" + i + "]";
				i++;
				addProperties(propertiesTable, name, element.getClass()
						.toString(), null);
				continue;
			}
			addProperties(propertiesTable, cardSelectorFactory.getID(),
					cardSelectorFactory.getClass().toString(), null);
			IConfiguration configuration = cardSelectorFactory
					.getConfiguration();
			Iterator iterConf = configuration.getPropertyNames();
			while (iterConf.hasNext()) {
				Object key = iterConf.next();
				String value = configuration.getProperty(key.toString());
				addProperties(propertiesTable, "\t\t" + key, value, darkBlue);

			}

		}
		// ICard Providers
		label = new Label(parent, SWT.BOLD);
		label.setText("ICard Providers");
		label.setBackground(darkBlue);
		label.setForeground(white);
		propertiesTable = new Table(parent, SWT.BORDER | SWT.FULL_SELECTION);
		propertiesTable.setLinesVisible(true);

		propertiesTable.setLayoutData(new GridData(GridData.FILL_HORIZONTAL
				| GridData.FILL_VERTICAL));

		tc1 = new TableColumn(propertiesTable, SWT.NONE);
		tc1.setText("Identifiers");
		tc1.setWidth(200);
		tc1 = new TableColumn(propertiesTable, SWT.NONE);
		tc1.setText("Description");
		tc1.setWidth(400);
		propertiesTable.setHeaderVisible(true);
		iter = ICardRegistry.getInstance().getICardProviders();
		i = 0;
		while (iter.hasNext()) {
			Object element = iter.next();
			ICardProvider cardProvider = (ICardProvider) element;
			String name = "ICardRegistry.ICardProviders[" + i + "]";
			i++;
			addProperties(propertiesTable, cardProvider.getID(), cardProvider
					.getDescription(), null);
			IConfiguration configuration = cardProvider.getConfiguration();
			Iterator iterConf = configuration.getPropertyNames();
			while (iterConf.hasNext()) {
				Object key = iterConf.next();
				String value = configuration.getProperty(key.toString());
				addProperties(propertiesTable, "\t\t" + key, value, darkBlue);

			}
		}
		// ICardSelectorService
		label = new Label(parent, SWT.BOLD);
		label.setText("ICard Selector Service");
		label.setBackground(darkBlue);
		label.setForeground(white);
		propertiesTable = new Table(parent, SWT.BORDER | SWT.FULL_SELECTION);
		propertiesTable.setLinesVisible(true);

		propertiesTable.setLayoutData(new GridData(GridData.FILL_HORIZONTAL
				| GridData.FILL_VERTICAL));

		tc1 = new TableColumn(propertiesTable, SWT.NONE);
		tc1.setText("Identifiers");
		tc1.setWidth(200);
		tc1 = new TableColumn(propertiesTable, SWT.NONE);
		tc1.setText("Factory");
		tc1.setWidth(400);
		propertiesTable.setHeaderVisible(true);
		iter = ICardSelectorService.getInstance().getICardSelectorFactories();
		i = 0;
		while (iter.hasNext()) {
			Object element = iter.next();
			IICardSelectorFactory registryExtension = (IICardSelectorFactory) element;
			i++;
			addProperties(propertiesTable, registryExtension.getID(),
					registryExtension.getClass().getName(), null);
			IConfiguration configuration = registryExtension.getConfiguration();
			if (configuration != null) {
				Iterator iterConf = configuration.getPropertyNames();
				while (iterConf.hasNext()) {
					Object key = iterConf.next();
					String value = configuration.getProperty(key.toString());
					addProperties(propertiesTable, "\t\t" + key, value,
							darkBlue);
				}
			}
		}
	}

}
