/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tie Li  - Initial API and implementation
 *     Anthony bussani - change to show card properties
 *     Bruce Rich - only login to current i-card store
 *******************************************************************************/

package org.eclipse.higgins.crpps.ui.dialogs;

import org.eclipse.higgins.crpps.ui.CardListView;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * CHANGE LOG
 *   tili (2008-Jan-22): Remove the "STS configure" field, and put the configure folder into crpps/configuration.
 *	 brich (2008-Mar-04): Redesign the dialog to only deal with the icard file, add api to get currentIcard file name
 *   brich (2008-Mar-06): Change OK to Login
 */
public class LoginDialog  extends Dialog{
	
	public static int PICKANOTHERSTORE = 99;
	String DIFFCARDSTORE = "Choose a different card store";

	private String currentIcardFileS = "";
	private String passwd = "";
	private boolean setAsDefaultStore = false;
	private boolean pickADifferentStore = false;
	
	Text text1;
	Text text2;
	Text text3;
	
	public LoginDialog(Shell parentShell, String icardFilename) {
		super(parentShell);
		this.currentIcardFileS = icardFilename;
	}
	
	protected Control createDialogArea(Composite arg0) {

		Composite parent1 = (Composite) super.createDialogArea(arg0);
		parent1.setLayout(new FillLayout());
		Composite parent = new Composite(parent1, SWT.BORDER);
		//Composite parent1 = (Composite) super.createDialogArea(arg0);
		//parent1.setLayout(new FillLayout());
		//Composite parent = new Composite(arg0, SWT.BORDER);
		parent.setLayout(new FormLayout());
		//parent.setLayout(new FillLayout());
		
	    Label label = new Label(parent, SWT.WRAP);
		label.setText("Please enter the password for your current i-card store: ");
		text1 = new Text(parent, SWT.PASSWORD | SWT.BORDER);
		text1.setEchoChar('*');
		FormData fd = new FormData();
		fd.top = new FormAttachment(0, 5);
		fd.left = new FormAttachment(0, 5);
		fd.right = new FormAttachment(100, -5);
		label.setLayoutData(fd);
		fd = new FormData();
		fd.top = new FormAttachment(label, 5);
		fd.left = new FormAttachment(0, 5);
		fd.right = new FormAttachment(100, -5);
		text1.setEditable(true);
		text1.setLayoutData(fd);
		text1.addModifyListener(new ModifyListener(){
			public void modifyText(ModifyEvent e) {
				passwd = text1.getText();
			}
		});
		
//		Label label2 = new Label(parent, SWT.WRAP);
//		String baseS = "The currently-selected i-card store is: ";
//		String currICardStore = baseS+currentIcardFileS;
//		label2.setText(currICardStore);
//		fd = new FormData();
//		fd.top = new FormAttachment(text1, 5);
//		fd.left = new FormAttachment(0, 5);
//		fd.right = new FormAttachment(100, 5);
//		label2.setLayoutData(fd);
		
		Label label2 = new Label(parent, SWT.WRAP);
		String baseS = "The currently-selected i-card store is: ";
//		String currICardStore = baseS+currentIcardFileS;
//		label2.setText(currICardStore);
		label2.setText(baseS);
		fd = new FormData();
		fd.top = new FormAttachment(text1, 5);
		fd.left = new FormAttachment(0, 5);
		fd.right = new FormAttachment(100, 5);
		label2.setLayoutData(fd);
		
		Text text2 = new Text(parent, SWT.BORDER);
		text2.setEditable(false);
		text2.setEnabled(false);
		text2.setText(currentIcardFileS);
		fd = new FormData();
		fd.top = new FormAttachment(label2, 5);
		fd.left = new FormAttachment(0, 5);
		fd.right = new FormAttachment(100, 5);
		text2.setLayoutData(fd);
		
		final Button storeChooser = new Button(parent, SWT.NONE);
		storeChooser.setText(DIFFCARDSTORE);
		fd = new FormData();
		fd.top = new FormAttachment(text2, 5);
		storeChooser.setLayoutData(fd);
		storeChooser.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				pickADifferentStore = true;
				close();
			}
		});

		Button butt = new Button(parent, SWT.CHECK);
		butt.setText("Make this the default i-card store");
		butt.setEnabled(false);
		fd = new FormData();
		fd.top = new FormAttachment(storeChooser, 5);
		fd.left = new FormAttachment(0, 5);
		butt.setLayoutData(fd);
		butt.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent e) {
				setAsDefaultStore = true;
			}
			public void widgetDefaultSelected(SelectionEvent e) {
				setAsDefaultStore = true;
			}
		});
		
		final Label img_Label = new Label(parent, SWT.NONE);
		//img_Label.setLayoutData(new GridData(195, 181));
		img_Label.setImage(CardListView.MAUS); 
		fd = new FormData();
		fd.right = new FormAttachment(100, 0);
		fd.bottom = new FormAttachment(100, 0);
		img_Label.setLayoutData(fd);
//		fd = new FormData();
//		fd.top = new FormAttachment(label, 10);
//		fd.left = new FormAttachment(0, 5);
//		label2.setLayoutData(fd);
//		label2.setEnabled(false);
		
//		text1 = new Text(parent, SWT.BORDER);
//		fd = new FormData();
//		fd.top = new FormAttachment(label, 5);
//		fd.left = new FormAttachment(label2, 5);
//		fd.right = new FormAttachment(100, -10);
//		text1.setLayoutData(fd);
//		text1.setEnabled(false);
//		text1.addModifyListener(new ModifyListener(){
//			public void modifyText(ModifyEvent e) {
//				workdir = text1.getText();
//			}
//		});
		
//		Label label3 = new Label(parent, SWT.NONE);
//		label3.setText("STS config path: ");
//		fd = new FormData();
//		fd.top = new FormAttachment(label2, 10);
//		fd.left = new FormAttachment(0, 5);
//		label3.setLayoutData(fd);
//		label3.setEnabled(false);
//		
//		text2 = new Text(parent, SWT.BORDER);
//		fd = new FormData();
//		fd.top = new FormAttachment(label3, 10);
//		fd.left = new FormAttachment(0, 5);
//		fd.right = new FormAttachment(100, -10);
//		text2.setLayoutData(fd);
//		text2.setEditable(false);
//		text2.addModifyListener(new ModifyListener(){
//			public void modifyText(ModifyEvent e) {
//				//config = text2.getText();
//			}
//		});
		
		
//		Label label4 = new Label(parent, SWT.NONE);
//		label4.setText("Please enter the password for your current i-card store");
//		fd = new FormData();
//		fd.top = new FormAttachment(text2, 10);
//		fd.left = new FormAttachment(0,5);
//		label4.setLayoutData(fd);
//		
//		text3 = new Text(parent, SWT.BORDER);
//		text3.setEchoChar('*');
//		fd = new FormData();
//		fd.top = new FormAttachment(text2, 10);
//		fd.left = new FormAttachment(label4, 5);
//		fd.right = new FormAttachment(100, -10);
//		text3.setLayoutData(fd);
//		text3.addModifyListener(new ModifyListener(){
//			public void modifyText(ModifyEvent e) {
//				passwd = text3.getText();
//			}
//		});
	
		//return super.createDialogArea(arg0);
		return parent;
	}
	
	protected void createButtonsForButtonBar(Composite parent) {
		// create Login and Cancel buttons by default
		//String DIFFCARDSTORE = "C";
		createButton(parent, IDialogConstants.OK_ID, "Login",
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
//		createButton(parent, LoginDialog.PICKANOTHERSTORE,
//				DIFFCARDSTORE, false);
	}

	protected void okPressed() {
		//regBHO();
		super.okPressed();
	}

	protected void configureShell(Shell arg0) {
		super.configureShell(arg0);
		arg0.setText("Higgins Identity Selector");
		//arg0.setSize(400, 250);
		arg0.setSize(400, 375);
	}

	public String getPasswd() {
	    return passwd;
	}
	
	public String getCurrentIcardStore() {
		return currentIcardFileS;
	}
	
	public boolean pickADifferentStore() {
		return pickADifferentStore;
	}
	
	public boolean isDefaultStore() {
		return setAsDefaultStore;
	}

//	private void regBHO(){
//		try {
//			RegistryKey rk = Registry.HKEY_CLASSES_ROOT.openSubKey("CLSID");
//			RegistryKey rk_class = rk.createSubKey("{9047AE90-4776-471C-9618-639C02F40B67}", "");
//			rk_class.setValue(new RegStringValue(rk_class, "", "HBXBHO Class"));
//			rk_class.setValue(new RegStringValue(rk_class, "AppID", "{8CA3E506-0FD2-41DE-9420-84528D9BA483}"));
//			
//			RegistryKey rk_class_1 = rk_class.createSubKey("InprocServer32", "");
//			rk_class_1.setValue(new RegStringValue(rk_class_1, "", this.dllpath));
//			rk_class_1.setValue(new RegStringValue(rk_class_1, "ThreadingModel", "Apartment"));
//			rk_class_1.closeKey();
//			
//			RegistryKey rk_class_2 = rk_class.createSubKey("ProgID", "");
//			rk_class_2.setValue(new RegStringValue(rk_class_2, "", "HBX.HBXBHO.1"));
//			rk_class_2.closeKey();
//			
//			RegistryKey rk_class_3 = rk_class.createSubKey("TypeLib", "");
//			rk_class_3.setValue(new RegStringValue(rk_class_3, "", "{589D7673-0D91-4857-95C4-12230E99C16D}"));
//			rk_class_3.closeKey();
//			
//			rk_class.closeKey();
//			rk.closeKey();
//			
//			rk = Registry.HKEY_LOCAL_MACHINE.openSubKey("Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Browser Helper Objects");
//			RegistryKey rk_bho = rk.createSubKey("{9047AE90-4776-471C-9618-639C02F40B67}", "");
//			rk_bho.setValue(new RegStringValue(rk_bho, "", "HBXBHO"));
//			rk_bho.setValue(new RegDWordValue(rk_bho, "NoExplorer", RegistryValue.REG_DWORD, 1));
//			rk_bho.closeKey();
//			
//			rk.closeKey();
//		} catch (NoSuchKeyException e) {
//			e.printStackTrace();
//		} catch (RegistryException e) {
//			e.printStackTrace();
//		}
//	}
	
	public void setShellLocation() {
		Shell shell = getShell();
		Composite parent = getParentShell();
		if (parent == null) {
			IWorkbench workbench = PlatformUI.getWorkbench();
			IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
			parent = window.getShell();
		}
		Point parentLocation = parent.getLocation();
		Point parentSize = parent.getSize();
		int x = ((parentSize.x - shell.getSize().x) / 2) + parentLocation.x;
		int y = ((parentSize.y - shell.getSize().y) / 2) + parentLocation.y;
		shell.setLocation(x, y);
	}
}
