/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Tie Li (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 
package org.eclipse.higgins.crpps.app;

import java.io.File;
import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.higgins.crpps.util.SaveProperties;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

/**
 * This class controls all aspects of the application's execution
 */
public class Application implements IPlatformRunnable {

    private static Log log = LogFactory.getLog(Application.class);

    private static final String PROPERTIES_FILE = "crpps.properties";

    public static String savedLastRepository;

    public static ArrayList savedHistoryRepository = new ArrayList();

    SaveProperties saveProperties;

    void start() {
	try {
	    saveProperties = new SaveProperties(this, "saved", new File(
		    PROPERTIES_FILE));
	    log.info("loading properties from:"
		    + new File(PROPERTIES_FILE).getAbsolutePath());
	} catch (Exception e) {
	    log.error("Error when reading properties", e);
	}
    }

    public void shutdown() {
	try {
	    saveProperties.save("CRPPS");
	    log.info("saving properties from:"
		    + new File(PROPERTIES_FILE).getAbsolutePath());
	} catch (Exception e) {
	    log.error("Error when saving properties", e);
	}
    }


	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IPlatformRunnable#run(java.lang.Object)
	 */
	public Object run(Object args) throws Exception {
		//org.apache.log4j.PropertyConfigurator.configure("D:/log4j.properties");
		Display display = PlatformUI.createDisplay();
		try {
		    	start();
			int returnCode = PlatformUI.createAndRunWorkbench(display, new ApplicationWorkbenchAdvisor());
			if (returnCode == PlatformUI.RETURN_RESTART) {
				return IPlatformRunnable.EXIT_RESTART;
			}
			shutdown();
			return IPlatformRunnable.EXIT_OK;
		} finally {
			display.dispose();
		}
	}
}
