/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tie Li  - Initial API and implementation
 *     Anthony Bussani - change in card list mgmt, adding cardstore functions
 *     Bruce Rich - added browse and edit stacklayout
 *******************************************************************************/

package org.eclipse.higgins.crpps.ui;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class CardEditView extends ViewPart implements ICardEditView, ISelectionChangedListener {

	private Log log = LogFactory.getLog(CardEditView.class);

	private StackLayout layout; // allow both browse and edit views of cards
	// according to ApplicationWorkbenchWindowAdvisor, our workarea is 400x700
	private ICardEdit browser;
	private ICardEdit editor;
	private CardListComposite listsummary;
	private ICardEdit blankComposite;
	private Composite parentComposite;
	private FormToolkit toolkit;
	
	private boolean isEditable;

	public CardEditView() {
		CardListView.observerPart = this;
		layout = new StackLayout();
	}

	private void reset() {
		log.info("reset");
		isEditable = false;
		editor.reset();
		browser.reset();
		listsummary.reset();
		// return to blank
		layout.topControl = blankComposite.getComposite();
		parentComposite.layout();
	}

	public void createPartControl(Composite parent) {
		parentComposite = parent;
		toolkit = new FormToolkit(parent.getDisplay());
		browser = new BrowseComposite(parentComposite, this, toolkit);
		editor = new EditComposite(parentComposite, this, toolkit);
		listsummary = new CardListComposite(parentComposite, this, toolkit);
		blankComposite = new BlankComposite(parentComposite, this, toolkit);
		parentComposite.setLayout(layout);
		CardListView.getInstance().addSelectionChangedListener(this);
	}

	public void setFocus() {
	}

	public void setEditable(boolean editable) {
		this.isEditable = editable;
	}

	public boolean getEditable() {
		return isEditable;
	}

	public boolean isCardDirty() {
		return editor.isCardDirty() | browser.isCardDirty();
	}

	/**
	 * Switch to the editor and display
	 */
	public void modify() {
		log.info("modify");
		layout.topControl = this.editor.getComposite();
		parentComposite.layout();
	}
	
	/**
	 * Switch to browse and display
	 */
	public void browse() {
		log.info("browse");
		layout.topControl = this.browser.getComposite();
		parentComposite.layout();
	}
	
	/**
	 * Switch to listsummary and display
	 */
	public void browselist() {
		log.info("browselist");
		layout.topControl = this.listsummary.getComposite();
		parentComposite.layout();
	}


	public void dispose() {
		toolkit.dispose();
		super.dispose();
	}
	
	/**
	 * React to reset events only.
	 */
	public void selectionChanged(SelectionChangedEvent event) {
		if (event.getSelection() instanceof CardSelection) {
			CardSelection cs = (CardSelection)event.getSelection();
			switch  (cs.getSelType()) {
			case CardSelection.TYPE_RESET :
				reset();
				break;
			}
		}
	}

}