/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Tie Li (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.crpps.service;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.provider.cardspace.common.CardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.PersonalCard;
import org.eclipse.higgins.iss.CredentialContainer;
import org.eclipse.higgins.iss.ICardSelectorService;
import org.eclipse.higgins.iss.IICardSelector;
import org.eclipse.higgins.iss.IICardSelectorFactory;
import org.eclipse.higgins.iss.IIdentityToken;
import org.eclipse.higgins.iss.SelectionANDofORs;
import org.eclipse.higgins.iss.SelectionANDofORsElm;
import org.eclipse.higgins.iss.UCTelm;
import org.eclipse.higgins.iss.UserChoiceTree;
import org.eclipse.higgins.sts.utilities.CertificateHelper;

public class InfoCardModel {
	private Log log = LogFactory.getLog(InfoCardModel.class);
	private String CREDENTIAL_DB = "";
	private String PK_DB = "";
		
	public UserInterfaceInfoBean handleUIRequest(String url, IPolicy policy, 
			String policyType, String target) {						
		UserInterfaceInfoBean uiib = new UserInterfaceInfoBean();
		
/*		CallbackHandler handler = new CallbackHandler() {
			public void handle(Callback[] callbacks) 
				throws IOException, UnsupportedCallbackException {
				log.info("call back handler does not take effect yet.");
			}
		};*/
		
		//Select the matched card, and put into uiib.
		Iterator iter = ICardSelectorService.getInstance()
			.getICardSelectorFactories();
		while (iter.hasNext()) {
			Object element = iter.next();
			IICardSelectorFactory selectorFactory = (IICardSelectorFactory) element;
			log.info("Current Selector:"+selectorFactory.getID());						
			try {
				IICardSelector selector = selectorFactory
						.getICardSelector(null,policy);
				UserChoiceTree uct = selector.getUserChoice();

				uiib.setUCL(uct);
				X509Certificate sslCert = CertificateHelper.fromString(getRPCert());
				uiib.setCertificate(sslCert);
				//return uiib;
			} catch (Exception ee) {
				log.error("Handle UI request error", ee);
			} 
		}
		
		//Select all cards, by provide a policy with zero requirement.
		CardSpacePolicy csp = new CardSpacePolicy();
		iter = ICardSelectorService.getInstance().getICardSelectorFactories();
		while (iter.hasNext()) {
			Object element = iter.next();
			IICardSelectorFactory selectorFactory = (IICardSelectorFactory) element;
			log.info("Current Selector:"+selectorFactory.getID());						
			try {
				IICardSelector selector = selectorFactory.getICardSelector(null,csp);
				UserChoiceTree uct = selector.getUserChoice();
				ListIterator orNodes = uct.getListIterator();
				while(orNodes!=null && orNodes.hasNext()){
					Object obj = orNodes.next();
					if(obj instanceof UserChoiceTree){
						UserChoiceTree orTree = (UserChoiceTree)obj;
						ListIterator termNodes = orTree.getListIterator();
						while(termNodes!=null && termNodes.hasNext()){
							Object sub_obj = termNodes.next();
							if(sub_obj instanceof UCTelm){
								UCTelm ucTelm = (UCTelm) sub_obj;											
								Iterator iter_cards = ucTelm.getCredsIterator();
								while(iter_cards!=null && iter_cards.hasNext()){
									CredentialContainer cc = (CredentialContainer) iter_cards.next();
									ICard icard = cc.getCredential();
									uiib.addUnmatched_card(icard);
								}								
							}					
						}
					}			
				}
				
			} catch (Exception ee) {
				log.error("Handle UI request error", ee);
			} 
		}
		
		return uiib;
	}
	
	
		
	public SecurityTokenBean handleGetTokenRequest(ICard card, 
			String url, CardSpacePolicy policy, String policytype,
			String pinCode) throws Exception{
		SelectionANDofORs selection = new SelectionANDofORs();    	
    	selection.optionalClaims = true;
		selection.idemix_credential_db_uri = CREDENTIAL_DB;
		selection.publickey_db_uri = PK_DB;		
		//String cert = (String)InfoCardController.getInst().get_rp_list().get(0);
		//selection.sslCert  = CertificateHelper.fromString(cert);
		
		List certs = InfoCardController.getInst().get_rp_list();
		if(certs!=null && certs.size()>0){
			selection.sslCertChain = new X509Certificate[certs.size()];
			for(int i=0; i<certs.size(); i++){
				String cert_str = (String) certs.get(i);
				(selection.sslCertChain)[i] = CertificateHelper.fromString(cert_str);
			}
		}
		
		selection.action   = url;
		
		ICredentialDescriptor [] credDescr = card.getRequiredCredentials();
		if(credDescr!=null){
			ICredential cred = credDescr[0].getCredential();
			selection.setCredential(cred);
		}
		
		if(card instanceof PersonalCard){
			PersonalCard pcard = (PersonalCard) card;			
			if(PersonalCard.LOCKED == pcard.getPinStatus()){
				final byte[] fpinCode = pinCode.getBytes("UTF-8");
				IPinCodeCredential ipc = new IPinCodeCredential(){
					public byte[] getPinCode() {
						return fpinCode;
					}
					public void setPinCode(byte[] pin) {}
					public Callback[] getCallbacks() {return null;}
				};
				selection.setCredential(ipc);
			}	
		}
				
    	SelectionANDofORsElm se = new SelectionANDofORsElm(card.getCUID().toString(),0,0);
    	selection.add(se);
    	
		CallbackHandler handler = new CallbackHandler() {
			public void handle(Callback[] callbacks) 
			throws IOException, UnsupportedCallbackException {
				log.info("call back handler does not take effect yet");
			}
		};
			
		IICardSelector selector = ICardSelectorService.getInstance()
				.getICardSelector(handler, policy);
		IIdentityToken token = selector.getIdentityToken(selection);
		String tok = (String) token.getAs(String.class);
			    
		/// This must be done before the Token is handed off to a 
		/// Browser to be POSTed to the RP.
		/*
		org.eclipse.higgins.sts.api.IConstants constants = 
				new org.eclipse.higgins.sts.common.Constants();
		final org.apache.axiom.om.OMElement omRequestedSecurityToken = 
				(org.apache.axiom.om.OMElement)token
					.getAs(org.apache.axiom.om.OMElement.class);
		final javax.xml.namespace.QName qnameEncryptedData = 
				new javax.xml.namespace.QName(
					constants.getXMLEncryptionNamespace().toString(), "EncryptedData"); 	
		final javax.xml.namespace.QName qnameSAMLAssertion = 
				new javax.xml.namespace.QName(
					constants.getSAML10Namespace().toString(), "Assertion"); 
		final org.apache.axiom.om.OMElement omReturnedSAMLAssertion = 
				omRequestedSecurityToken.getFirstChildWithName(qnameSAMLAssertion);
		org.apache.axiom.om.OMElement omEncryptedSecurityToken = null;
		if (null != omReturnedSAMLAssertion){
			org.eclipse.higgins.sts.api.IElement elemToken = 
					new org.eclipse.higgins.sts.common.Element();
			elemToken.set(tok);
			XMLSecurityApacheExtension xmlSecurity = new XMLSecurityApacheExtension();
			final org.eclipse.higgins.sts.api.IElement 
				elemEncryptedRequestedSecurityToken = 
					xmlSecurity.EncryptElement("saml:Assertion", elemToken, getRPCert());
			final org.apache.axiom.om.OMElement omEncryptedRequestedSecurityToken = 
				(org.apache.axiom.om.OMElement)elemEncryptedRequestedSecurityToken.getAs(org.apache.axiom.om.OMElement.class);
			omEncryptedSecurityToken = 
				omEncryptedRequestedSecurityToken.getFirstElement();
			tok = org.eclipse.higgins.sts.utilities.XMLHelper
				.toString(omEncryptedSecurityToken);
			log.info("Encrypted Token: " + tok);
		}	
		*/
			    
		org.eclipse.higgins.iss.IDisplayToken dtok_raw = 
			(org.eclipse.higgins.iss.IDisplayToken) 
			    token.getAs(org.eclipse.higgins.iss.IDisplayToken.class);
			
		SecurityTokenBean stb = new SecurityTokenBean();
		stb.setSecurityToken(tok);
		stb.setDisplayToken(dtok_raw);
		return stb;		
	}
	
	private String getRPCert(){
		return (String)InfoCardController.getInst().get_rp_list().get(0);
	}
}
