/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Anthony Bussani (IBM Research) - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.crpps.ui;

import java.io.InputStream;
import java.net.URL;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;


/**
 * @author bus at zurich dot ibm dot com
 *
 */
public class Utils {
    
	private static Log log = LogFactory.getLog( Utils.class);
	
	/**
	 * load an image from the classpath, an empty image will be return in case
	 * of no success.
	 * 
	 * @param filename
	 * @return
	 */
	public static Image loadImage(String filename) {
		
		Image image = null;
		try {
			URL url = FileLocator.find(Platform.getBundle("org.eclipse.higgins.crpps"), new Path(filename), null);
			ImageDescriptor imageDesc = ImageDescriptor.createFromURL(url);
			image = imageDesc.createImage();
		} catch (Exception e) {
			MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), SWT.ERROR_IO);
			messageBox.setMessage("Error when loading image: " + filename + "\n\n"
					+ e);
			messageBox.setText("Error while creating");
			messageBox.open();
			log
					.error("Error when loading image [" + filename + "]",
							e);
			image = new Image(Display.getCurrent(), 1, 1);
		}
//		try {			
//			image = new Image(Display.getCurrent(), CardListView.class
//					.getResourceAsStream(filename));
//		} catch (Exception e) {
//			MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), SWT.ERROR_IO);
//			messageBox.setMessage("Error when loading image: " + filename + "\n\n"
//					+ e);
//			messageBox.setText("Error while creating");
//			messageBox.open();
//			log
//					.error("Error when loading image [" + filename + "]",
//							e);
//			image = new Image(Display.getCurrent(), 1, 1);
//		}
		return image;
	}

	public static byte[] rawBytes(String filename) {
		byte[] data = null;
		try {
			InputStream is = FileLocator.openStream(Platform.getBundle("org.eclipse.higgins.crpps"), new Path(filename), false);
			int size = is.available();
			data = new byte[size];
			int read = 0, cursor = 0;
			while (true) {
				read = is.read(data, cursor, size-cursor);
				if ((read == 0) || (read == -1))
					break;
				cursor += read;
			}
		} catch (Exception e) {
			log.error("Error retrieving raw bytes", e);
		}
		return data;
	}
}
