/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tie Li  - Initial API and implementation
 *     Anthony bussani - change to show card properties
 *******************************************************************************/

package org.eclipse.higgins.crpps.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * CHANGE LOG
 *   tili (2008-Jan-22): Remove the "STS configure" field, and put the configure folder into crpps/configuration.
 *
 */
public class WelcomeDialog  extends Dialog{

	public String workdir = "";
	//public String config = "";
	public String passwd = "";
	
	Text text1;
	Text text2;
	Text text3;
	
	public WelcomeDialog(Shell parentShell) {
		super(parentShell);
	}
	
	protected Control createDialogArea(Composite arg0) {

		Composite parent1 = (Composite) super.createDialogArea(arg0);
		parent1.setLayout(new FillLayout());
		Composite parent = new Composite(parent1, SWT.BORDER);
		parent.setLayout(new FormLayout());
		
		Label label = new Label(parent, SWT.NONE);
		label.setText("Please input the config files' path:");
		FormData fd = new FormData();
		fd.top = new FormAttachment(0, 5);
		fd.left = new FormAttachment(0, 5);
		label.setLayoutData(fd);
		
		Label label2 = new Label(parent, SWT.NONE);
		label2.setText("Card store path: ");
		fd = new FormData();
		fd.top = new FormAttachment(label, 10);
		fd.left = new FormAttachment(0, 5);
		label2.setLayoutData(fd);
		label2.setEnabled(false);
		
		text1 = new Text(parent, SWT.BORDER);
		fd = new FormData();
		fd.top = new FormAttachment(label, 5);
		fd.left = new FormAttachment(label2, 5);
		fd.right = new FormAttachment(100, -10);
		text1.setLayoutData(fd);
		text1.setEnabled(false);
		text1.addModifyListener(new ModifyListener(){
			public void modifyText(ModifyEvent e) {
				workdir = text1.getText();
			}
		});
		
		Label label3 = new Label(parent, SWT.NONE);
		label3.setText("STS config path: ");
		fd = new FormData();
		fd.top = new FormAttachment(text1, 10);
		fd.left = new FormAttachment(0, 5);
		label3.setLayoutData(fd);
		label3.setEnabled(false);
		
		text2 = new Text(parent, SWT.BORDER);
		fd = new FormData();
		fd.top = new FormAttachment(text1, 10);
		fd.left = new FormAttachment(label3, 5);
		fd.right = new FormAttachment(100, -10);
		text2.setLayoutData(fd);
		text2.setEditable(false);
		text2.addModifyListener(new ModifyListener(){
			public void modifyText(ModifyEvent e) {
				//config = text2.getText();
			}
		});
		
		
		Label label4 = new Label(parent, SWT.NONE);
		label4.setText("Store Password:  ");
		fd = new FormData();
		fd.top = new FormAttachment(text2, 10);
		fd.left = new FormAttachment(0,5);
		label4.setLayoutData(fd);
		
		text3 = new Text(parent, SWT.BORDER);
		text3.setEchoChar('*');
		fd = new FormData();
		fd.top = new FormAttachment(text2, 10);
		fd.left = new FormAttachment(label4, 5);
		fd.right = new FormAttachment(100, -10);
		text3.setLayoutData(fd);
		text3.addModifyListener(new ModifyListener(){
			public void modifyText(ModifyEvent e) {
				passwd = text3.getText();
			}
		});
	
		return super.createDialogArea(arg0);
	}

	protected void okPressed() {
		//regBHO();
		super.okPressed();
	}

	protected void configureShell(Shell arg0) {
		super.configureShell(arg0);
		arg0.setText("Set configuration");
		arg0.setSize(400, 250);
	}

	public String getPasswd() {
	    return passwd;
	}

//	private void regBHO(){
//		try {
//			RegistryKey rk = Registry.HKEY_CLASSES_ROOT.openSubKey("CLSID");
//			RegistryKey rk_class = rk.createSubKey("{9047AE90-4776-471C-9618-639C02F40B67}", "");
//			rk_class.setValue(new RegStringValue(rk_class, "", "HBXBHO Class"));
//			rk_class.setValue(new RegStringValue(rk_class, "AppID", "{8CA3E506-0FD2-41DE-9420-84528D9BA483}"));
//			
//			RegistryKey rk_class_1 = rk_class.createSubKey("InprocServer32", "");
//			rk_class_1.setValue(new RegStringValue(rk_class_1, "", this.dllpath));
//			rk_class_1.setValue(new RegStringValue(rk_class_1, "ThreadingModel", "Apartment"));
//			rk_class_1.closeKey();
//			
//			RegistryKey rk_class_2 = rk_class.createSubKey("ProgID", "");
//			rk_class_2.setValue(new RegStringValue(rk_class_2, "", "HBX.HBXBHO.1"));
//			rk_class_2.closeKey();
//			
//			RegistryKey rk_class_3 = rk_class.createSubKey("TypeLib", "");
//			rk_class_3.setValue(new RegStringValue(rk_class_3, "", "{589D7673-0D91-4857-95C4-12230E99C16D}"));
//			rk_class_3.closeKey();
//			
//			rk_class.closeKey();
//			rk.closeKey();
//			
//			rk = Registry.HKEY_LOCAL_MACHINE.openSubKey("Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Browser Helper Objects");
//			RegistryKey rk_bho = rk.createSubKey("{9047AE90-4776-471C-9618-639C02F40B67}", "");
//			rk_bho.setValue(new RegStringValue(rk_bho, "", "HBXBHO"));
//			rk_bho.setValue(new RegDWordValue(rk_bho, "NoExplorer", RegistryValue.REG_DWORD, 1));
//			rk_bho.closeKey();
//			
//			rk.closeKey();
//		} catch (NoSuchKeyException e) {
//			e.printStackTrace();
//		} catch (RegistryException e) {
//			e.printStackTrace();
//		}
//	}
}
