/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.StageElement;
import com.hp.hpl.jena.mem.HashCommon;
import com.hp.hpl.jena.mem.MatchOrBind;
import com.hp.hpl.jena.mem.TripleBunch;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ConcurrentModificationException;

public class HashedTripleBunch
extends HashCommon
implements TripleBunch {
    public HashedTripleBunch(TripleBunch b) {
        super(HashedTripleBunch.nextSize((int)((double)b.size() / 0.5)));
        ExtendedIterator it = b.iterator();
        while (it.hasNext()) {
            this.add((Triple)it.next());
        }
        this.changes = 0;
    }

    public boolean contains(Triple t) {
        return this.findSlot(t) < 0;
    }

    protected int findSlotBySameValueAs(Triple key) {
        int index = this.initialIndexFor(key);
        Object current;
        while ((current = this.keys[index]) != null) {
            if (key.matches((Triple)current)) {
                return ~index;
            }
            if (--index >= 0) continue;
            index += this.capacity;
        }
        return index;
    }

    public boolean containsBySameValueAs(Triple t) {
        return this.findSlotBySameValueAs(t) < 0;
    }

    public int size() {
        return this.size;
    }

    public int currentCapacity() {
        return this.capacity;
    }

    public void add(Triple t) {
        this.keys[this.findSlot((Object)t)] = t;
        ++this.changes;
        if (++this.size > this.threshold) {
            this.grow();
        }
    }

    protected void grow() {
        Object[] oldContents = this.keys;
        int oldCapacity = this.capacity;
        this.growCapacityAndThreshold();
        this.keys = new Triple[this.capacity];
        Triple[] newKeys = this.keys;
        for (int i = 0; i < oldCapacity; ++i) {
            Object t = oldContents[i];
            if (t == null) continue;
            newKeys[this.findSlot((Object)t)] = t;
        }
    }

    public void remove(Triple t) {
        this.removeFrom(~this.findSlot(t));
        ++this.changes;
    }

    public ExtendedIterator iterator() {
        return this.iterator(HashCommon.NotifyEmpty.ignore);
    }

    public ExtendedIterator iterator(HashCommon.NotifyEmpty container) {
        return this.keyIterator(container);
    }

    public void app(Domain d, StageElement next, MatchOrBind s) {
        int i = this.capacity;
        int initialChanges = this.changes;
        while (i > 0) {
            Object t;
            if (this.changes > initialChanges) {
                throw new ConcurrentModificationException();
            }
            if ((t = this.keys[--i]) == null || !s.matches((Triple)t)) continue;
            next.run(d);
        }
    }
}

