/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedDouble;

public class WaitableDouble
extends SynchronizedDouble {
    public WaitableDouble(double initialValue) {
        super(initialValue);
    }

    public WaitableDouble(double initialValue, Object lock) {
        super(initialValue, lock);
    }

    public double set(double newValue) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            double d = super.set(newValue);
            return d;
        }
    }

    public boolean commit(double assumedValue, double newValue) {
        Object object = this.lock_;
        synchronized (object) {
            boolean success = super.commit(assumedValue, newValue);
            if (success) {
                this.lock_.notifyAll();
            }
            boolean bl = success;
            return bl;
        }
    }

    public double add(double amount) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            double d = super.add(amount);
            return d;
        }
    }

    public double subtract(double amount) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            double d = super.subtract(amount);
            return d;
        }
    }

    public double multiply(double factor) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            double d = super.multiply(factor);
            return d;
        }
    }

    public double divide(double factor) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            double d = super.divide(factor);
            return d;
        }
    }

    public void whenEqual(double c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ != c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenNotEqual(double c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ == c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenLessEqual(double c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (!(this.value_ <= c)) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenLess(double c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (!(this.value_ < c)) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenGreaterEqual(double c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (!(this.value_ >= c)) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenGreater(double c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (!(this.value_ > c)) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }
}

