/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedFloat;

public class WaitableFloat
extends SynchronizedFloat {
    public WaitableFloat(float initialValue) {
        super(initialValue);
    }

    public WaitableFloat(float initialValue, Object lock) {
        super(initialValue, lock);
    }

    public float set(float newValue) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            float f = super.set(newValue);
            return f;
        }
    }

    public boolean commit(float assumedValue, float newValue) {
        Object object = this.lock_;
        synchronized (object) {
            boolean success = super.commit(assumedValue, newValue);
            if (success) {
                this.lock_.notifyAll();
            }
            boolean bl = success;
            return bl;
        }
    }

    public float add(float amount) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            float f = super.add(amount);
            return f;
        }
    }

    public float subtract(float amount) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            float f = super.subtract(amount);
            return f;
        }
    }

    public float multiply(float factor) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            float f = super.multiply(factor);
            return f;
        }
    }

    public float divide(float factor) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            float f = super.divide(factor);
            return f;
        }
    }

    public void whenEqual(float c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ != c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenNotEqual(float c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ == c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenLessEqual(float c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (!(this.value_ <= c)) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenLess(float c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (!(this.value_ < c)) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenGreaterEqual(float c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (!(this.value_ >= c)) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenGreater(float c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (!(this.value_ > c)) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }
}

